/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.ArrayActions;
import io.tiledb.cloud.rest_api.model.GroupActions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Encapsulates information regarding inviting people using email to share group, same permissions for all invitees")
public class InvitationGroupShareEmail {
    public static final String SERIALIZED_NAME_ARRAY_ACTIONS = "array_actions";
    @SerializedName(value="array_actions")
    private List<ArrayActions> arrayActions = new ArrayList<ArrayActions>();
    public static final String SERIALIZED_NAME_GROUP_ACTIONS = "group_actions";
    @SerializedName(value="group_actions")
    private List<GroupActions> groupActions = new ArrayList<GroupActions>();
    public static final String SERIALIZED_NAME_INVITEE_EMAIL_OR_NAME = "invitee_email_or_name";
    @SerializedName(value="invitee_email_or_name")
    private List<String> inviteeEmailOrName = new ArrayList<String>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InvitationGroupShareEmail arrayActions(List<ArrayActions> arrayActions) {
        this.arrayActions = arrayActions;
        return this;
    }

    public InvitationGroupShareEmail addArrayActionsItem(ArrayActions arrayActionsItem) {
        this.arrayActions.add(arrayActionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[read, write]", required=true, value="List of permitted array actions")
    public List<ArrayActions> getArrayActions() {
        return this.arrayActions;
    }

    public void setArrayActions(List<ArrayActions> arrayActions) {
        this.arrayActions = arrayActions;
    }

    public InvitationGroupShareEmail groupActions(List<GroupActions> groupActions) {
        this.groupActions = groupActions;
        return this;
    }

    public InvitationGroupShareEmail addGroupActionsItem(GroupActions groupActionsItem) {
        this.groupActions.add(groupActionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[read, write]", required=true, value="List of permitted group actions")
    public List<GroupActions> getGroupActions() {
        return this.groupActions;
    }

    public void setGroupActions(List<GroupActions> groupActions) {
        this.groupActions = groupActions;
    }

    public InvitationGroupShareEmail inviteeEmailOrName(List<String> inviteeEmailOrName) {
        this.inviteeEmailOrName = inviteeEmailOrName;
        return this;
    }

    public InvitationGroupShareEmail addInviteeEmailOrNameItem(String inviteeEmailOrNameItem) {
        this.inviteeEmailOrName.add(inviteeEmailOrNameItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public List<String> getInviteeEmailOrName() {
        return this.inviteeEmailOrName;
    }

    public void setInviteeEmailOrName(List<String> inviteeEmailOrName) {
        this.inviteeEmailOrName = inviteeEmailOrName;
    }

    public InvitationGroupShareEmail putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvitationGroupShareEmail invitationGroupShareEmail = (InvitationGroupShareEmail)o;
        return Objects.equals(this.arrayActions, invitationGroupShareEmail.arrayActions) && Objects.equals(this.groupActions, invitationGroupShareEmail.groupActions) && Objects.equals(this.inviteeEmailOrName, invitationGroupShareEmail.inviteeEmailOrName) && Objects.equals(this.additionalProperties, invitationGroupShareEmail.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.arrayActions, this.groupActions, this.inviteeEmailOrName, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvitationGroupShareEmail {\n");
        sb.append("    arrayActions: ").append(this.toIndentedString(this.arrayActions)).append("\n");
        sb.append("    groupActions: ").append(this.toIndentedString(this.groupActions)).append("\n");
        sb.append("    inviteeEmailOrName: ").append(this.toIndentedString(this.inviteeEmailOrName)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InvitationGroupShareEmail is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARRAY_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_ARRAY_ACTIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARRAY_ACTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `array_actions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARRAY_ACTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUP_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_GROUP_ACTIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUP_ACTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `group_actions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP_ACTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVITEE_EMAIL_OR_NAME) != null && !jsonObj.get(SERIALIZED_NAME_INVITEE_EMAIL_OR_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INVITEE_EMAIL_OR_NAME).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `invitee_email_or_name` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INVITEE_EMAIL_OR_NAME).toString()));
        }
    }

    public static InvitationGroupShareEmail fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, InvitationGroupShareEmail.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ARRAY_ACTIONS);
        openapiFields.add(SERIALIZED_NAME_GROUP_ACTIONS);
        openapiFields.add(SERIALIZED_NAME_INVITEE_EMAIL_OR_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ARRAY_ACTIONS);
        openapiRequiredFields.add(SERIALIZED_NAME_GROUP_ACTIONS);
        openapiRequiredFields.add(SERIALIZED_NAME_INVITEE_EMAIL_OR_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!InvitationGroupShareEmail.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<InvitationGroupShareEmail> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(InvitationGroupShareEmail.class));
            return new TypeAdapter<InvitationGroupShareEmail>(){

                @Override
                public void write(JsonWriter out, InvitationGroupShareEmail value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public InvitationGroupShareEmail read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InvitationGroupShareEmail.validateJsonObject(jsonObj);
                    InvitationGroupShareEmail instance = (InvitationGroupShareEmail)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

