/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.ActivityEventType;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information related to last access of an array")
public class LastAccessedArray {
    public static final String SERIALIZED_NAME_ARRAY_ID = "array_id";
    @SerializedName(value="array_id")
    private String arrayId;
    public static final String SERIALIZED_NAME_ARRAY_NAME = "array_name";
    @SerializedName(value="array_name")
    private String arrayName;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    private String namespace;
    public static final String SERIALIZED_NAME_ACCESSED_TIME = "accessed_time";
    @SerializedName(value="accessed_time")
    private BigDecimal accessedTime;
    public static final String SERIALIZED_NAME_ACCESS_TYPE = "access_type";
    @SerializedName(value="access_type")
    private ActivityEventType accessType;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public LastAccessedArray arrayId(String arrayId) {
        this.arrayId = arrayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="unique ID of array")
    public String getArrayId() {
        return this.arrayId;
    }

    public void setArrayId(String arrayId) {
        this.arrayId = arrayId;
    }

    public LastAccessedArray arrayName(String arrayName) {
        this.arrayName = arrayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="array1", value="name of the array")
    public String getArrayName() {
        return this.arrayName;
    }

    public void setArrayName(String arrayName) {
        this.arrayName = arrayName;
    }

    public LastAccessedArray namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="mockuser", value="namespace of a user or organization")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public LastAccessedArray accessedTime(BigDecimal accessedTime) {
        this.accessedTime = accessedTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1540471791873", value="timestamp (epoch milliseconds) array is last accessed")
    public BigDecimal getAccessedTime() {
        return this.accessedTime;
    }

    public void setAccessedTime(BigDecimal accessedTime) {
        this.accessedTime = accessedTime;
    }

    public LastAccessedArray accessType(ActivityEventType accessType) {
        this.accessType = accessType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ActivityEventType getAccessType() {
        return this.accessType;
    }

    public void setAccessType(ActivityEventType accessType) {
        this.accessType = accessType;
    }

    public LastAccessedArray putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LastAccessedArray lastAccessedArray = (LastAccessedArray)o;
        return Objects.equals(this.arrayId, lastAccessedArray.arrayId) && Objects.equals(this.arrayName, lastAccessedArray.arrayName) && Objects.equals(this.namespace, lastAccessedArray.namespace) && Objects.equals(this.accessedTime, lastAccessedArray.accessedTime) && Objects.equals((Object)this.accessType, (Object)lastAccessedArray.accessType) && Objects.equals(this.additionalProperties, lastAccessedArray.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.arrayId, this.arrayName, this.namespace, this.accessedTime, this.accessType, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LastAccessedArray {\n");
        sb.append("    arrayId: ").append(this.toIndentedString(this.arrayId)).append("\n");
        sb.append("    arrayName: ").append(this.toIndentedString(this.arrayName)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    accessedTime: ").append(this.toIndentedString(this.accessedTime)).append("\n");
        sb.append("    accessType: ").append(this.toIndentedString((Object)this.accessType)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in LastAccessedArray is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARRAY_ID) != null && !jsonObj.get(SERIALIZED_NAME_ARRAY_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARRAY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `array_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARRAY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARRAY_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ARRAY_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARRAY_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `array_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARRAY_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
    }

    public static LastAccessedArray fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, LastAccessedArray.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ARRAY_ID);
        openapiFields.add(SERIALIZED_NAME_ARRAY_NAME);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_ACCESSED_TIME);
        openapiFields.add(SERIALIZED_NAME_ACCESS_TYPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!LastAccessedArray.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<LastAccessedArray> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(LastAccessedArray.class));
            return new TypeAdapter<LastAccessedArray>(){

                @Override
                public void write(JsonWriter out, LastAccessedArray value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public LastAccessedArray read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    LastAccessedArray.validateJsonObject(jsonObj);
                    LastAccessedArray instance = (LastAccessedArray)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

