/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.DomainArray;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="object representing a non-empty domain")
public class NonEmptyDomain {
    public static final String SERIALIZED_NAME_NON_EMPTY_DOMAIN = "nonEmptyDomain";
    @SerializedName(value="nonEmptyDomain")
    private DomainArray nonEmptyDomain;
    public static final String SERIALIZED_NAME_IS_EMPTY = "isEmpty";
    @SerializedName(value="isEmpty")
    private Boolean isEmpty;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public NonEmptyDomain nonEmptyDomain(DomainArray nonEmptyDomain) {
        this.nonEmptyDomain = nonEmptyDomain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public DomainArray getNonEmptyDomain() {
        return this.nonEmptyDomain;
    }

    public void setNonEmptyDomain(DomainArray nonEmptyDomain) {
        this.nonEmptyDomain = nonEmptyDomain;
    }

    public NonEmptyDomain isEmpty(Boolean isEmpty) {
        this.isEmpty = isEmpty;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="false", required=true, value="Is non-empty domain really empty?")
    public Boolean getIsEmpty() {
        return this.isEmpty;
    }

    public void setIsEmpty(Boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    public NonEmptyDomain putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NonEmptyDomain nonEmptyDomain = (NonEmptyDomain)o;
        return Objects.equals(this.nonEmptyDomain, nonEmptyDomain.nonEmptyDomain) && Objects.equals(this.isEmpty, nonEmptyDomain.isEmpty) && Objects.equals(this.additionalProperties, nonEmptyDomain.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.nonEmptyDomain, this.isEmpty, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NonEmptyDomain {\n");
        sb.append("    nonEmptyDomain: ").append(this.toIndentedString(this.nonEmptyDomain)).append("\n");
        sb.append("    isEmpty: ").append(this.toIndentedString(this.isEmpty)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in NonEmptyDomain is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NON_EMPTY_DOMAIN) != null && !jsonObj.get(SERIALIZED_NAME_NON_EMPTY_DOMAIN).isJsonNull()) {
            DomainArray.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NON_EMPTY_DOMAIN));
        }
    }

    public static NonEmptyDomain fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, NonEmptyDomain.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NON_EMPTY_DOMAIN);
        openapiFields.add(SERIALIZED_NAME_IS_EMPTY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NON_EMPTY_DOMAIN);
        openapiRequiredFields.add(SERIALIZED_NAME_IS_EMPTY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!NonEmptyDomain.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<NonEmptyDomain> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(NonEmptyDomain.class));
            return new TypeAdapter<NonEmptyDomain>(){

                @Override
                public void write(JsonWriter out, NonEmptyDomain value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public NonEmptyDomain read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    NonEmptyDomain.validateJsonObject(jsonObj);
                    NonEmptyDomain instance = (NonEmptyDomain)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

