/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.ArrayInfo;
import io.tiledb.cloud.rest_api.model.PaginationMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object including notebook favorites and pagination metadata")
public class NotebookFavoritesData {
    public static final String SERIALIZED_NAME_NOTEBOOKS = "notebooks";
    @SerializedName(value="notebooks")
    private List<ArrayInfo> notebooks = null;
    public static final String SERIALIZED_NAME_PAGINATION_METADATA = "pagination_metadata";
    @SerializedName(value="pagination_metadata")
    private PaginationMetadata paginationMetadata;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public NotebookFavoritesData notebooks(List<ArrayInfo> notebooks) {
        this.notebooks = notebooks;
        return this;
    }

    public NotebookFavoritesData addNotebooksItem(ArrayInfo notebooksItem) {
        if (this.notebooks == null) {
            this.notebooks = new ArrayList<ArrayInfo>();
        }
        this.notebooks.add(notebooksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of notebook infos")
    public List<ArrayInfo> getNotebooks() {
        return this.notebooks;
    }

    public void setNotebooks(List<ArrayInfo> notebooks) {
        this.notebooks = notebooks;
    }

    public NotebookFavoritesData paginationMetadata(PaginationMetadata paginationMetadata) {
        this.paginationMetadata = paginationMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaginationMetadata getPaginationMetadata() {
        return this.paginationMetadata;
    }

    public void setPaginationMetadata(PaginationMetadata paginationMetadata) {
        this.paginationMetadata = paginationMetadata;
    }

    public NotebookFavoritesData putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotebookFavoritesData notebookFavoritesData = (NotebookFavoritesData)o;
        return Objects.equals(this.notebooks, notebookFavoritesData.notebooks) && Objects.equals(this.paginationMetadata, notebookFavoritesData.paginationMetadata) && Objects.equals(this.additionalProperties, notebookFavoritesData.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.notebooks, this.paginationMetadata, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotebookFavoritesData {\n");
        sb.append("    notebooks: ").append(this.toIndentedString(this.notebooks)).append("\n");
        sb.append("    paginationMetadata: ").append(this.toIndentedString(this.paginationMetadata)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in NotebookFavoritesData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonArray jsonArraynotebooks = jsonObj.getAsJsonArray(SERIALIZED_NAME_NOTEBOOKS);
        if (jsonArraynotebooks != null) {
            if (!jsonObj.get(SERIALIZED_NAME_NOTEBOOKS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `notebooks` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTEBOOKS).toString()));
            }
            for (int i = 0; i < jsonArraynotebooks.size(); ++i) {
                ArrayInfo.validateJsonObject(jsonArraynotebooks.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PAGINATION_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_PAGINATION_METADATA).isJsonNull()) {
            PaginationMetadata.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PAGINATION_METADATA));
        }
    }

    public static NotebookFavoritesData fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, NotebookFavoritesData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NOTEBOOKS);
        openapiFields.add(SERIALIZED_NAME_PAGINATION_METADATA);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!NotebookFavoritesData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<NotebookFavoritesData> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(NotebookFavoritesData.class));
            return new TypeAdapter<NotebookFavoritesData>(){

                @Override
                public void write(JsonWriter out, NotebookFavoritesData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public NotebookFavoritesData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    NotebookFavoritesData.validateJsonObject(jsonObj);
                    NotebookFavoritesData instance = (NotebookFavoritesData)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

