/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Status details of a notebook server")
public class NotebookStatus {
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    private String namespace;
    public static final String SERIALIZED_NAME_UPTIME = "uptime";
    @SerializedName(value="uptime")
    private Integer uptime;
    public static final String SERIALIZED_NAME_CPU_USAGE = "cpu_usage";
    @SerializedName(value="cpu_usage")
    private Integer cpuUsage;
    public static final String SERIALIZED_NAME_GPU_USAGE = "gpu_usage";
    @SerializedName(value="gpu_usage")
    private Integer gpuUsage;
    public static final String SERIALIZED_NAME_MEMORY_USAGE = "memory_usage";
    @SerializedName(value="memory_usage")
    private Integer memoryUsage;
    public static final String SERIALIZED_NAME_GPU_LIMIT = "gpu_limit";
    @SerializedName(value="gpu_limit")
    private Integer gpuLimit;
    public static final String SERIALIZED_NAME_MEMORY_LIMIT = "memory_limit";
    @SerializedName(value="memory_limit")
    private Integer memoryLimit;
    public static final String SERIALIZED_NAME_STORAGE_USAGE = "storage_usage";
    @SerializedName(value="storage_usage")
    private Integer storageUsage;
    public static final String SERIALIZED_NAME_STORAGE_LIMIT = "storage_limit";
    @SerializedName(value="storage_limit")
    private Integer storageLimit;
    public static final String SERIALIZED_NAME_CPU_COUNT = "cpu_count";
    @SerializedName(value="cpu_count")
    private Integer cpuCount;
    public static final String SERIALIZED_NAME_COST = "cost";
    @SerializedName(value="cost")
    private Double cost;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public NotebookStatus namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="namespace of notebook")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public NotebookStatus uptime(Integer uptime) {
        this.uptime = uptime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="120", value="duration notebook has been running in seconds")
    public Integer getUptime() {
        return this.uptime;
    }

    public void setUptime(Integer uptime) {
        this.uptime = uptime;
    }

    public NotebookStatus cpuUsage(Integer cpuUsage) {
        this.cpuUsage = cpuUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4000", value="current cpu usage in millicpu")
    public Integer getCpuUsage() {
        return this.cpuUsage;
    }

    public void setCpuUsage(Integer cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    public NotebookStatus gpuUsage(Integer gpuUsage) {
        this.gpuUsage = gpuUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4000", value="gpu usage in milligpu")
    public Integer getGpuUsage() {
        return this.gpuUsage;
    }

    public void setGpuUsage(Integer gpuUsage) {
        this.gpuUsage = gpuUsage;
    }

    public NotebookStatus memoryUsage(Integer memoryUsage) {
        this.memoryUsage = memoryUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1073741824", value="memory usage in bytes")
    public Integer getMemoryUsage() {
        return this.memoryUsage;
    }

    public void setMemoryUsage(Integer memoryUsage) {
        this.memoryUsage = memoryUsage;
    }

    public NotebookStatus gpuLimit(Integer gpuLimit) {
        this.gpuLimit = gpuLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1073741824", value="gpu limit in milligpu")
    public Integer getGpuLimit() {
        return this.gpuLimit;
    }

    public void setGpuLimit(Integer gpuLimit) {
        this.gpuLimit = gpuLimit;
    }

    public NotebookStatus memoryLimit(Integer memoryLimit) {
        this.memoryLimit = memoryLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1073741824", value="memory allocated to notebook server in bytes")
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    public void setMemoryLimit(Integer memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    public NotebookStatus storageUsage(Integer storageUsage) {
        this.storageUsage = storageUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1073741824", value="storage usage in bytes")
    public Integer getStorageUsage() {
        return this.storageUsage;
    }

    public void setStorageUsage(Integer storageUsage) {
        this.storageUsage = storageUsage;
    }

    public NotebookStatus storageLimit(Integer storageLimit) {
        this.storageLimit = storageLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1073741824", value="storage allocated to notebook server in bytes")
    public Integer getStorageLimit() {
        return this.storageLimit;
    }

    public void setStorageLimit(Integer storageLimit) {
        this.storageLimit = storageLimit;
    }

    public NotebookStatus cpuCount(Integer cpuCount) {
        this.cpuCount = cpuCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4000", value="millicpu allocated to notebook server")
    public Integer getCpuCount() {
        return this.cpuCount;
    }

    public void setCpuCount(Integer cpuCount) {
        this.cpuCount = cpuCount;
    }

    public NotebookStatus cost(Double cost) {
        this.cost = cost;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.27", value="cost in USD for the current notebook session")
    public Double getCost() {
        return this.cost;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }

    public NotebookStatus putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotebookStatus notebookStatus = (NotebookStatus)o;
        return Objects.equals(this.namespace, notebookStatus.namespace) && Objects.equals(this.uptime, notebookStatus.uptime) && Objects.equals(this.cpuUsage, notebookStatus.cpuUsage) && Objects.equals(this.gpuUsage, notebookStatus.gpuUsage) && Objects.equals(this.memoryUsage, notebookStatus.memoryUsage) && Objects.equals(this.gpuLimit, notebookStatus.gpuLimit) && Objects.equals(this.memoryLimit, notebookStatus.memoryLimit) && Objects.equals(this.storageUsage, notebookStatus.storageUsage) && Objects.equals(this.storageLimit, notebookStatus.storageLimit) && Objects.equals(this.cpuCount, notebookStatus.cpuCount) && Objects.equals(this.cost, notebookStatus.cost) && Objects.equals(this.additionalProperties, notebookStatus.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.uptime, this.cpuUsage, this.gpuUsage, this.memoryUsage, this.gpuLimit, this.memoryLimit, this.storageUsage, this.storageLimit, this.cpuCount, this.cost, this.additionalProperties);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotebookStatus {\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    uptime: ").append(this.toIndentedString(this.uptime)).append("\n");
        sb.append("    cpuUsage: ").append(this.toIndentedString(this.cpuUsage)).append("\n");
        sb.append("    gpuUsage: ").append(this.toIndentedString(this.gpuUsage)).append("\n");
        sb.append("    memoryUsage: ").append(this.toIndentedString(this.memoryUsage)).append("\n");
        sb.append("    gpuLimit: ").append(this.toIndentedString(this.gpuLimit)).append("\n");
        sb.append("    memoryLimit: ").append(this.toIndentedString(this.memoryLimit)).append("\n");
        sb.append("    storageUsage: ").append(this.toIndentedString(this.storageUsage)).append("\n");
        sb.append("    storageLimit: ").append(this.toIndentedString(this.storageLimit)).append("\n");
        sb.append("    cpuCount: ").append(this.toIndentedString(this.cpuCount)).append("\n");
        sb.append("    cost: ").append(this.toIndentedString(this.cost)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in NotebookStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
    }

    public static NotebookStatus fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, NotebookStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_UPTIME);
        openapiFields.add(SERIALIZED_NAME_CPU_USAGE);
        openapiFields.add(SERIALIZED_NAME_GPU_USAGE);
        openapiFields.add(SERIALIZED_NAME_MEMORY_USAGE);
        openapiFields.add(SERIALIZED_NAME_GPU_LIMIT);
        openapiFields.add(SERIALIZED_NAME_MEMORY_LIMIT);
        openapiFields.add(SERIALIZED_NAME_STORAGE_USAGE);
        openapiFields.add(SERIALIZED_NAME_STORAGE_LIMIT);
        openapiFields.add(SERIALIZED_NAME_CPU_COUNT);
        openapiFields.add(SERIALIZED_NAME_COST);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!NotebookStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<NotebookStatus> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(NotebookStatus.class));
            return new TypeAdapter<NotebookStatus>(){

                @Override
                public void write(JsonWriter out, NotebookStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public NotebookStatus read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    NotebookStatus.validateJsonObject(jsonObj);
                    NotebookStatus instance = (NotebookStatus)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

