/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.AssetLocations;
import io.tiledb.cloud.rest_api.model.NamespaceActions;
import io.tiledb.cloud.rest_api.model.OrganizationRoles;
import io.tiledb.cloud.rest_api.model.OrganizationUser;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Organization")
public class Organization {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    private OrganizationRoles role;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_LOGO = "logo";
    @SerializedName(value="logo")
    private String logo;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_USERS = "users";
    @SerializedName(value="users")
    private List<OrganizationUser> users = null;
    public static final String SERIALIZED_NAME_ALLOWED_ACTIONS = "allowed_actions";
    @SerializedName(value="allowed_actions")
    private List<NamespaceActions> allowedActions = null;
    public static final String SERIALIZED_NAME_NUM_OF_ARRAYS = "num_of_arrays";
    @SerializedName(value="num_of_arrays")
    private BigDecimal numOfArrays;
    public static final String SERIALIZED_NAME_ENABLED_FEATURES = "enabled_features";
    @SerializedName(value="enabled_features")
    private List<String> enabledFeatures = null;
    public static final String SERIALIZED_NAME_UNPAID_SUBSCRIPTION = "unpaid_subscription";
    @SerializedName(value="unpaid_subscription")
    private Boolean unpaidSubscription;
    public static final String SERIALIZED_NAME_DEFAULT_S3_PATH = "default_s3_path";
    @SerializedName(value="default_s3_path")
    private String defaultS3Path;
    public static final String SERIALIZED_NAME_DEFAULT_S3_PATH_CREDENTIALS_NAME = "default_s3_path_credentials_name";
    @SerializedName(value="default_s3_path_credentials_name")
    private String defaultS3PathCredentialsName;
    public static final String SERIALIZED_NAME_ASSET_LOCATIONS = "asset_locations";
    @SerializedName(value="asset_locations")
    private AssetLocations assetLocations;
    public static final String SERIALIZED_NAME_STRIPE_CONNECT = "stripe_connect";
    @SerializedName(value="stripe_connect")
    private Boolean stripeConnect;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Organization() {
    }

    public Organization(List<String> enabledFeatures, Boolean unpaidSubscription, Boolean stripeConnect) {
        this();
        this.enabledFeatures = enabledFeatures;
        this.unpaidSubscription = unpaidSubscription;
        this.stripeConnect = stripeConnect;
    }

    public Organization id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="unique ID of organization")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Organization role(OrganizationRoles role) {
        this.role = role;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OrganizationRoles getRole() {
        return this.role;
    }

    public void setRole(OrganizationRoles role) {
        this.role = role;
    }

    public Organization name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="organization name must be unique")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Organization createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Datetime organization was created in UTC")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Organization updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Datetime organization was updated in UTC")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Organization logo(String logo) {
        this.logo = logo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Organization logo")
    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public Organization description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Organization description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Organization users(List<OrganizationUser> users) {
        this.users = users;
        return this;
    }

    public Organization addUsersItem(OrganizationUser usersItem) {
        if (this.users == null) {
            this.users = new ArrayList<OrganizationUser>();
        }
        this.users.add(usersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<OrganizationUser> getUsers() {
        return this.users;
    }

    public void setUsers(List<OrganizationUser> users) {
        this.users = users;
    }

    public Organization allowedActions(List<NamespaceActions> allowedActions) {
        this.allowedActions = allowedActions;
        return this;
    }

    public Organization addAllowedActionsItem(NamespaceActions allowedActionsItem) {
        if (this.allowedActions == null) {
            this.allowedActions = new ArrayList<NamespaceActions>();
        }
        this.allowedActions.add(allowedActionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="list of actions user is allowed to do on this organization")
    public List<NamespaceActions> getAllowedActions() {
        return this.allowedActions;
    }

    public void setAllowedActions(List<NamespaceActions> allowedActions) {
        this.allowedActions = allowedActions;
    }

    public Organization numOfArrays(BigDecimal numOfArrays) {
        this.numOfArrays = numOfArrays;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="number of registered arrays for this organization")
    public BigDecimal getNumOfArrays() {
        return this.numOfArrays;
    }

    public void setNumOfArrays(BigDecimal numOfArrays) {
        this.numOfArrays = numOfArrays;
    }

    @Nullable
    @ApiModelProperty(value="List of extra/optional/beta features to enable for namespace")
    public List<String> getEnabledFeatures() {
        return this.enabledFeatures;
    }

    @Nullable
    @ApiModelProperty(value="A notice that the user has an unpaid subscription")
    public Boolean getUnpaidSubscription() {
        return this.unpaidSubscription;
    }

    public Organization defaultS3Path(String defaultS3Path) {
        this.defaultS3Path = defaultS3Path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default location to store newly-created notebooks and other assets like UDFs. The name `default_s3_path` is a legacy holdover; it may refer to any supported storage location. ")
    public String getDefaultS3Path() {
        return this.defaultS3Path;
    }

    public void setDefaultS3Path(String defaultS3Path) {
        this.defaultS3Path = defaultS3Path;
    }

    public Organization defaultS3PathCredentialsName(String defaultS3PathCredentialsName) {
        this.defaultS3PathCredentialsName = defaultS3PathCredentialsName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the credentials used to create and access files in the `default_s3_path`, if needed. ")
    public String getDefaultS3PathCredentialsName() {
        return this.defaultS3PathCredentialsName;
    }

    public void setDefaultS3PathCredentialsName(String defaultS3PathCredentialsName) {
        this.defaultS3PathCredentialsName = defaultS3PathCredentialsName;
    }

    public Organization assetLocations(AssetLocations assetLocations) {
        this.assetLocations = assetLocations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AssetLocations getAssetLocations() {
        return this.assetLocations;
    }

    public void setAssetLocations(AssetLocations assetLocations) {
        this.assetLocations = assetLocations;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Denotes that the organization is able to apply pricing to arrays by means of Stripe Connect")
    public Boolean getStripeConnect() {
        return this.stripeConnect;
    }

    public Organization putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization organization = (Organization)o;
        return Objects.equals(this.id, organization.id) && Objects.equals((Object)this.role, (Object)organization.role) && Objects.equals(this.name, organization.name) && Objects.equals(this.createdAt, organization.createdAt) && Objects.equals(this.updatedAt, organization.updatedAt) && Objects.equals(this.logo, organization.logo) && Objects.equals(this.description, organization.description) && Objects.equals(this.users, organization.users) && Objects.equals(this.allowedActions, organization.allowedActions) && Objects.equals(this.numOfArrays, organization.numOfArrays) && Objects.equals(this.enabledFeatures, organization.enabledFeatures) && Objects.equals(this.unpaidSubscription, organization.unpaidSubscription) && Objects.equals(this.defaultS3Path, organization.defaultS3Path) && Objects.equals(this.defaultS3PathCredentialsName, organization.defaultS3PathCredentialsName) && Objects.equals(this.assetLocations, organization.assetLocations) && Objects.equals(this.stripeConnect, organization.stripeConnect) && Objects.equals(this.additionalProperties, organization.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.role, this.name, this.createdAt, this.updatedAt, this.logo, this.description, this.users, this.allowedActions, this.numOfArrays, this.enabledFeatures, this.unpaidSubscription, this.defaultS3Path, this.defaultS3PathCredentialsName, this.assetLocations, this.stripeConnect, this.additionalProperties});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Organization {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    allowedActions: ").append(this.toIndentedString(this.allowedActions)).append("\n");
        sb.append("    numOfArrays: ").append(this.toIndentedString(this.numOfArrays)).append("\n");
        sb.append("    enabledFeatures: ").append(this.toIndentedString(this.enabledFeatures)).append("\n");
        sb.append("    unpaidSubscription: ").append(this.toIndentedString(this.unpaidSubscription)).append("\n");
        sb.append("    defaultS3Path: ").append(this.toIndentedString(this.defaultS3Path)).append("\n");
        sb.append("    defaultS3PathCredentialsName: ").append(this.toIndentedString(this.defaultS3PathCredentialsName)).append("\n");
        sb.append("    assetLocations: ").append(this.toIndentedString(this.assetLocations)).append("\n");
        sb.append("    stripeConnect: ").append(this.toIndentedString(this.stripeConnect)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Organization is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LOGO) != null && !jsonObj.get(SERIALIZED_NAME_LOGO).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LOGO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `logo` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LOGO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        JsonArray jsonArrayusers = jsonObj.getAsJsonArray(SERIALIZED_NAME_USERS);
        if (jsonArrayusers != null) {
            if (!jsonObj.get(SERIALIZED_NAME_USERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `users` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERS).toString()));
            }
            for (int i = 0; i < jsonArrayusers.size(); ++i) {
                OrganizationUser.validateJsonObject(jsonArrayusers.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `allowed_actions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENABLED_FEATURES) != null && !jsonObj.get(SERIALIZED_NAME_ENABLED_FEATURES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENABLED_FEATURES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `enabled_features` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENABLED_FEATURES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFAULT_S3_PATH) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULT_S3_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEFAULT_S3_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `default_s3_path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFAULT_S3_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFAULT_S3_PATH_CREDENTIALS_NAME) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULT_S3_PATH_CREDENTIALS_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEFAULT_S3_PATH_CREDENTIALS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `default_s3_path_credentials_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFAULT_S3_PATH_CREDENTIALS_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSET_LOCATIONS) != null && !jsonObj.get(SERIALIZED_NAME_ASSET_LOCATIONS).isJsonNull()) {
            AssetLocations.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ASSET_LOCATIONS));
        }
    }

    public static Organization fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, Organization.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ROLE);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiFields.add(SERIALIZED_NAME_LOGO);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_USERS);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_ACTIONS);
        openapiFields.add(SERIALIZED_NAME_NUM_OF_ARRAYS);
        openapiFields.add(SERIALIZED_NAME_ENABLED_FEATURES);
        openapiFields.add(SERIALIZED_NAME_UNPAID_SUBSCRIPTION);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_S3_PATH);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_S3_PATH_CREDENTIALS_NAME);
        openapiFields.add(SERIALIZED_NAME_ASSET_LOCATIONS);
        openapiFields.add(SERIALIZED_NAME_STRIPE_CONNECT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Organization.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<Organization> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(Organization.class));
            return new TypeAdapter<Organization>(){

                @Override
                public void write(JsonWriter out, Organization value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public Organization read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Organization.validateJsonObject(jsonObj);
                    Organization instance = (Organization)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

