/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.NamespaceActions;
import io.tiledb.cloud.rest_api.model.OrganizationRoles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="user in an organization")
public class OrganizationUser {
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(value="user_id")
    private String userId;
    public static final String SERIALIZED_NAME_ORGANIZATION_ID = "organization_id";
    @SerializedName(value="organization_id")
    private String organizationId;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static final String SERIALIZED_NAME_ORGANIZATION_NAME = "organization_name";
    @SerializedName(value="organization_name")
    private String organizationName;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    private OrganizationRoles role;
    public static final String SERIALIZED_NAME_ALLOWED_ACTIONS = "allowed_actions";
    @SerializedName(value="allowed_actions")
    private List<NamespaceActions> allowedActions = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public OrganizationUser userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="unique ID of user")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public OrganizationUser organizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="unique ID of organization")
    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public OrganizationUser username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="username", value="username for user")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public OrganizationUser organizationName(String organizationName) {
        this.organizationName = organizationName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="MyOrganization", value="name of organization")
    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public OrganizationUser role(OrganizationRoles role) {
        this.role = role;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OrganizationRoles getRole() {
        return this.role;
    }

    public void setRole(OrganizationRoles role) {
        this.role = role;
    }

    public OrganizationUser allowedActions(List<NamespaceActions> allowedActions) {
        this.allowedActions = allowedActions;
        return this;
    }

    public OrganizationUser addAllowedActionsItem(NamespaceActions allowedActionsItem) {
        if (this.allowedActions == null) {
            this.allowedActions = new ArrayList<NamespaceActions>();
        }
        this.allowedActions.add(allowedActionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="list of actions user is allowed to do on this organization")
    public List<NamespaceActions> getAllowedActions() {
        return this.allowedActions;
    }

    public void setAllowedActions(List<NamespaceActions> allowedActions) {
        this.allowedActions = allowedActions;
    }

    public OrganizationUser putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationUser organizationUser = (OrganizationUser)o;
        return Objects.equals(this.userId, organizationUser.userId) && Objects.equals(this.organizationId, organizationUser.organizationId) && Objects.equals(this.username, organizationUser.username) && Objects.equals(this.organizationName, organizationUser.organizationName) && Objects.equals((Object)this.role, (Object)organizationUser.role) && Objects.equals(this.allowedActions, organizationUser.allowedActions) && Objects.equals(this.additionalProperties, organizationUser.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userId, this.organizationId, this.username, this.organizationName, this.role, this.allowedActions, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrganizationUser {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    organizationId: ").append(this.toIndentedString(this.organizationId)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    organizationName: ").append(this.toIndentedString(this.organizationName)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    allowedActions: ").append(this.toIndentedString(this.allowedActions)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in OrganizationUser is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER_ID) != null && !jsonObj.get(SERIALIZED_NAME_USER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `user_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORGANIZATION_ID) != null && !jsonObj.get(SERIALIZED_NAME_ORGANIZATION_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORGANIZATION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `organization_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORGANIZATION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORGANIZATION_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ORGANIZATION_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORGANIZATION_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `organization_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORGANIZATION_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `allowed_actions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).toString()));
        }
    }

    public static OrganizationUser fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, OrganizationUser.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_USER_ID);
        openapiFields.add(SERIALIZED_NAME_ORGANIZATION_ID);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiFields.add(SERIALIZED_NAME_ORGANIZATION_NAME);
        openapiFields.add(SERIALIZED_NAME_ROLE);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_ACTIONS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!OrganizationUser.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<OrganizationUser> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(OrganizationUser.class));
            return new TypeAdapter<OrganizationUser>(){

                @Override
                public void write(JsonWriter out, OrganizationUser value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public OrganizationUser read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    OrganizationUser.validateJsonObject(jsonObj);
                    OrganizationUser instance = (OrganizationUser)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

