/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class PaginationMetadata {
    public static final String SERIALIZED_NAME_PAGE = "page";
    @SerializedName(value="page")
    private BigDecimal page;
    public static final String SERIALIZED_NAME_PER_PAGE = "per_page";
    @SerializedName(value="per_page")
    private BigDecimal perPage;
    public static final String SERIALIZED_NAME_TOTAL_PAGES = "total_pages";
    @SerializedName(value="total_pages")
    private BigDecimal totalPages;
    public static final String SERIALIZED_NAME_TOTAL_ITEMS = "total_items";
    @SerializedName(value="total_items")
    private BigDecimal totalItems;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PaginationMetadata page(BigDecimal page) {
        this.page = page;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1.0", value="pagination offset. Use it to skip the first ((page - 1) * per_page) items")
    public BigDecimal getPage() {
        return this.page;
    }

    public void setPage(BigDecimal page) {
        this.page = page;
    }

    public PaginationMetadata perPage(BigDecimal perPage) {
        this.perPage = perPage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10.0", value="pagination limit (page size)")
    public BigDecimal getPerPage() {
        return this.perPage;
    }

    public void setPerPage(BigDecimal perPage) {
        this.perPage = perPage;
    }

    public PaginationMetadata totalPages(BigDecimal totalPages) {
        this.totalPages = totalPages;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="14.0", value="number of total pages with current limit")
    public BigDecimal getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(BigDecimal totalPages) {
        this.totalPages = totalPages;
    }

    public PaginationMetadata totalItems(BigDecimal totalItems) {
        this.totalItems = totalItems;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="138.0", value="number of total available items")
    public BigDecimal getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(BigDecimal totalItems) {
        this.totalItems = totalItems;
    }

    public PaginationMetadata putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaginationMetadata paginationMetadata = (PaginationMetadata)o;
        return Objects.equals(this.page, paginationMetadata.page) && Objects.equals(this.perPage, paginationMetadata.perPage) && Objects.equals(this.totalPages, paginationMetadata.totalPages) && Objects.equals(this.totalItems, paginationMetadata.totalItems) && Objects.equals(this.additionalProperties, paginationMetadata.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.perPage, this.totalPages, this.totalItems, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaginationMetadata {\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    perPage: ").append(this.toIndentedString(this.perPage)).append("\n");
        sb.append("    totalPages: ").append(this.toIndentedString(this.totalPages)).append("\n");
        sb.append("    totalItems: ").append(this.toIndentedString(this.totalItems)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PaginationMetadata is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
    }

    public static PaginationMetadata fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, PaginationMetadata.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PAGE);
        openapiFields.add(SERIALIZED_NAME_PER_PAGE);
        openapiFields.add(SERIALIZED_NAME_TOTAL_PAGES);
        openapiFields.add(SERIALIZED_NAME_TOTAL_ITEMS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!PaginationMetadata.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<PaginationMetadata> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(PaginationMetadata.class));
            return new TypeAdapter<PaginationMetadata>(){

                @Override
                public void write(JsonWriter out, PaginationMetadata value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public PaginationMetadata read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PaginationMetadata.validateJsonObject(jsonObj);
                    PaginationMetadata instance = (PaginationMetadata)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

