/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.PricingAggregateUsage;
import io.tiledb.cloud.rest_api.model.PricingCurrency;
import io.tiledb.cloud.rest_api.model.PricingInterval;
import io.tiledb.cloud.rest_api.model.PricingType;
import io.tiledb.cloud.rest_api.model.PricingUnitLabel;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Pricing created by converting an array to product")
public class Pricing {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ARRAY_UUID = "array_uuid";
    @SerializedName(value="array_uuid")
    private String arrayUuid;
    public static final String SERIALIZED_NAME_PRICING_NAME = "pricing_name";
    @SerializedName(value="pricing_name")
    private String pricingName;
    public static final String SERIALIZED_NAME_PRICING_TYPE = "pricing_type";
    @SerializedName(value="pricing_type")
    private PricingType pricingType;
    public static final String SERIALIZED_NAME_PRODUCT_NAME = "product_name";
    @SerializedName(value="product_name")
    private String productName;
    public static final String SERIALIZED_NAME_PRODUCT_STATEMENT_DESCRIPTOR = "product_statement_descriptor";
    @SerializedName(value="product_statement_descriptor")
    private String productStatementDescriptor;
    public static final String SERIALIZED_NAME_PRODUCT_UNIT_LABEL = "product_unit_label";
    @SerializedName(value="product_unit_label")
    private PricingUnitLabel productUnitLabel;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private PricingCurrency currency;
    public static final String SERIALIZED_NAME_AGGREGATE_USAGE = "aggregate_usage";
    @SerializedName(value="aggregate_usage")
    private PricingAggregateUsage aggregateUsage;
    public static final String SERIALIZED_NAME_INTERVAL = "interval";
    @SerializedName(value="interval")
    private PricingInterval interval;
    public static final String SERIALIZED_NAME_DIVIDED_BY = "divided_by";
    @SerializedName(value="divided_by")
    private Long dividedBy;
    public static final String SERIALIZED_NAME_CHARGE = "charge";
    @SerializedName(value="charge")
    private Double charge;
    public static final String SERIALIZED_NAME_ACTIVATED = "activated";
    @SerializedName(value="activated")
    private Boolean activated;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Pricing id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="planID", value="Unique ID of plan as defined by Stripe")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Pricing arrayUuid(String arrayUuid) {
        this.arrayUuid = arrayUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Unique ID of registered array")
    public String getArrayUuid() {
        return this.arrayUuid;
    }

    public void setArrayUuid(String arrayUuid) {
        this.arrayUuid = arrayUuid;
    }

    public Pricing pricingName(String pricingName) {
        this.pricingName = pricingName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of pricing")
    public String getPricingName() {
        return this.pricingName;
    }

    public void setPricingName(String pricingName) {
        this.pricingName = pricingName;
    }

    public Pricing pricingType(PricingType pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PricingType getPricingType() {
        return this.pricingType;
    }

    public void setPricingType(PricingType pricingType) {
        this.pricingType = pricingType;
    }

    public Pricing productName(String productName) {
        this.productName = productName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of product")
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Pricing productStatementDescriptor(String productStatementDescriptor) {
        this.productStatementDescriptor = productStatementDescriptor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Extra information about a product which will appear on the credit card statement of the customer")
    public String getProductStatementDescriptor() {
        return this.productStatementDescriptor;
    }

    public void setProductStatementDescriptor(String productStatementDescriptor) {
        this.productStatementDescriptor = productStatementDescriptor;
    }

    public Pricing productUnitLabel(PricingUnitLabel productUnitLabel) {
        this.productUnitLabel = productUnitLabel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PricingUnitLabel getProductUnitLabel() {
        return this.productUnitLabel;
    }

    public void setProductUnitLabel(PricingUnitLabel productUnitLabel) {
        this.productUnitLabel = productUnitLabel;
    }

    public Pricing currency(PricingCurrency currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PricingCurrency getCurrency() {
        return this.currency;
    }

    public void setCurrency(PricingCurrency currency) {
        this.currency = currency;
    }

    public Pricing aggregateUsage(PricingAggregateUsage aggregateUsage) {
        this.aggregateUsage = aggregateUsage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PricingAggregateUsage getAggregateUsage() {
        return this.aggregateUsage;
    }

    public void setAggregateUsage(PricingAggregateUsage aggregateUsage) {
        this.aggregateUsage = aggregateUsage;
    }

    public Pricing interval(PricingInterval interval) {
        this.interval = interval;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PricingInterval getInterval() {
        return this.interval;
    }

    public void setInterval(PricingInterval interval) {
        this.interval = interval;
    }

    public Pricing dividedBy(Long dividedBy) {
        this.dividedBy = dividedBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1048576", value="Group of n product unit labels")
    public Long getDividedBy() {
        return this.dividedBy;
    }

    public void setDividedBy(Long dividedBy) {
        this.dividedBy = dividedBy;
    }

    public Pricing charge(Double charge) {
        this.charge = charge;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Price in cents (decimal) per unitlabel")
    public Double getCharge() {
        return this.charge;
    }

    public void setCharge(Double charge) {
        this.charge = charge;
    }

    public Pricing activated(Boolean activated) {
        this.activated = activated;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="If pricing is activated")
    public Boolean getActivated() {
        return this.activated;
    }

    public void setActivated(Boolean activated) {
        this.activated = activated;
    }

    public Pricing putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pricing pricing = (Pricing)o;
        return Objects.equals(this.id, pricing.id) && Objects.equals(this.arrayUuid, pricing.arrayUuid) && Objects.equals(this.pricingName, pricing.pricingName) && Objects.equals((Object)this.pricingType, (Object)pricing.pricingType) && Objects.equals(this.productName, pricing.productName) && Objects.equals(this.productStatementDescriptor, pricing.productStatementDescriptor) && Objects.equals((Object)this.productUnitLabel, (Object)pricing.productUnitLabel) && Objects.equals((Object)this.currency, (Object)pricing.currency) && Objects.equals((Object)this.aggregateUsage, (Object)pricing.aggregateUsage) && Objects.equals((Object)this.interval, (Object)pricing.interval) && Objects.equals(this.dividedBy, pricing.dividedBy) && Objects.equals(this.charge, pricing.charge) && Objects.equals(this.activated, pricing.activated) && Objects.equals(this.additionalProperties, pricing.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.arrayUuid, this.pricingName, this.pricingType, this.productName, this.productStatementDescriptor, this.productUnitLabel, this.currency, this.aggregateUsage, this.interval, this.dividedBy, this.charge, this.activated, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pricing {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    arrayUuid: ").append(this.toIndentedString(this.arrayUuid)).append("\n");
        sb.append("    pricingName: ").append(this.toIndentedString(this.pricingName)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    productName: ").append(this.toIndentedString(this.productName)).append("\n");
        sb.append("    productStatementDescriptor: ").append(this.toIndentedString(this.productStatementDescriptor)).append("\n");
        sb.append("    productUnitLabel: ").append(this.toIndentedString((Object)this.productUnitLabel)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString((Object)this.currency)).append("\n");
        sb.append("    aggregateUsage: ").append(this.toIndentedString((Object)this.aggregateUsage)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString((Object)this.interval)).append("\n");
        sb.append("    dividedBy: ").append(this.toIndentedString(this.dividedBy)).append("\n");
        sb.append("    charge: ").append(this.toIndentedString(this.charge)).append("\n");
        sb.append("    activated: ").append(this.toIndentedString(this.activated)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Pricing is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARRAY_UUID) != null && !jsonObj.get(SERIALIZED_NAME_ARRAY_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARRAY_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `array_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARRAY_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRICING_NAME) != null && !jsonObj.get(SERIALIZED_NAME_PRICING_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PRICING_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pricing_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRICING_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRODUCT_NAME) != null && !jsonObj.get(SERIALIZED_NAME_PRODUCT_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PRODUCT_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `product_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRODUCT_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRODUCT_STATEMENT_DESCRIPTOR) != null && !jsonObj.get(SERIALIZED_NAME_PRODUCT_STATEMENT_DESCRIPTOR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PRODUCT_STATEMENT_DESCRIPTOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `product_statement_descriptor` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRODUCT_STATEMENT_DESCRIPTOR).toString()));
        }
    }

    public static Pricing fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, Pricing.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ARRAY_UUID);
        openapiFields.add(SERIALIZED_NAME_PRICING_NAME);
        openapiFields.add(SERIALIZED_NAME_PRICING_TYPE);
        openapiFields.add(SERIALIZED_NAME_PRODUCT_NAME);
        openapiFields.add(SERIALIZED_NAME_PRODUCT_STATEMENT_DESCRIPTOR);
        openapiFields.add(SERIALIZED_NAME_PRODUCT_UNIT_LABEL);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_AGGREGATE_USAGE);
        openapiFields.add(SERIALIZED_NAME_INTERVAL);
        openapiFields.add(SERIALIZED_NAME_DIVIDED_BY);
        openapiFields.add(SERIALIZED_NAME_CHARGE);
        openapiFields.add(SERIALIZED_NAME_ACTIVATED);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Pricing.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<Pricing> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(Pricing.class));
            return new TypeAdapter<Pricing>(){

                @Override
                public void write(JsonWriter out, Pricing value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public Pricing read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Pricing.validateJsonObject(jsonObj);
                    Pricing instance = (Pricing)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

