/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.QueryRanges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Query returning results as JSON")
public class QueryJson {
    public static final String SERIALIZED_NAME_QUERY_RANGES = "query_ranges";
    @SerializedName(value="query_ranges")
    private QueryRanges queryRanges;
    public static final String SERIALIZED_NAME_FIELDS = "fields";
    @SerializedName(value="fields")
    private List<String> fields = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public QueryJson queryRanges(QueryRanges queryRanges) {
        this.queryRanges = queryRanges;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public QueryRanges getQueryRanges() {
        return this.queryRanges;
    }

    public void setQueryRanges(QueryRanges queryRanges) {
        this.queryRanges = queryRanges;
    }

    public QueryJson fields(List<String> fields) {
        this.fields = fields;
        return this;
    }

    public QueryJson addFieldsItem(String fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<String>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of fields to return data from, empty means return data for all fields")
    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public QueryJson putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryJson queryJson = (QueryJson)o;
        return Objects.equals(this.queryRanges, queryJson.queryRanges) && Objects.equals(this.fields, queryJson.fields) && Objects.equals(this.additionalProperties, queryJson.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.queryRanges, this.fields, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryJson {\n");
        sb.append("    queryRanges: ").append(this.toIndentedString(this.queryRanges)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in QueryJson is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_QUERY_RANGES) != null && !jsonObj.get(SERIALIZED_NAME_QUERY_RANGES).isJsonNull()) {
            QueryRanges.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_QUERY_RANGES));
        }
        if (jsonObj.get(SERIALIZED_NAME_FIELDS) != null && !jsonObj.get(SERIALIZED_NAME_FIELDS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FIELDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `fields` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FIELDS).toString()));
        }
    }

    public static QueryJson fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, QueryJson.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_QUERY_RANGES);
        openapiFields.add(SERIALIZED_NAME_FIELDS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!QueryJson.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<QueryJson> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(QueryJson.class));
            return new TypeAdapter<QueryJson>(){

                @Override
                public void write(JsonWriter out, QueryJson value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public QueryJson read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    QueryJson.validateJsonObject(jsonObj);
                    QueryJson instance = (QueryJson)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

