/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.Layout;
import io.tiledb.cloud.rest_api.model.ReadState;
import io.tiledb.cloud.rest_api.model.Subarray;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Read struct (can't be called reader due to class name conflict)")
public class QueryReader {
    public static final String SERIALIZED_NAME_LAYOUT = "layout";
    @SerializedName(value="layout")
    private Layout layout;
    public static final String SERIALIZED_NAME_SUBARRAY = "subarray";
    @SerializedName(value="subarray")
    private Subarray subarray;
    public static final String SERIALIZED_NAME_READ_STATE = "readState";
    @SerializedName(value="readState")
    private ReadState readState;
    public static final String SERIALIZED_NAME_VAR_OFFSETS_MODE = "varOffsetsMode";
    @SerializedName(value="varOffsetsMode")
    private String varOffsetsMode;
    public static final String SERIALIZED_NAME_VAR_OFFSETS_ADD_EXTRA_ELEMENT = "varOffsetsAddExtraElement";
    @SerializedName(value="varOffsetsAddExtraElement")
    private Boolean varOffsetsAddExtraElement;
    public static final String SERIALIZED_NAME_VAR_OFFSETS_BITSIZE = "varOffsetsBitsize";
    @SerializedName(value="varOffsetsBitsize")
    private Integer varOffsetsBitsize;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public QueryReader layout(Layout layout) {
        this.layout = layout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public QueryReader subarray(Subarray subarray) {
        this.subarray = subarray;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Subarray getSubarray() {
        return this.subarray;
    }

    public void setSubarray(Subarray subarray) {
        this.subarray = subarray;
    }

    public QueryReader readState(ReadState readState) {
        this.readState = readState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ReadState getReadState() {
        return this.readState;
    }

    public void setReadState(ReadState readState) {
        this.readState = readState;
    }

    public QueryReader varOffsetsMode(String varOffsetsMode) {
        this.varOffsetsMode = varOffsetsMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The offsets format (bytes or elements) to be used.")
    public String getVarOffsetsMode() {
        return this.varOffsetsMode;
    }

    public void setVarOffsetsMode(String varOffsetsMode) {
        this.varOffsetsMode = varOffsetsMode;
    }

    public QueryReader varOffsetsAddExtraElement(Boolean varOffsetsAddExtraElement) {
        this.varOffsetsAddExtraElement = varOffsetsAddExtraElement;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if an extra element will be added to the end of the offsets buffer.")
    public Boolean getVarOffsetsAddExtraElement() {
        return this.varOffsetsAddExtraElement;
    }

    public void setVarOffsetsAddExtraElement(Boolean varOffsetsAddExtraElement) {
        this.varOffsetsAddExtraElement = varOffsetsAddExtraElement;
    }

    public QueryReader varOffsetsBitsize(Integer varOffsetsBitsize) {
        this.varOffsetsBitsize = varOffsetsBitsize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The offsets bitsize (32 or 64) to be used.")
    public Integer getVarOffsetsBitsize() {
        return this.varOffsetsBitsize;
    }

    public void setVarOffsetsBitsize(Integer varOffsetsBitsize) {
        this.varOffsetsBitsize = varOffsetsBitsize;
    }

    public QueryReader putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryReader queryReader = (QueryReader)o;
        return Objects.equals((Object)this.layout, (Object)queryReader.layout) && Objects.equals(this.subarray, queryReader.subarray) && Objects.equals(this.readState, queryReader.readState) && Objects.equals(this.varOffsetsMode, queryReader.varOffsetsMode) && Objects.equals(this.varOffsetsAddExtraElement, queryReader.varOffsetsAddExtraElement) && Objects.equals(this.varOffsetsBitsize, queryReader.varOffsetsBitsize) && Objects.equals(this.additionalProperties, queryReader.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.layout, this.subarray, this.readState, this.varOffsetsMode, this.varOffsetsAddExtraElement, this.varOffsetsBitsize, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryReader {\n");
        sb.append("    layout: ").append(this.toIndentedString((Object)this.layout)).append("\n");
        sb.append("    subarray: ").append(this.toIndentedString(this.subarray)).append("\n");
        sb.append("    readState: ").append(this.toIndentedString(this.readState)).append("\n");
        sb.append("    varOffsetsMode: ").append(this.toIndentedString(this.varOffsetsMode)).append("\n");
        sb.append("    varOffsetsAddExtraElement: ").append(this.toIndentedString(this.varOffsetsAddExtraElement)).append("\n");
        sb.append("    varOffsetsBitsize: ").append(this.toIndentedString(this.varOffsetsBitsize)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in QueryReader is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBARRAY) != null && !jsonObj.get(SERIALIZED_NAME_SUBARRAY).isJsonNull()) {
            Subarray.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SUBARRAY));
        }
        if (jsonObj.get(SERIALIZED_NAME_READ_STATE) != null && !jsonObj.get(SERIALIZED_NAME_READ_STATE).isJsonNull()) {
            ReadState.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_READ_STATE));
        }
        if (jsonObj.get(SERIALIZED_NAME_VAR_OFFSETS_MODE) != null && !jsonObj.get(SERIALIZED_NAME_VAR_OFFSETS_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VAR_OFFSETS_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `varOffsetsMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VAR_OFFSETS_MODE).toString()));
        }
    }

    public static QueryReader fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, QueryReader.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LAYOUT);
        openapiFields.add(SERIALIZED_NAME_SUBARRAY);
        openapiFields.add(SERIALIZED_NAME_READ_STATE);
        openapiFields.add(SERIALIZED_NAME_VAR_OFFSETS_MODE);
        openapiFields.add(SERIALIZED_NAME_VAR_OFFSETS_ADD_EXTRA_ELEMENT);
        openapiFields.add(SERIALIZED_NAME_VAR_OFFSETS_BITSIZE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!QueryReader.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<QueryReader> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(QueryReader.class));
            return new TypeAdapter<QueryReader>(){

                @Override
                public void write(JsonWriter out, QueryReader value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public QueryReader read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    QueryReader.validateJsonObject(jsonObj);
                    QueryReader instance = (QueryReader)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

