/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.TaskGraphNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The structure and metadata of a task graph that can be stored on TileDB Cloud and executed by users who have access to it. ")
public class RegisteredTaskGraph {
    public static final String SERIALIZED_NAME_UUID = "uuid";
    @SerializedName(value="uuid")
    private String uuid;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    private String namespace;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_README = "readme";
    @SerializedName(value="readme")
    private String readme;
    public static final String SERIALIZED_NAME_LICENSE_ID = "license_id";
    @SerializedName(value="license_id")
    private String licenseId;
    public static final String SERIALIZED_NAME_LICENSE_TEXT = "license_text";
    @SerializedName(value="license_text")
    private String licenseText;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_NODES = "nodes";
    @SerializedName(value="nodes")
    private List<TaskGraphNode> nodes = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public RegisteredTaskGraph uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A server-assigned unique ID for the UDF, in UUID format.")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public RegisteredTaskGraph namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The namespace that owns this task graph log.")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public RegisteredTaskGraph name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of this graph, to appear in URLs. Must be unique per-namespace. ")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RegisteredTaskGraph readme(String readme) {
        this.readme = readme;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Documentation for the task graph, in Markdown format.")
    public String getReadme() {
        return this.readme;
    }

    public void setReadme(String readme) {
        this.readme = readme;
    }

    public RegisteredTaskGraph licenseId(String licenseId) {
        this.licenseId = licenseId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SPDX license identifier.")
    public String getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public RegisteredTaskGraph licenseText(String licenseText) {
        this.licenseText = licenseText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Full text of the license.")
    public String getLicenseText() {
        return this.licenseText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public RegisteredTaskGraph tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public RegisteredTaskGraph addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional tags to classify the graph.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public RegisteredTaskGraph nodes(List<TaskGraphNode> nodes) {
        this.nodes = nodes;
        return this;
    }

    public RegisteredTaskGraph addNodesItem(TaskGraphNode nodesItem) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<TaskGraphNode>();
        }
        this.nodes.add(nodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The structure of the graph, in the form of the nodes that make it up. As with `TaskGraphLog`, nodes must topologically sorted, so that any node appears after all the nodes it depends on. ")
    public List<TaskGraphNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<TaskGraphNode> nodes) {
        this.nodes = nodes;
    }

    public RegisteredTaskGraph putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisteredTaskGraph registeredTaskGraph = (RegisteredTaskGraph)o;
        return Objects.equals(this.uuid, registeredTaskGraph.uuid) && Objects.equals(this.namespace, registeredTaskGraph.namespace) && Objects.equals(this.name, registeredTaskGraph.name) && Objects.equals(this.readme, registeredTaskGraph.readme) && Objects.equals(this.licenseId, registeredTaskGraph.licenseId) && Objects.equals(this.licenseText, registeredTaskGraph.licenseText) && Objects.equals(this.tags, registeredTaskGraph.tags) && Objects.equals(this.nodes, registeredTaskGraph.nodes) && Objects.equals(this.additionalProperties, registeredTaskGraph.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.namespace, this.name, this.readme, this.licenseId, this.licenseText, this.tags, this.nodes, this.additionalProperties);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegisteredTaskGraph {\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    readme: ").append(this.toIndentedString(this.readme)).append("\n");
        sb.append("    licenseId: ").append(this.toIndentedString(this.licenseId)).append("\n");
        sb.append("    licenseText: ").append(this.toIndentedString(this.licenseText)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    nodes: ").append(this.toIndentedString(this.nodes)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in RegisteredTaskGraph is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UUID) != null && !jsonObj.get(SERIALIZED_NAME_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_README) != null && !jsonObj.get(SERIALIZED_NAME_README).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_README).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `readme` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_README).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LICENSE_ID) != null && !jsonObj.get(SERIALIZED_NAME_LICENSE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LICENSE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `license_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LICENSE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT) != null && !jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `license_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        JsonArray jsonArraynodes = jsonObj.getAsJsonArray(SERIALIZED_NAME_NODES);
        if (jsonArraynodes != null) {
            if (!jsonObj.get(SERIALIZED_NAME_NODES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `nodes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NODES).toString()));
            }
            for (int i = 0; i < jsonArraynodes.size(); ++i) {
                TaskGraphNode.validateJsonObject(jsonArraynodes.get(i).getAsJsonObject());
            }
        }
    }

    public static RegisteredTaskGraph fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, RegisteredTaskGraph.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_UUID);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_README);
        openapiFields.add(SERIALIZED_NAME_LICENSE_ID);
        openapiFields.add(SERIALIZED_NAME_LICENSE_TEXT);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_NODES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!RegisteredTaskGraph.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<RegisteredTaskGraph> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(RegisteredTaskGraph.class));
            return new TypeAdapter<RegisteredTaskGraph>(){

                @Override
                public void write(JsonWriter out, RegisteredTaskGraph value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public RegisteredTaskGraph read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    RegisteredTaskGraph.validateJsonObject(jsonObj);
                    RegisteredTaskGraph instance = (RegisteredTaskGraph)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

