/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum ResultFormat {
    PYTHON_PICKLE("python_pickle"),
    R_SERIALIZATION("r_serialization"),
    JSON("json"),
    ARROW("arrow"),
    BYTES("bytes"),
    TILEDB_JSON("tiledb_json"),
    NATIVE("native");

    private String value;

    private ResultFormat(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResultFormat fromValue(String value) {
        for (ResultFormat b : ResultFormat.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter
    extends TypeAdapter<ResultFormat> {
        @Override
        public void write(JsonWriter jsonWriter, ResultFormat enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        @Override
        public ResultFormat read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return ResultFormat.fromValue(value);
        }
    }
}

