/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.Backoff;
import io.tiledb.cloud.rest_api.model.RetryPolicy;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="RetryStrategy provides controls on how to retry a taskgraph node")
public class RetryStrategy {
    public static final String SERIALIZED_NAME_BACKOFF = "backoff";
    @SerializedName(value="backoff")
    private Backoff backoff;
    public static final String SERIALIZED_NAME_EXPRESSION = "expression";
    @SerializedName(value="expression")
    private String expression;
    public static final String SERIALIZED_NAME_LIMIT = "limit";
    @SerializedName(value="limit")
    private Integer limit;
    public static final String SERIALIZED_NAME_RETRY_POLICY = "retryPolicy";
    @SerializedName(value="retryPolicy")
    private RetryPolicy retryPolicy;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public RetryStrategy backoff(Backoff backoff) {
        this.backoff = backoff;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Backoff getBackoff() {
        return this.backoff;
    }

    public void setBackoff(Backoff backoff) {
        this.backoff = backoff;
    }

    public RetryStrategy expression(String expression) {
        this.expression = expression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Expression is a condition expression for when a node will be retried. If it evaluates to false, the node will not be retried and the retry strategy will be ignored")
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public RetryStrategy limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Limit is the maximum number of retry attempts when retrying a container. It does not include the original container; the maximum number of total attempts will be `limit + 1`.")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public RetryStrategy retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public RetryStrategy putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetryStrategy retryStrategy = (RetryStrategy)o;
        return Objects.equals(this.backoff, retryStrategy.backoff) && Objects.equals(this.expression, retryStrategy.expression) && Objects.equals(this.limit, retryStrategy.limit) && Objects.equals((Object)this.retryPolicy, (Object)retryStrategy.retryPolicy) && Objects.equals(this.additionalProperties, retryStrategy.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.backoff, this.expression, this.limit, this.retryPolicy, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RetryStrategy {\n");
        sb.append("    backoff: ").append(this.toIndentedString(this.backoff)).append("\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    retryPolicy: ").append(this.toIndentedString((Object)this.retryPolicy)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in RetryStrategy is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BACKOFF) != null && !jsonObj.get(SERIALIZED_NAME_BACKOFF).isJsonNull()) {
            Backoff.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BACKOFF));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPRESSION) != null && !jsonObj.get(SERIALIZED_NAME_EXPRESSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXPRESSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `expression` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPRESSION).toString()));
        }
    }

    public static RetryStrategy fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, RetryStrategy.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BACKOFF);
        openapiFields.add(SERIALIZED_NAME_EXPRESSION);
        openapiFields.add(SERIALIZED_NAME_LIMIT);
        openapiFields.add(SERIALIZED_NAME_RETRY_POLICY);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!RetryStrategy.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<RetryStrategy> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(RetryStrategy.class));
            return new TypeAdapter<RetryStrategy>(){

                @Override
                public void write(JsonWriter out, RetryStrategy value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public RetryStrategy read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    RetryStrategy.validateJsonObject(jsonObj);
                    RetryStrategy instance = (RetryStrategy)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

