/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.ResultFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Parameters for running sql query")
public class SQLParameters {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_QUERY = "query";
    @SerializedName(value="query")
    private String query;
    public static final String SERIALIZED_NAME_OUTPUT_URI = "output_uri";
    @SerializedName(value="output_uri")
    private String outputUri;
    public static final String SERIALIZED_NAME_STORE_RESULTS = "store_results";
    @SerializedName(value="store_results")
    private Boolean storeResults;
    public static final String SERIALIZED_NAME_DONT_DOWNLOAD_RESULTS = "dont_download_results";
    @SerializedName(value="dont_download_results")
    private Boolean dontDownloadResults;
    public static final String SERIALIZED_NAME_RESOURCE_CLASS = "resource_class";
    @SerializedName(value="resource_class")
    private String resourceClass;
    public static final String SERIALIZED_NAME_RESULT_FORMAT = "result_format";
    @SerializedName(value="result_format")
    private ResultFormat resultFormat;
    public static final String SERIALIZED_NAME_INIT_COMMANDS = "init_commands";
    @SerializedName(value="init_commands")
    private List<String> initCommands = null;
    public static final String SERIALIZED_NAME_PARAMETERS = "parameters";
    @SerializedName(value="parameters")
    private List<Object> parameters = null;
    public static final String SERIALIZED_NAME_TASK_GRAPH_UUID = "task_graph_uuid";
    @SerializedName(value="task_graph_uuid")
    private String taskGraphUuid;
    public static final String SERIALIZED_NAME_CLIENT_NODE_UUID = "client_node_uuid";
    @SerializedName(value="client_node_uuid")
    private String clientNodeUuid;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SQLParameters name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="name of task, optional")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SQLParameters query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="query to run")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public SQLParameters outputUri(String outputUri) {
        this.outputUri = outputUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="s3://my_bucket/my_output_array", value="Output array uri")
    public String getOutputUri() {
        return this.outputUri;
    }

    public void setOutputUri(String outputUri) {
        this.outputUri = outputUri;
    }

    public SQLParameters storeResults(Boolean storeResults) {
        this.storeResults = storeResults;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="store results for later retrieval")
    public Boolean getStoreResults() {
        return this.storeResults;
    }

    public void setStoreResults(Boolean storeResults) {
        this.storeResults = storeResults;
    }

    public SQLParameters dontDownloadResults(Boolean dontDownloadResults) {
        this.dontDownloadResults = dontDownloadResults;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set to true to avoid downloading the results of this UDF. Useful for intermediate nodes in a task graph where you will not be using the results of your function. Defaults to false (\"yes download results\").")
    public Boolean getDontDownloadResults() {
        return this.dontDownloadResults;
    }

    public void setDontDownloadResults(Boolean dontDownloadResults) {
        this.dontDownloadResults = dontDownloadResults;
    }

    public SQLParameters resourceClass(String resourceClass) {
        this.resourceClass = resourceClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="standard", value="The resource class to use for the SQL execution. Resource classes define resource limits for memory and CPUs. If this is empty, then the SQL will execute in the standard resource class of the TileDB Cloud provider. ")
    public String getResourceClass() {
        return this.resourceClass;
    }

    public void setResourceClass(String resourceClass) {
        this.resourceClass = resourceClass;
    }

    public SQLParameters resultFormat(ResultFormat resultFormat) {
        this.resultFormat = resultFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ResultFormat getResultFormat() {
        return this.resultFormat;
    }

    public void setResultFormat(ResultFormat resultFormat) {
        this.resultFormat = resultFormat;
    }

    public SQLParameters initCommands(List<String> initCommands) {
        this.initCommands = initCommands;
        return this;
    }

    public SQLParameters addInitCommandsItem(String initCommandsItem) {
        if (this.initCommands == null) {
            this.initCommands = new ArrayList<String>();
        }
        this.initCommands.add(initCommandsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Queries or commands to run before main query")
    public List<String> getInitCommands() {
        return this.initCommands;
    }

    public void setInitCommands(List<String> initCommands) {
        this.initCommands = initCommands;
    }

    public SQLParameters parameters(List<Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public SQLParameters addParametersItem(Object parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Object>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SQL query parameters")
    public List<Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    public SQLParameters taskGraphUuid(String taskGraphUuid) {
        this.taskGraphUuid = taskGraphUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, the ID of the log for the task graph that this was part of. ")
    public String getTaskGraphUuid() {
        return this.taskGraphUuid;
    }

    public void setTaskGraphUuid(String taskGraphUuid) {
        this.taskGraphUuid = taskGraphUuid;
    }

    public SQLParameters clientNodeUuid(String clientNodeUuid) {
        this.clientNodeUuid = clientNodeUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, the client-defined ID of the node within this task's graph. ")
    public String getClientNodeUuid() {
        return this.clientNodeUuid;
    }

    public void setClientNodeUuid(String clientNodeUuid) {
        this.clientNodeUuid = clientNodeUuid;
    }

    public SQLParameters putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLParameters sqLParameters = (SQLParameters)o;
        return Objects.equals(this.name, sqLParameters.name) && Objects.equals(this.query, sqLParameters.query) && Objects.equals(this.outputUri, sqLParameters.outputUri) && Objects.equals(this.storeResults, sqLParameters.storeResults) && Objects.equals(this.dontDownloadResults, sqLParameters.dontDownloadResults) && Objects.equals(this.resourceClass, sqLParameters.resourceClass) && Objects.equals((Object)this.resultFormat, (Object)sqLParameters.resultFormat) && Objects.equals(this.initCommands, sqLParameters.initCommands) && Objects.equals(this.parameters, sqLParameters.parameters) && Objects.equals(this.taskGraphUuid, sqLParameters.taskGraphUuid) && Objects.equals(this.clientNodeUuid, sqLParameters.clientNodeUuid) && Objects.equals(this.additionalProperties, sqLParameters.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.query, this.outputUri, this.storeResults, this.dontDownloadResults, this.resourceClass, this.resultFormat, this.initCommands, this.parameters, this.taskGraphUuid, this.clientNodeUuid, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SQLParameters {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    outputUri: ").append(this.toIndentedString(this.outputUri)).append("\n");
        sb.append("    storeResults: ").append(this.toIndentedString(this.storeResults)).append("\n");
        sb.append("    dontDownloadResults: ").append(this.toIndentedString(this.dontDownloadResults)).append("\n");
        sb.append("    resourceClass: ").append(this.toIndentedString(this.resourceClass)).append("\n");
        sb.append("    resultFormat: ").append(this.toIndentedString((Object)this.resultFormat)).append("\n");
        sb.append("    initCommands: ").append(this.toIndentedString(this.initCommands)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    taskGraphUuid: ").append(this.toIndentedString(this.taskGraphUuid)).append("\n");
        sb.append("    clientNodeUuid: ").append(this.toIndentedString(this.clientNodeUuid)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SQLParameters is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_QUERY) != null && !jsonObj.get(SERIALIZED_NAME_QUERY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_QUERY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `query` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QUERY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OUTPUT_URI) != null && !jsonObj.get(SERIALIZED_NAME_OUTPUT_URI).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OUTPUT_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `output_uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OUTPUT_URI).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_CLASS) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CLASS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CLASS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resource_class` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_CLASS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INIT_COMMANDS) != null && !jsonObj.get(SERIALIZED_NAME_INIT_COMMANDS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INIT_COMMANDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `init_commands` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INIT_COMMANDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PARAMETERS) != null && !jsonObj.get(SERIALIZED_NAME_PARAMETERS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PARAMETERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `parameters` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PARAMETERS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_UUID) != null && !jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `task_graph_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `client_node_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID).toString()));
        }
    }

    public static SQLParameters fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, SQLParameters.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_QUERY);
        openapiFields.add(SERIALIZED_NAME_OUTPUT_URI);
        openapiFields.add(SERIALIZED_NAME_STORE_RESULTS);
        openapiFields.add(SERIALIZED_NAME_DONT_DOWNLOAD_RESULTS);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_CLASS);
        openapiFields.add(SERIALIZED_NAME_RESULT_FORMAT);
        openapiFields.add(SERIALIZED_NAME_INIT_COMMANDS);
        openapiFields.add(SERIALIZED_NAME_PARAMETERS);
        openapiFields.add(SERIALIZED_NAME_TASK_GRAPH_UUID);
        openapiFields.add(SERIALIZED_NAME_CLIENT_NODE_UUID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!SQLParameters.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<SQLParameters> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(SQLParameters.class));
            return new TypeAdapter<SQLParameters>(){

                @Override
                public void write(JsonWriter out, SQLParameters value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public SQLParameters read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SQLParameters.validateJsonObject(jsonObj);
                    SQLParameters instance = (SQLParameters)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

