/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.DomainCheckResult;
import io.tiledb.cloud.rest_api.model.DomainVerificationStatus;
import io.tiledb.cloud.rest_api.model.SSODomainSetup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The information used to set up a single-sign on connection to a customer domain. ")
public class SSODomainConfig {
    public static final String SERIALIZED_NAME_UUID = "uuid";
    @SerializedName(value="uuid")
    private String uuid;
    public static final String SERIALIZED_NAME_DOMAIN = "domain";
    @SerializedName(value="domain")
    private String domain;
    public static final String SERIALIZED_NAME_OIDC_ISSUER = "oidc_issuer";
    @SerializedName(value="oidc_issuer")
    private String oidcIssuer;
    public static final String SERIALIZED_NAME_OIDC_CLIENT_ID = "oidc_client_id";
    @SerializedName(value="oidc_client_id")
    private String oidcClientId;
    public static final String SERIALIZED_NAME_OIDC_CLIENT_SECRET = "oidc_client_secret";
    @SerializedName(value="oidc_client_secret")
    private String oidcClientSecret;
    public static final String SERIALIZED_NAME_DOMAIN_SETUP = "domain_setup";
    @SerializedName(value="domain_setup")
    private SSODomainSetup domainSetup;
    public static final String SERIALIZED_NAME_VERIFICATION_STATUS = "verification_status";
    @SerializedName(value="verification_status")
    private DomainVerificationStatus verificationStatus;
    public static final String SERIALIZED_NAME_CHECK_RESULTS = "check_results";
    @SerializedName(value="check_results")
    private List<DomainCheckResult> checkResults = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SSODomainConfig uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A server-generated ID for the configuration.")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public SSODomainConfig domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fully-qualified domain (but with no trailing dot) to connect for single sign-on. This may not be changed after creation. ")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public SSODomainConfig oidcIssuer(String oidcIssuer) {
        this.oidcIssuer = oidcIssuer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL of the OpenID Connect issuer that can be used to authenticate this domain's users. The prefix where the `/.well-known/openid-configuration` file can be found; usually without a trailing slash. ")
    public String getOidcIssuer() {
        return this.oidcIssuer;
    }

    public void setOidcIssuer(String oidcIssuer) {
        this.oidcIssuer = oidcIssuer;
    }

    public SSODomainConfig oidcClientId(String oidcClientId) {
        this.oidcClientId = oidcClientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The OpenID Connect client ID for this SSO instance.")
    public String getOidcClientId() {
        return this.oidcClientId;
    }

    public void setOidcClientId(String oidcClientId) {
        this.oidcClientId = oidcClientId;
    }

    public SSODomainConfig oidcClientSecret(String oidcClientSecret) {
        this.oidcClientSecret = oidcClientSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The OpenID Connect client secret for this SSO instance.")
    public String getOidcClientSecret() {
        return this.oidcClientSecret;
    }

    public void setOidcClientSecret(String oidcClientSecret) {
        this.oidcClientSecret = oidcClientSecret;
    }

    public SSODomainConfig domainSetup(SSODomainSetup domainSetup) {
        this.domainSetup = domainSetup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SSODomainSetup getDomainSetup() {
        return this.domainSetup;
    }

    public void setDomainSetup(SSODomainSetup domainSetup) {
        this.domainSetup = domainSetup;
    }

    public SSODomainConfig verificationStatus(DomainVerificationStatus verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public DomainVerificationStatus getVerificationStatus() {
        return this.verificationStatus;
    }

    public void setVerificationStatus(DomainVerificationStatus verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public SSODomainConfig checkResults(List<DomainCheckResult> checkResults) {
        this.checkResults = checkResults;
        return this;
    }

    public SSODomainConfig addCheckResultsItem(DomainCheckResult checkResultsItem) {
        if (this.checkResults == null) {
            this.checkResults = new ArrayList<DomainCheckResult>();
        }
        this.checkResults.add(checkResultsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of the results of recent attempts to verify this domain. ")
    public List<DomainCheckResult> getCheckResults() {
        return this.checkResults;
    }

    public void setCheckResults(List<DomainCheckResult> checkResults) {
        this.checkResults = checkResults;
    }

    public SSODomainConfig putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SSODomainConfig ssODomainConfig = (SSODomainConfig)o;
        return Objects.equals(this.uuid, ssODomainConfig.uuid) && Objects.equals(this.domain, ssODomainConfig.domain) && Objects.equals(this.oidcIssuer, ssODomainConfig.oidcIssuer) && Objects.equals(this.oidcClientId, ssODomainConfig.oidcClientId) && Objects.equals(this.oidcClientSecret, ssODomainConfig.oidcClientSecret) && Objects.equals(this.domainSetup, ssODomainConfig.domainSetup) && Objects.equals((Object)this.verificationStatus, (Object)ssODomainConfig.verificationStatus) && Objects.equals(this.checkResults, ssODomainConfig.checkResults) && Objects.equals(this.additionalProperties, ssODomainConfig.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uuid, this.domain, this.oidcIssuer, this.oidcClientId, this.oidcClientSecret, this.domainSetup, this.verificationStatus, this.checkResults, this.additionalProperties});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SSODomainConfig {\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    oidcIssuer: ").append(this.toIndentedString(this.oidcIssuer)).append("\n");
        sb.append("    oidcClientId: ").append(this.toIndentedString(this.oidcClientId)).append("\n");
        sb.append("    oidcClientSecret: ").append(this.toIndentedString(this.oidcClientSecret)).append("\n");
        sb.append("    domainSetup: ").append(this.toIndentedString(this.domainSetup)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString((Object)this.verificationStatus)).append("\n");
        sb.append("    checkResults: ").append(this.toIndentedString(this.checkResults)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraycheckResults;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SSODomainConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UUID) != null && !jsonObj.get(SERIALIZED_NAME_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOMAIN) != null && !jsonObj.get(SERIALIZED_NAME_DOMAIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DOMAIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `domain` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOMAIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OIDC_ISSUER) != null && !jsonObj.get(SERIALIZED_NAME_OIDC_ISSUER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OIDC_ISSUER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `oidc_issuer` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OIDC_ISSUER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OIDC_CLIENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_OIDC_CLIENT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OIDC_CLIENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `oidc_client_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OIDC_CLIENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OIDC_CLIENT_SECRET) != null && !jsonObj.get(SERIALIZED_NAME_OIDC_CLIENT_SECRET).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OIDC_CLIENT_SECRET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `oidc_client_secret` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OIDC_CLIENT_SECRET).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOMAIN_SETUP) != null && !jsonObj.get(SERIALIZED_NAME_DOMAIN_SETUP).isJsonNull()) {
            SSODomainSetup.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DOMAIN_SETUP));
        }
        if ((jsonArraycheckResults = jsonObj.getAsJsonArray(SERIALIZED_NAME_CHECK_RESULTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CHECK_RESULTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `check_results` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHECK_RESULTS).toString()));
            }
            for (int i = 0; i < jsonArraycheckResults.size(); ++i) {
                DomainCheckResult.validateJsonObject(jsonArraycheckResults.get(i).getAsJsonObject());
            }
        }
    }

    public static SSODomainConfig fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, SSODomainConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_UUID);
        openapiFields.add(SERIALIZED_NAME_DOMAIN);
        openapiFields.add(SERIALIZED_NAME_OIDC_ISSUER);
        openapiFields.add(SERIALIZED_NAME_OIDC_CLIENT_ID);
        openapiFields.add(SERIALIZED_NAME_OIDC_CLIENT_SECRET);
        openapiFields.add(SERIALIZED_NAME_DOMAIN_SETUP);
        openapiFields.add(SERIALIZED_NAME_VERIFICATION_STATUS);
        openapiFields.add(SERIALIZED_NAME_CHECK_RESULTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!SSODomainConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<SSODomainConfig> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(SSODomainConfig.class));
            return new TypeAdapter<SSODomainConfig>(){

                @Override
                public void write(JsonWriter out, SSODomainConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public SSODomainConfig read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SSODomainConfig.validateJsonObject(jsonObj);
                    SSODomainConfig instance = (SSODomainConfig)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

