/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Configuration settings to verify ownership of a given domain. At least one of these must be completed enable user login from the domain. ")
public class SSODomainSetup {
    public static final String SERIALIZED_NAME_TXT = "txt";
    @SerializedName(value="txt")
    private String txt;
    public static final String SERIALIZED_NAME_CNAME_SRC = "cname_src";
    @SerializedName(value="cname_src")
    private String cnameSrc;
    public static final String SERIALIZED_NAME_CNAME_DST = "cname_dst";
    @SerializedName(value="cname_dst")
    private String cnameDst;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SSODomainSetup txt(String txt) {
        this.txt = txt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="a DNS TXT record to set on the domain to claim.")
    public String getTxt() {
        return this.txt;
    }

    public void setTxt(String txt) {
        this.txt = txt;
    }

    public SSODomainSetup cnameSrc(String cnameSrc) {
        this.cnameSrc = cnameSrc;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="a DNS name to set a CNAME record on")
    public String getCnameSrc() {
        return this.cnameSrc;
    }

    public void setCnameSrc(String cnameSrc) {
        this.cnameSrc = cnameSrc;
    }

    public SSODomainSetup cnameDst(String cnameDst) {
        this.cnameDst = cnameDst;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the CNAME target of `cname_src`.")
    public String getCnameDst() {
        return this.cnameDst;
    }

    public void setCnameDst(String cnameDst) {
        this.cnameDst = cnameDst;
    }

    public SSODomainSetup putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SSODomainSetup ssODomainSetup = (SSODomainSetup)o;
        return Objects.equals(this.txt, ssODomainSetup.txt) && Objects.equals(this.cnameSrc, ssODomainSetup.cnameSrc) && Objects.equals(this.cnameDst, ssODomainSetup.cnameDst) && Objects.equals(this.additionalProperties, ssODomainSetup.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.txt, this.cnameSrc, this.cnameDst, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SSODomainSetup {\n");
        sb.append("    txt: ").append(this.toIndentedString(this.txt)).append("\n");
        sb.append("    cnameSrc: ").append(this.toIndentedString(this.cnameSrc)).append("\n");
        sb.append("    cnameDst: ").append(this.toIndentedString(this.cnameDst)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SSODomainSetup is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TXT) != null && !jsonObj.get(SERIALIZED_NAME_TXT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `txt` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TXT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CNAME_SRC) != null && !jsonObj.get(SERIALIZED_NAME_CNAME_SRC).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CNAME_SRC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cname_src` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CNAME_SRC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CNAME_DST) != null && !jsonObj.get(SERIALIZED_NAME_CNAME_DST).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CNAME_DST).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cname_dst` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CNAME_DST).toString()));
        }
    }

    public static SSODomainSetup fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, SSODomainSetup.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TXT);
        openapiFields.add(SERIALIZED_NAME_CNAME_SRC);
        openapiFields.add(SERIALIZED_NAME_CNAME_DST);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!SSODomainSetup.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<SSODomainSetup> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(SSODomainSetup.class));
            return new TypeAdapter<SSODomainSetup>(){

                @Override
                public void write(JsonWriter out, SSODomainSetup value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public SSODomainSetup read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SSODomainSetup.validateJsonObject(jsonObj);
                    SSODomainSetup instance = (SSODomainSetup)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

