/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The path at which a given asset will be stored, and the credentials used to access that asset. ")
public class StorageLocation {
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_CREDENTIALS_NAME = "credentials_name";
    @SerializedName(value="credentials_name")
    private String credentialsName;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public StorageLocation path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The path to store this asset type. If unset, a suffix of the user's `default_s3_path` is used. When updating, explicitly set to `\"\"`, the empty string, to clear this path; leaving it `null` (or absent) will leave the path unchanged. ")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public StorageLocation credentialsName(String credentialsName) {
        this.credentialsName = credentialsName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the credentials used to acess this storage path. If unset, the `default_s3_path_credentials_name` is used. When updating, explicitly set to `\"\"`, the empty string, to clear this name; leaving it `null` (or absent) will leave the name unchanged. ")
    public String getCredentialsName() {
        return this.credentialsName;
    }

    public void setCredentialsName(String credentialsName) {
        this.credentialsName = credentialsName;
    }

    public StorageLocation putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageLocation storageLocation = (StorageLocation)o;
        return Objects.equals(this.path, storageLocation.path) && Objects.equals(this.credentialsName, storageLocation.credentialsName) && Objects.equals(this.additionalProperties, storageLocation.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.path, this.credentialsName, this.additionalProperties);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StorageLocation {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    credentialsName: ").append(this.toIndentedString(this.credentialsName)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in StorageLocation is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PATH) != null && !jsonObj.get(SERIALIZED_NAME_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREDENTIALS_NAME) != null && !jsonObj.get(SERIALIZED_NAME_CREDENTIALS_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREDENTIALS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `credentials_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREDENTIALS_NAME).toString()));
        }
    }

    public static StorageLocation fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, StorageLocation.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PATH);
        openapiFields.add(SERIALIZED_NAME_CREDENTIALS_NAME);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!StorageLocation.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<StorageLocation> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(StorageLocation.class));
            return new TypeAdapter<StorageLocation>(){

                @Override
                public void write(JsonWriter out, StorageLocation value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public StorageLocation read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    StorageLocation.validateJsonObject(jsonObj);
                    StorageLocation instance = (StorageLocation)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

