/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.AttributeBufferSize;
import io.tiledb.cloud.rest_api.model.Subarray;
import io.tiledb.cloud.rest_api.model.SubarrayPartitionerCurrent;
import io.tiledb.cloud.rest_api.model.SubarrayPartitionerState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The subarray partitioner")
public class SubarrayPartitioner {
    public static final String SERIALIZED_NAME_SUBARRAY = "subarray";
    @SerializedName(value="subarray")
    private Subarray subarray;
    public static final String SERIALIZED_NAME_BUDGET = "budget";
    @SerializedName(value="budget")
    private List<AttributeBufferSize> budget = null;
    public static final String SERIALIZED_NAME_CURRENT = "current";
    @SerializedName(value="current")
    private SubarrayPartitionerCurrent current;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private SubarrayPartitionerState state;
    public static final String SERIALIZED_NAME_MEMORY_BUDGET = "memoryBudget";
    @SerializedName(value="memoryBudget")
    private Integer memoryBudget;
    public static final String SERIALIZED_NAME_MEMORY_BUDGET_VAR = "memoryBudgetVar";
    @SerializedName(value="memoryBudgetVar")
    private Integer memoryBudgetVar;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SubarrayPartitioner subarray(Subarray subarray) {
        this.subarray = subarray;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Subarray getSubarray() {
        return this.subarray;
    }

    public void setSubarray(Subarray subarray) {
        this.subarray = subarray;
    }

    public SubarrayPartitioner budget(List<AttributeBufferSize> budget) {
        this.budget = budget;
        return this;
    }

    public SubarrayPartitioner addBudgetItem(AttributeBufferSize budgetItem) {
        if (this.budget == null) {
            this.budget = new ArrayList<AttributeBufferSize>();
        }
        this.budget.add(budgetItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Result size budget (in bytes) for all attributes.")
    public List<AttributeBufferSize> getBudget() {
        return this.budget;
    }

    public void setBudget(List<AttributeBufferSize> budget) {
        this.budget = budget;
    }

    public SubarrayPartitioner current(SubarrayPartitionerCurrent current) {
        this.current = current;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SubarrayPartitionerCurrent getCurrent() {
        return this.current;
    }

    public void setCurrent(SubarrayPartitionerCurrent current) {
        this.current = current;
    }

    public SubarrayPartitioner state(SubarrayPartitionerState state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SubarrayPartitionerState getState() {
        return this.state;
    }

    public void setState(SubarrayPartitionerState state) {
        this.state = state;
    }

    public SubarrayPartitioner memoryBudget(Integer memoryBudget) {
        this.memoryBudget = memoryBudget;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The memory budget for the fixed-sized attributes and the offsets of the var-sized attributes")
    public Integer getMemoryBudget() {
        return this.memoryBudget;
    }

    public void setMemoryBudget(Integer memoryBudget) {
        this.memoryBudget = memoryBudget;
    }

    public SubarrayPartitioner memoryBudgetVar(Integer memoryBudgetVar) {
        this.memoryBudgetVar = memoryBudgetVar;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The memory budget for the var-sized attributes")
    public Integer getMemoryBudgetVar() {
        return this.memoryBudgetVar;
    }

    public void setMemoryBudgetVar(Integer memoryBudgetVar) {
        this.memoryBudgetVar = memoryBudgetVar;
    }

    public SubarrayPartitioner putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubarrayPartitioner subarrayPartitioner = (SubarrayPartitioner)o;
        return Objects.equals(this.subarray, subarrayPartitioner.subarray) && Objects.equals(this.budget, subarrayPartitioner.budget) && Objects.equals(this.current, subarrayPartitioner.current) && Objects.equals(this.state, subarrayPartitioner.state) && Objects.equals(this.memoryBudget, subarrayPartitioner.memoryBudget) && Objects.equals(this.memoryBudgetVar, subarrayPartitioner.memoryBudgetVar) && Objects.equals(this.additionalProperties, subarrayPartitioner.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.subarray, this.budget, this.current, this.state, this.memoryBudget, this.memoryBudgetVar, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubarrayPartitioner {\n");
        sb.append("    subarray: ").append(this.toIndentedString(this.subarray)).append("\n");
        sb.append("    budget: ").append(this.toIndentedString(this.budget)).append("\n");
        sb.append("    current: ").append(this.toIndentedString(this.current)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    memoryBudget: ").append(this.toIndentedString(this.memoryBudget)).append("\n");
        sb.append("    memoryBudgetVar: ").append(this.toIndentedString(this.memoryBudgetVar)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraybudget;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SubarrayPartitioner is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBARRAY) != null && !jsonObj.get(SERIALIZED_NAME_SUBARRAY).isJsonNull()) {
            Subarray.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SUBARRAY));
        }
        if ((jsonArraybudget = jsonObj.getAsJsonArray(SERIALIZED_NAME_BUDGET)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BUDGET).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `budget` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUDGET).toString()));
            }
            for (int i = 0; i < jsonArraybudget.size(); ++i) {
                AttributeBufferSize.validateJsonObject(jsonArraybudget.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENT) != null && !jsonObj.get(SERIALIZED_NAME_CURRENT).isJsonNull()) {
            SubarrayPartitionerCurrent.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CURRENT));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE) != null && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonNull()) {
            SubarrayPartitionerState.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_STATE));
        }
    }

    public static SubarrayPartitioner fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, SubarrayPartitioner.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SUBARRAY);
        openapiFields.add(SERIALIZED_NAME_BUDGET);
        openapiFields.add(SERIALIZED_NAME_CURRENT);
        openapiFields.add(SERIALIZED_NAME_STATE);
        openapiFields.add(SERIALIZED_NAME_MEMORY_BUDGET);
        openapiFields.add(SERIALIZED_NAME_MEMORY_BUDGET_VAR);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!SubarrayPartitioner.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<SubarrayPartitioner> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(SubarrayPartitioner.class));
            return new TypeAdapter<SubarrayPartitioner>(){

                @Override
                public void write(JsonWriter out, SubarrayPartitioner value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public SubarrayPartitioner read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SubarrayPartitioner.validateJsonObject(jsonObj);
                    SubarrayPartitioner instance = (SubarrayPartitioner)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

