/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.Pricing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Subscription of a user (customer) to another user's arrays")
public class Subscription {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_OWNER_NAMESPACE_UUID = "owner_namespace_uuid";
    @SerializedName(value="owner_namespace_uuid")
    private String ownerNamespaceUuid;
    public static final String SERIALIZED_NAME_CUSTOMER_NAMESPACE_UUID = "customer_namespace_uuid";
    @SerializedName(value="customer_namespace_uuid")
    private String customerNamespaceUuid;
    public static final String SERIALIZED_NAME_PRICING = "pricing";
    @SerializedName(value="pricing")
    private List<Pricing> pricing = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Subscription id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="subscriptionID", value="Unique ID of subscription as defined by Stripe")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Subscription ownerNamespaceUuid(String ownerNamespaceUuid) {
        this.ownerNamespaceUuid = ownerNamespaceUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Unique ID of the array (product) owner")
    public String getOwnerNamespaceUuid() {
        return this.ownerNamespaceUuid;
    }

    public void setOwnerNamespaceUuid(String ownerNamespaceUuid) {
        this.ownerNamespaceUuid = ownerNamespaceUuid;
    }

    public Subscription customerNamespaceUuid(String customerNamespaceUuid) {
        this.customerNamespaceUuid = customerNamespaceUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Unique ID of the array (product) user (customer)")
    public String getCustomerNamespaceUuid() {
        return this.customerNamespaceUuid;
    }

    public void setCustomerNamespaceUuid(String customerNamespaceUuid) {
        this.customerNamespaceUuid = customerNamespaceUuid;
    }

    public Subscription pricing(List<Pricing> pricing) {
        this.pricing = pricing;
        return this;
    }

    public Subscription addPricingItem(Pricing pricingItem) {
        if (this.pricing == null) {
            this.pricing = new ArrayList<Pricing>();
        }
        this.pricing.add(pricingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="list of pricing used by this subscription")
    public List<Pricing> getPricing() {
        return this.pricing;
    }

    public void setPricing(List<Pricing> pricing) {
        this.pricing = pricing;
    }

    public Subscription putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription subscription = (Subscription)o;
        return Objects.equals(this.id, subscription.id) && Objects.equals(this.ownerNamespaceUuid, subscription.ownerNamespaceUuid) && Objects.equals(this.customerNamespaceUuid, subscription.customerNamespaceUuid) && Objects.equals(this.pricing, subscription.pricing) && Objects.equals(this.additionalProperties, subscription.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.ownerNamespaceUuid, this.customerNamespaceUuid, this.pricing, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Subscription {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    ownerNamespaceUuid: ").append(this.toIndentedString(this.ownerNamespaceUuid)).append("\n");
        sb.append("    customerNamespaceUuid: ").append(this.toIndentedString(this.customerNamespaceUuid)).append("\n");
        sb.append("    pricing: ").append(this.toIndentedString(this.pricing)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Subscription is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OWNER_NAMESPACE_UUID) != null && !jsonObj.get(SERIALIZED_NAME_OWNER_NAMESPACE_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OWNER_NAMESPACE_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `owner_namespace_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OWNER_NAMESPACE_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUSTOMER_NAMESPACE_UUID) != null && !jsonObj.get(SERIALIZED_NAME_CUSTOMER_NAMESPACE_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CUSTOMER_NAMESPACE_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `customer_namespace_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUSTOMER_NAMESPACE_UUID).toString()));
        }
        JsonArray jsonArraypricing = jsonObj.getAsJsonArray(SERIALIZED_NAME_PRICING);
        if (jsonArraypricing != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PRICING).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `pricing` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRICING).toString()));
            }
            for (int i = 0; i < jsonArraypricing.size(); ++i) {
                Pricing.validateJsonObject(jsonArraypricing.get(i).getAsJsonObject());
            }
        }
    }

    public static Subscription fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, Subscription.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_OWNER_NAMESPACE_UUID);
        openapiFields.add(SERIALIZED_NAME_CUSTOMER_NAMESPACE_UUID);
        openapiFields.add(SERIALIZED_NAME_PRICING);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Subscription.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<Subscription> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(Subscription.class));
            return new TypeAdapter<Subscription>(){

                @Override
                public void write(JsonWriter out, Subscription value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public Subscription read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Subscription.validateJsonObject(jsonObj);
                    Subscription instance = (Subscription)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

