/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.ResultFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="A node specifying an SQL query to execute in TileDB Cloud. ")
public class TGSQLNodeData {
    public static final String SERIALIZED_NAME_INIT_COMMANDS = "init_commands";
    @SerializedName(value="init_commands")
    private List<String> initCommands = null;
    public static final String SERIALIZED_NAME_QUERY = "query";
    @SerializedName(value="query")
    private String query;
    public static final String SERIALIZED_NAME_PARAMETERS = "parameters";
    @SerializedName(value="parameters")
    private List<Object> parameters = null;
    public static final String SERIALIZED_NAME_RESULT_FORMAT = "result_format";
    @SerializedName(value="result_format")
    private ResultFormat resultFormat;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    private String namespace;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TGSQLNodeData initCommands(List<String> initCommands) {
        this.initCommands = initCommands;
        return this;
    }

    public TGSQLNodeData addInitCommandsItem(String initCommandsItem) {
        if (this.initCommands == null) {
            this.initCommands = new ArrayList<String>();
        }
        this.initCommands.add(initCommandsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The commands to execute before running the query itself.")
    public List<String> getInitCommands() {
        return this.initCommands;
    }

    public void setInitCommands(List<String> initCommands) {
        this.initCommands = initCommands;
    }

    public TGSQLNodeData query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The text of the SQL query to execute. Parameters are substituted in for `?`s, just as in a regular MariaDB query. ")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public TGSQLNodeData parameters(List<Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public TGSQLNodeData addParametersItem(Object parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Object>();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The parameters to substitute in for arguments in the `query`. Fixed-length. Arguments must be in JSON format. ")
    public List<Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    public TGSQLNodeData resultFormat(ResultFormat resultFormat) {
        this.resultFormat = resultFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ResultFormat getResultFormat() {
        return this.resultFormat;
    }

    public void setResultFormat(ResultFormat resultFormat) {
        this.resultFormat = resultFormat;
    }

    public TGSQLNodeData namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, the non-default namespace to execute this SQL query under. ")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public TGSQLNodeData putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TGSQLNodeData tgSQLNodeData = (TGSQLNodeData)o;
        return Objects.equals(this.initCommands, tgSQLNodeData.initCommands) && Objects.equals(this.query, tgSQLNodeData.query) && Objects.equals(this.parameters, tgSQLNodeData.parameters) && Objects.equals((Object)this.resultFormat, (Object)tgSQLNodeData.resultFormat) && Objects.equals(this.namespace, tgSQLNodeData.namespace) && Objects.equals(this.additionalProperties, tgSQLNodeData.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.initCommands, this.query, this.parameters, this.resultFormat, this.namespace, this.additionalProperties});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TGSQLNodeData {\n");
        sb.append("    initCommands: ").append(this.toIndentedString(this.initCommands)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    resultFormat: ").append(this.toIndentedString((Object)this.resultFormat)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TGSQLNodeData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INIT_COMMANDS) != null && !jsonObj.get(SERIALIZED_NAME_INIT_COMMANDS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INIT_COMMANDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `init_commands` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INIT_COMMANDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_QUERY) != null && !jsonObj.get(SERIALIZED_NAME_QUERY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_QUERY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `query` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QUERY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PARAMETERS) != null && !jsonObj.get(SERIALIZED_NAME_PARAMETERS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PARAMETERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `parameters` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PARAMETERS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
    }

    public static TGSQLNodeData fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, TGSQLNodeData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_INIT_COMMANDS);
        openapiFields.add(SERIALIZED_NAME_QUERY);
        openapiFields.add(SERIALIZED_NAME_PARAMETERS);
        openapiFields.add(SERIALIZED_NAME_RESULT_FORMAT);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TGSQLNodeData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<TGSQLNodeData> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(TGSQLNodeData.class));
            return new TypeAdapter<TGSQLNodeData>(){

                @Override
                public void write(JsonWriter out, TGSQLNodeData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public TGSQLNodeData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TGSQLNodeData.validateJsonObject(jsonObj);
                    TGSQLNodeData instance = (TGSQLNodeData)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

