/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.TGUDFEnvironmentResources;
import io.tiledb.cloud.rest_api.model.UDFLanguage;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Metadata about the environment where we want to execute a UDF.")
public class TGUDFEnvironment {
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    private UDFLanguage language;
    public static final String SERIALIZED_NAME_LANGUAGE_VERSION = "language_version";
    @SerializedName(value="language_version")
    private String languageVersion;
    public static final String SERIALIZED_NAME_IMAGE_NAME = "image_name";
    @SerializedName(value="image_name")
    private String imageName;
    public static final String SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME = "access_credentials_name";
    @SerializedName(value="access_credentials_name")
    private String accessCredentialsName;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    private String namespace;
    public static final String SERIALIZED_NAME_RESOURCE_CLASS = "resource_class";
    @SerializedName(value="resource_class")
    private String resourceClass;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private TGUDFEnvironmentResources resources;
    public static final String SERIALIZED_NAME_RUN_CLIENT_SIDE = "run_client_side";
    @SerializedName(value="run_client_side")
    private Boolean runClientSide;
    public static final String SERIALIZED_NAME_TIMEOUT = "timeout";
    @SerializedName(value="timeout")
    private BigDecimal timeout;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TGUDFEnvironment language(UDFLanguage language) {
        this.language = language;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UDFLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(UDFLanguage language) {
        this.language = language;
    }

    public TGUDFEnvironment languageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The language version used to execute this UDF. Neither this nor `language` needs to be set for registered UDFs, since the language and version are stored server-side with the UDF itself. ")
    public String getLanguageVersion() {
        return this.languageVersion;
    }

    public void setLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
    }

    public TGUDFEnvironment imageName(String imageName) {
        this.imageName = imageName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the image to use for the execution environment. ")
    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public TGUDFEnvironment accessCredentialsName(String accessCredentialsName) {
        this.accessCredentialsName = accessCredentialsName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the access credentials to use. if unset, no credentials will be configured in the environment. ")
    public String getAccessCredentialsName() {
        return this.accessCredentialsName;
    }

    public void setAccessCredentialsName(String accessCredentialsName) {
        this.accessCredentialsName = accessCredentialsName;
    }

    public TGUDFEnvironment namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, the non-default namespace to execute this UDF under (and to query any Array Nodes that are used as inputs to this UDF). ")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public TGUDFEnvironment resourceClass(String resourceClass) {
        this.resourceClass = resourceClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The resource class to use for the UDF execution. Resource classes define resource limits for memory and CPUs. If this is empty, then the UDF will execute in the standard resource class of the TileDB Cloud provider. ")
    public String getResourceClass() {
        return this.resourceClass;
    }

    public void setResourceClass(String resourceClass) {
        this.resourceClass = resourceClass;
    }

    public TGUDFEnvironment resources(TGUDFEnvironmentResources resources) {
        this.resources = resources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TGUDFEnvironmentResources getResources() {
        return this.resources;
    }

    public void setResources(TGUDFEnvironmentResources resources) {
        this.resources = resources;
    }

    public TGUDFEnvironment runClientSide(Boolean runClientSide) {
        this.runClientSide = runClientSide;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A hint that, if possible, this function should be executed on the client side rather than on the server. Registered UDFs and functions which take arrays as inputs can never be executed client-side. If the client\u2019s environment is incompatible, or the client does not support client-side execution, the function will be executed on the server. ")
    public Boolean getRunClientSide() {
        return this.runClientSide;
    }

    public void setRunClientSide(Boolean runClientSide) {
        this.runClientSide = runClientSide;
    }

    public TGUDFEnvironment timeout(BigDecimal timeout2) {
        this.timeout = timeout2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum length of time this UDF is allowed to execute for before it is killed and fails. If not present (or zero), the function is allowed to run indefinitely (subject to the server\u2019s global limits). ")
    public BigDecimal getTimeout() {
        return this.timeout;
    }

    public void setTimeout(BigDecimal timeout2) {
        this.timeout = timeout2;
    }

    public TGUDFEnvironment putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TGUDFEnvironment tgUDFEnvironment = (TGUDFEnvironment)o;
        return Objects.equals((Object)this.language, (Object)tgUDFEnvironment.language) && Objects.equals(this.languageVersion, tgUDFEnvironment.languageVersion) && Objects.equals(this.imageName, tgUDFEnvironment.imageName) && Objects.equals(this.accessCredentialsName, tgUDFEnvironment.accessCredentialsName) && Objects.equals(this.namespace, tgUDFEnvironment.namespace) && Objects.equals(this.resourceClass, tgUDFEnvironment.resourceClass) && Objects.equals(this.resources, tgUDFEnvironment.resources) && Objects.equals(this.runClientSide, tgUDFEnvironment.runClientSide) && Objects.equals(this.timeout, tgUDFEnvironment.timeout) && Objects.equals(this.additionalProperties, tgUDFEnvironment.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.language, this.languageVersion, this.imageName, this.accessCredentialsName, this.namespace, this.resourceClass, this.resources, this.runClientSide, this.timeout, this.additionalProperties});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TGUDFEnvironment {\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    languageVersion: ").append(this.toIndentedString(this.languageVersion)).append("\n");
        sb.append("    imageName: ").append(this.toIndentedString(this.imageName)).append("\n");
        sb.append("    accessCredentialsName: ").append(this.toIndentedString(this.accessCredentialsName)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    resourceClass: ").append(this.toIndentedString(this.resourceClass)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    runClientSide: ").append(this.toIndentedString(this.runClientSide)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TGUDFEnvironment is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LANGUAGE_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_LANGUAGE_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LANGUAGE_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `language_version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LANGUAGE_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `access_credentials_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_CLASS) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CLASS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CLASS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resource_class` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_CLASS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonNull()) {
            TGUDFEnvironmentResources.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RESOURCES));
        }
    }

    public static TGUDFEnvironment fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, TGUDFEnvironment.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LANGUAGE);
        openapiFields.add(SERIALIZED_NAME_LANGUAGE_VERSION);
        openapiFields.add(SERIALIZED_NAME_IMAGE_NAME);
        openapiFields.add(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_CLASS);
        openapiFields.add(SERIALIZED_NAME_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_RUN_CLIENT_SIDE);
        openapiFields.add(SERIALIZED_NAME_TIMEOUT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TGUDFEnvironment.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<TGUDFEnvironment> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(TGUDFEnvironment.class));
            return new TypeAdapter<TGUDFEnvironment>(){

                @Override
                public void write(JsonWriter out, TGUDFEnvironment value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public TGUDFEnvironment read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TGUDFEnvironment.validateJsonObject(jsonObj);
                    TGUDFEnvironment instance = (TGUDFEnvironment)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

