/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.ResultFormat;
import io.tiledb.cloud.rest_api.model.TGUDFArgument;
import io.tiledb.cloud.rest_api.model.TGUDFEnvironment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="A node specifying the execution of a user-defined function.")
public class TGUDFNodeData {
    public static final String SERIALIZED_NAME_REGISTERED_UDF_NAME = "registered_udf_name";
    @SerializedName(value="registered_udf_name")
    private String registeredUdfName;
    public static final String SERIALIZED_NAME_EXECUTABLE_CODE = "executable_code";
    @SerializedName(value="executable_code")
    private String executableCode;
    public static final String SERIALIZED_NAME_SOURCE_TEXT = "source_text";
    @SerializedName(value="source_text")
    private String sourceText;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private TGUDFEnvironment environment;
    public static final String SERIALIZED_NAME_ARGUMENTS = "arguments";
    @SerializedName(value="arguments")
    private List<TGUDFArgument> arguments = null;
    public static final String SERIALIZED_NAME_RESULT_FORMAT = "result_format";
    @SerializedName(value="result_format")
    private ResultFormat resultFormat;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TGUDFNodeData registeredUdfName(String registeredUdfName) {
        this.registeredUdfName = registeredUdfName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, the name of the registered UDF to execute, in the format `namespace/name`. Either this or `executable_code` should be set, but not both. ")
    public String getRegisteredUdfName() {
        return this.registeredUdfName;
    }

    public void setRegisteredUdfName(String registeredUdfName) {
        this.registeredUdfName = registeredUdfName;
    }

    public TGUDFNodeData executableCode(String executableCode) {
        this.executableCode = executableCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, the base64 serialization of the code for this step, encoded in a language-specific format (e.g. Pickle for Python, serialization for R). ")
    public String getExecutableCode() {
        return this.executableCode;
    }

    public void setExecutableCode(String executableCode) {
        this.executableCode = executableCode;
    }

    public TGUDFNodeData sourceText(String sourceText) {
        this.sourceText = sourceText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optionally, the source text for the code passed in `executable_code`. *For reference only; only the code in `executable_code` is actually executed.* This will be included in activity logs and may be useful for debugging. ")
    public String getSourceText() {
        return this.sourceText;
    }

    public void setSourceText(String sourceText) {
        this.sourceText = sourceText;
    }

    public TGUDFNodeData environment(TGUDFEnvironment environment) {
        this.environment = environment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TGUDFEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(TGUDFEnvironment environment) {
        this.environment = environment;
    }

    public TGUDFNodeData arguments(List<TGUDFArgument> arguments) {
        this.arguments = arguments;
        return this;
    }

    public TGUDFNodeData addArgumentsItem(TGUDFArgument argumentsItem) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<TGUDFArgument>();
        }
        this.arguments.add(argumentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The arguments to a UDF function. This encompasses both named and positional arguments. The format is designed to provide compatibility across languages like Python which have a fairly traditional split between positional arguments and named arguments, and languages like R which has a rather unique way of specifying arguments. For Python (and most other languages), all positional arguments will come before all named arguments (if any are present):      // fn(arg1, arg2, arg3)     [       {value: arg1},       {value: arg2},       {value: arg3},     ]     // fn(arg1, arg2, n=kw1, a=kw2)     [       {value: arg1},       {value: arg2},       {name: \"n\", value: kw1},       {name: \"a\", value: kw2},     ]     // fn(kw=k1, only=k2)     [       {name: \"kw\", value: k1},       {name: \"only\", value: k2},     ]  However, in R, named and positional arguments may be intermixed freely:      // fn(arg, n=kw1, arg2)     [       {value: arg},       {name: \"n\", value: kw1},       {value: arg2},     ] ")
    public List<TGUDFArgument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<TGUDFArgument> arguments) {
        this.arguments = arguments;
    }

    public TGUDFNodeData resultFormat(ResultFormat resultFormat) {
        this.resultFormat = resultFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ResultFormat getResultFormat() {
        return this.resultFormat;
    }

    public void setResultFormat(ResultFormat resultFormat) {
        this.resultFormat = resultFormat;
    }

    public TGUDFNodeData putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TGUDFNodeData tgUDFNodeData = (TGUDFNodeData)o;
        return Objects.equals(this.registeredUdfName, tgUDFNodeData.registeredUdfName) && Objects.equals(this.executableCode, tgUDFNodeData.executableCode) && Objects.equals(this.sourceText, tgUDFNodeData.sourceText) && Objects.equals(this.environment, tgUDFNodeData.environment) && Objects.equals(this.arguments, tgUDFNodeData.arguments) && Objects.equals((Object)this.resultFormat, (Object)tgUDFNodeData.resultFormat) && Objects.equals(this.additionalProperties, tgUDFNodeData.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.registeredUdfName, this.executableCode, this.sourceText, this.environment, this.arguments, this.resultFormat, this.additionalProperties});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TGUDFNodeData {\n");
        sb.append("    registeredUdfName: ").append(this.toIndentedString(this.registeredUdfName)).append("\n");
        sb.append("    executableCode: ").append(this.toIndentedString(this.executableCode)).append("\n");
        sb.append("    sourceText: ").append(this.toIndentedString(this.sourceText)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    resultFormat: ").append(this.toIndentedString((Object)this.resultFormat)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayarguments;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TGUDFNodeData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REGISTERED_UDF_NAME) != null && !jsonObj.get(SERIALIZED_NAME_REGISTERED_UDF_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REGISTERED_UDF_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `registered_udf_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REGISTERED_UDF_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXECUTABLE_CODE) != null && !jsonObj.get(SERIALIZED_NAME_EXECUTABLE_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXECUTABLE_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `executable_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXECUTABLE_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE_TEXT) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE_TEXT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SOURCE_TEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `source_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_TEXT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVIRONMENT) != null && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT).isJsonNull()) {
            TGUDFEnvironment.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ENVIRONMENT));
        }
        if ((jsonArrayarguments = jsonObj.getAsJsonArray(SERIALIZED_NAME_ARGUMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ARGUMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `arguments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARGUMENTS).toString()));
            }
            for (int i = 0; i < jsonArrayarguments.size(); ++i) {
                TGUDFArgument.validateJsonObject(jsonArrayarguments.get(i).getAsJsonObject());
            }
        }
    }

    public static TGUDFNodeData fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, TGUDFNodeData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_REGISTERED_UDF_NAME);
        openapiFields.add(SERIALIZED_NAME_EXECUTABLE_CODE);
        openapiFields.add(SERIALIZED_NAME_SOURCE_TEXT);
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENT);
        openapiFields.add(SERIALIZED_NAME_ARGUMENTS);
        openapiFields.add(SERIALIZED_NAME_RESULT_FORMAT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TGUDFNodeData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<TGUDFNodeData> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(TGUDFNodeData.class));
            return new TypeAdapter<TGUDFNodeData>(){

                @Override
                public void write(JsonWriter out, TGUDFNodeData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public TGUDFNodeData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TGUDFNodeData.validateJsonObject(jsonObj);
                    TGUDFNodeData instance = (TGUDFNodeData)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

