/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.RetryStrategy;
import io.tiledb.cloud.rest_api.model.TaskGraphNode;
import io.tiledb.cloud.rest_api.model.TaskGraphType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Information about a task graph.")
public class TaskGraph {
    public static final String SERIALIZED_NAME_UUID = "uuid";
    @SerializedName(value="uuid")
    private String uuid;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    private String namespace;
    public static final String SERIALIZED_NAME_CREATED_BY = "created_by";
    @SerializedName(value="created_by")
    private String createdBy;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_NODES = "nodes";
    @SerializedName(value="nodes")
    private List<TaskGraphNode> nodes = null;
    public static final String SERIALIZED_NAME_PARALLELISM = "parallelism";
    @SerializedName(value="parallelism")
    private Long parallelism;
    public static final String SERIALIZED_NAME_RETRY_STRATEGY = "retry_strategy";
    @SerializedName(value="retry_strategy")
    private RetryStrategy retryStrategy;
    public static final String SERIALIZED_NAME_DEADLINE = "deadline";
    @SerializedName(value="deadline")
    private Long deadline;
    public static final String SERIALIZED_NAME_TASK_GRAPH_TYPE = "task_graph_type";
    @SerializedName(value="task_graph_type")
    private TaskGraphType taskGraphType;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TaskGraph() {
    }

    public TaskGraph(String uuid, String createdBy, OffsetDateTime createdAt) {
        this();
        this.uuid = uuid;
        this.createdBy = createdBy;
        this.createdAt = createdAt;
    }

    @Nullable
    @ApiModelProperty(value="The server-generated UUID of the task graph.")
    public String getUuid() {
        return this.uuid;
    }

    public TaskGraph namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The namespace that owns this task graph. When creating a task graph log, this is used as the namespace to create the log in; thereafter it is read-only. ")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Nullable
    @ApiModelProperty(value="The name of the user who created this task graph log.")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public TaskGraph name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A name for this task graph, displayed in the UI. Does not need to be unique. ")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    @ApiModelProperty(value="The date/time when this task graph was originally created. ")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public TaskGraph nodes(List<TaskGraphNode> nodes) {
        this.nodes = nodes;
        return this;
    }

    public TaskGraph addNodesItem(TaskGraphNode nodesItem) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<TaskGraphNode>();
        }
        this.nodes.add(nodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The structure of the graph. This is provided by the client when first setting up the task graph.  This must be topographically sorted; that is, each node must appear after all nodes that it depends upon. ")
    public List<TaskGraphNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<TaskGraphNode> nodes) {
        this.nodes = nodes;
    }

    public TaskGraph parallelism(Long parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Parallelism limits the max total parallel pods that can execute at the same time in a workflow. ")
    public Long getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(Long parallelism) {
        this.parallelism = parallelism;
    }

    public TaskGraph retryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public void setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public TaskGraph deadline(Long deadline) {
        this.deadline = deadline;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Duration in seconds relative to the workflow start time which the workflow is allowed to run before it gets terminated. ")
    public Long getDeadline() {
        return this.deadline;
    }

    public void setDeadline(Long deadline) {
        this.deadline = deadline;
    }

    public TaskGraph taskGraphType(TaskGraphType taskGraphType) {
        this.taskGraphType = taskGraphType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TaskGraphType getTaskGraphType() {
        return this.taskGraphType;
    }

    public void setTaskGraphType(TaskGraphType taskGraphType) {
        this.taskGraphType = taskGraphType;
    }

    public TaskGraph putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskGraph taskGraph = (TaskGraph)o;
        return Objects.equals(this.uuid, taskGraph.uuid) && Objects.equals(this.namespace, taskGraph.namespace) && Objects.equals(this.createdBy, taskGraph.createdBy) && Objects.equals(this.name, taskGraph.name) && Objects.equals(this.createdAt, taskGraph.createdAt) && Objects.equals(this.nodes, taskGraph.nodes) && Objects.equals(this.parallelism, taskGraph.parallelism) && Objects.equals(this.retryStrategy, taskGraph.retryStrategy) && Objects.equals(this.deadline, taskGraph.deadline) && Objects.equals((Object)this.taskGraphType, (Object)taskGraph.taskGraphType) && Objects.equals(this.additionalProperties, taskGraph.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uuid, this.namespace, this.createdBy, this.name, this.createdAt, this.nodes, this.parallelism, this.retryStrategy, this.deadline, this.taskGraphType, this.additionalProperties});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskGraph {\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    nodes: ").append(this.toIndentedString(this.nodes)).append("\n");
        sb.append("    parallelism: ").append(this.toIndentedString(this.parallelism)).append("\n");
        sb.append("    retryStrategy: ").append(this.toIndentedString(this.retryStrategy)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    taskGraphType: ").append(this.toIndentedString((Object)this.taskGraphType)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TaskGraph is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UUID) != null && !jsonObj.get(SERIALIZED_NAME_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREATED_BY) != null && !jsonObj.get(SERIALIZED_NAME_CREATED_BY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREATED_BY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `created_by` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREATED_BY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        JsonArray jsonArraynodes = jsonObj.getAsJsonArray(SERIALIZED_NAME_NODES);
        if (jsonArraynodes != null) {
            if (!jsonObj.get(SERIALIZED_NAME_NODES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `nodes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NODES).toString()));
            }
            for (int i = 0; i < jsonArraynodes.size(); ++i) {
                TaskGraphNode.validateJsonObject(jsonArraynodes.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_RETRY_STRATEGY) != null && !jsonObj.get(SERIALIZED_NAME_RETRY_STRATEGY).isJsonNull()) {
            RetryStrategy.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RETRY_STRATEGY));
        }
    }

    public static TaskGraph fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, TaskGraph.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_UUID);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_CREATED_BY);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_NODES);
        openapiFields.add(SERIALIZED_NAME_PARALLELISM);
        openapiFields.add(SERIALIZED_NAME_RETRY_STRATEGY);
        openapiFields.add(SERIALIZED_NAME_DEADLINE);
        openapiFields.add(SERIALIZED_NAME_TASK_GRAPH_TYPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TaskGraph.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<TaskGraph> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(TaskGraph.class));
            return new TypeAdapter<TaskGraph>(){

                @Override
                public void write(JsonWriter out, TaskGraph value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public TaskGraph read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TaskGraph.validateJsonObject(jsonObj);
                    TaskGraph instance = (TaskGraph)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

