/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.TaskGraphLogStatus;
import io.tiledb.cloud.rest_api.model.TaskGraphNodeMetadata;
import io.tiledb.cloud.rest_api.model.TaskGraphType;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Logging information about the execution of a task graph.")
public class TaskGraphLog {
    public static final String SERIALIZED_NAME_UUID = "uuid";
    @SerializedName(value="uuid")
    private String uuid;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    private String namespace;
    public static final String SERIALIZED_NAME_CREATED_BY = "created_by";
    @SerializedName(value="created_by")
    private String createdBy;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_START_TIME = "start_time";
    @SerializedName(value="start_time")
    private OffsetDateTime startTime;
    public static final String SERIALIZED_NAME_END_TIME = "end_time";
    @SerializedName(value="end_time")
    private OffsetDateTime endTime;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private TaskGraphLogStatus status;
    public static final String SERIALIZED_NAME_TOTAL_COST = "total_cost";
    @SerializedName(value="total_cost")
    private BigDecimal totalCost;
    public static final String SERIALIZED_NAME_ACCESS_COST = "access_cost";
    @SerializedName(value="access_cost")
    private BigDecimal accessCost;
    public static final String SERIALIZED_NAME_EGRESS_COST = "egress_cost";
    @SerializedName(value="egress_cost")
    private BigDecimal egressCost;
    public static final String SERIALIZED_NAME_EXECUTION_TIME = "execution_time";
    @SerializedName(value="execution_time")
    private String executionTime;
    public static final String SERIALIZED_NAME_STATUS_COUNT = "status_count";
    @SerializedName(value="status_count")
    private Map<String, BigDecimal> statusCount = null;
    public static final String SERIALIZED_NAME_NODES = "nodes";
    @SerializedName(value="nodes")
    private List<TaskGraphNodeMetadata> nodes = null;
    public static final String SERIALIZED_NAME_TASK_GRAPH_TYPE = "task_graph_type";
    @SerializedName(value="task_graph_type")
    private TaskGraphType taskGraphType;
    public static final String SERIALIZED_NAME_TASK_GRAPH_ID = "task_graph_id";
    @SerializedName(value="task_graph_id")
    private String taskGraphId;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TaskGraphLog() {
    }

    public TaskGraphLog(String uuid, String createdBy, OffsetDateTime createdAt, OffsetDateTime startTime, OffsetDateTime endTime) {
        this();
        this.uuid = uuid;
        this.createdBy = createdBy;
        this.createdAt = createdAt;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Nullable
    @ApiModelProperty(value="The server-generated UUID of the task graph.")
    public String getUuid() {
        return this.uuid;
    }

    public TaskGraphLog namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The namespace that owns this task graph log. When creating a task graph log, this is used as the namespace to create the log in; thereafter it is read-only. ")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Nullable
    @ApiModelProperty(value="The name of the user who created this task graph log.")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public TaskGraphLog name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A name for this task graph log, displayed in the UI. Does not need to be unique. ")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    @ApiModelProperty(value="The date/time when this task graph log was originally created. This is distinct from the execution start_time. ")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @ApiModelProperty(value="The start time of the task graph, recorded when the server starts executing the first node. ")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    @Nullable
    @ApiModelProperty(value="The end time of the task graph, recorded when the client reports completion. ")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public TaskGraphLog status(TaskGraphLogStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TaskGraphLogStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskGraphLogStatus status) {
        this.status = status;
    }

    public TaskGraphLog totalCost(BigDecimal totalCost) {
        this.totalCost = totalCost;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If present, the total cost of executing all nodes in this task graph. ")
    public BigDecimal getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(BigDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public TaskGraphLog accessCost(BigDecimal accessCost) {
        this.accessCost = accessCost;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If present, the total cost of access from execution of the nodes in this task graph. ")
    public BigDecimal getAccessCost() {
        return this.accessCost;
    }

    public void setAccessCost(BigDecimal accessCost) {
        this.accessCost = accessCost;
    }

    public TaskGraphLog egressCost(BigDecimal egressCost) {
        this.egressCost = egressCost;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If present, the total cost of access from execution of the nodes in this task graph. ")
    public BigDecimal getEgressCost() {
        return this.egressCost;
    }

    public void setEgressCost(BigDecimal egressCost) {
        this.egressCost = egressCost;
    }

    public TaskGraphLog executionTime(String executionTime) {
        this.executionTime = executionTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="P15H22M0.45S", value="The total execution time of all the nodes in this graph, in ISO 8601 format with hours, minutes, and seconds. ")
    public String getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(String executionTime) {
        this.executionTime = executionTime;
    }

    public TaskGraphLog statusCount(Map<String, BigDecimal> statusCount) {
        this.statusCount = statusCount;
        return this;
    }

    public TaskGraphLog putStatusCountItem(String key, BigDecimal statusCountItem) {
        if (this.statusCount == null) {
            this.statusCount = new HashMap<String, BigDecimal>();
        }
        this.statusCount.put(key, statusCountItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A mapping from `ArrayTaskStatus` string value to the number of nodes in this graph that are in that status. ")
    public Map<String, BigDecimal> getStatusCount() {
        return this.statusCount;
    }

    public void setStatusCount(Map<String, BigDecimal> statusCount) {
        this.statusCount = statusCount;
    }

    public TaskGraphLog nodes(List<TaskGraphNodeMetadata> nodes) {
        this.nodes = nodes;
        return this;
    }

    public TaskGraphLog addNodesItem(TaskGraphNodeMetadata nodesItem) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<TaskGraphNodeMetadata>();
        }
        this.nodes.add(nodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The structure of the graph. This is provided by the client when first setting up the task graph. Thereafter, it is read-only. This must be topographically sorted; that is, each node must appear after all nodes that it depends upon. ")
    public List<TaskGraphNodeMetadata> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<TaskGraphNodeMetadata> nodes) {
        this.nodes = nodes;
    }

    public TaskGraphLog taskGraphType(TaskGraphType taskGraphType) {
        this.taskGraphType = taskGraphType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TaskGraphType getTaskGraphType() {
        return this.taskGraphType;
    }

    public void setTaskGraphType(TaskGraphType taskGraphType) {
        this.taskGraphType = taskGraphType;
    }

    public TaskGraphLog taskGraphId(String taskGraphId) {
        this.taskGraphId = taskGraphId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The UUID of the task graph.")
    public String getTaskGraphId() {
        return this.taskGraphId;
    }

    public void setTaskGraphId(String taskGraphId) {
        this.taskGraphId = taskGraphId;
    }

    public TaskGraphLog putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskGraphLog taskGraphLog = (TaskGraphLog)o;
        return Objects.equals(this.uuid, taskGraphLog.uuid) && Objects.equals(this.namespace, taskGraphLog.namespace) && Objects.equals(this.createdBy, taskGraphLog.createdBy) && Objects.equals(this.name, taskGraphLog.name) && Objects.equals(this.createdAt, taskGraphLog.createdAt) && Objects.equals(this.startTime, taskGraphLog.startTime) && Objects.equals(this.endTime, taskGraphLog.endTime) && Objects.equals((Object)this.status, (Object)taskGraphLog.status) && Objects.equals(this.totalCost, taskGraphLog.totalCost) && Objects.equals(this.accessCost, taskGraphLog.accessCost) && Objects.equals(this.egressCost, taskGraphLog.egressCost) && Objects.equals(this.executionTime, taskGraphLog.executionTime) && Objects.equals(this.statusCount, taskGraphLog.statusCount) && Objects.equals(this.nodes, taskGraphLog.nodes) && Objects.equals((Object)this.taskGraphType, (Object)taskGraphLog.taskGraphType) && Objects.equals(this.taskGraphId, taskGraphLog.taskGraphId) && Objects.equals(this.additionalProperties, taskGraphLog.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uuid, this.namespace, this.createdBy, this.name, this.createdAt, this.startTime, this.endTime, this.status, this.totalCost, this.accessCost, this.egressCost, this.executionTime, this.statusCount, this.nodes, this.taskGraphType, this.taskGraphId, this.additionalProperties});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskGraphLog {\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    totalCost: ").append(this.toIndentedString(this.totalCost)).append("\n");
        sb.append("    accessCost: ").append(this.toIndentedString(this.accessCost)).append("\n");
        sb.append("    egressCost: ").append(this.toIndentedString(this.egressCost)).append("\n");
        sb.append("    executionTime: ").append(this.toIndentedString(this.executionTime)).append("\n");
        sb.append("    statusCount: ").append(this.toIndentedString(this.statusCount)).append("\n");
        sb.append("    nodes: ").append(this.toIndentedString(this.nodes)).append("\n");
        sb.append("    taskGraphType: ").append(this.toIndentedString((Object)this.taskGraphType)).append("\n");
        sb.append("    taskGraphId: ").append(this.toIndentedString(this.taskGraphId)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TaskGraphLog is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UUID) != null && !jsonObj.get(SERIALIZED_NAME_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREATED_BY) != null && !jsonObj.get(SERIALIZED_NAME_CREATED_BY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREATED_BY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `created_by` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREATED_BY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXECUTION_TIME) != null && !jsonObj.get(SERIALIZED_NAME_EXECUTION_TIME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXECUTION_TIME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `execution_time` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXECUTION_TIME).toString()));
        }
        JsonArray jsonArraynodes = jsonObj.getAsJsonArray(SERIALIZED_NAME_NODES);
        if (jsonArraynodes != null) {
            if (!jsonObj.get(SERIALIZED_NAME_NODES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `nodes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NODES).toString()));
            }
            for (int i = 0; i < jsonArraynodes.size(); ++i) {
                TaskGraphNodeMetadata.validateJsonObject(jsonArraynodes.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_ID) != null && !jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `task_graph_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_ID).toString()));
        }
    }

    public static TaskGraphLog fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, TaskGraphLog.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_UUID);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_CREATED_BY);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_START_TIME);
        openapiFields.add(SERIALIZED_NAME_END_TIME);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TOTAL_COST);
        openapiFields.add(SERIALIZED_NAME_ACCESS_COST);
        openapiFields.add(SERIALIZED_NAME_EGRESS_COST);
        openapiFields.add(SERIALIZED_NAME_EXECUTION_TIME);
        openapiFields.add(SERIALIZED_NAME_STATUS_COUNT);
        openapiFields.add(SERIALIZED_NAME_NODES);
        openapiFields.add(SERIALIZED_NAME_TASK_GRAPH_TYPE);
        openapiFields.add(SERIALIZED_NAME_TASK_GRAPH_ID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TaskGraphLog.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<TaskGraphLog> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(TaskGraphLog.class));
            return new TypeAdapter<TaskGraphLog>(){

                @Override
                public void write(JsonWriter out, TaskGraphLog value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public TaskGraphLog read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TaskGraphLog.validateJsonObject(jsonObj);
                    TaskGraphLog instance = (TaskGraphLog)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

