/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.PaginationMetadata;
import io.tiledb.cloud.rest_api.model.TaskGraphLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response data for a task graph list, including pagination metadata.")
public class TaskGraphLogsData {
    public static final String SERIALIZED_NAME_TASK_GRAPH_LOGS = "task_graph_logs";
    @SerializedName(value="task_graph_logs")
    private List<TaskGraphLog> taskGraphLogs = null;
    public static final String SERIALIZED_NAME_PAGINATION_METADATA = "pagination_metadata";
    @SerializedName(value="pagination_metadata")
    private PaginationMetadata paginationMetadata;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TaskGraphLogsData taskGraphLogs(List<TaskGraphLog> taskGraphLogs) {
        this.taskGraphLogs = taskGraphLogs;
        return this;
    }

    public TaskGraphLogsData addTaskGraphLogsItem(TaskGraphLog taskGraphLogsItem) {
        if (this.taskGraphLogs == null) {
            this.taskGraphLogs = new ArrayList<TaskGraphLog>();
        }
        this.taskGraphLogs.add(taskGraphLogsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The requested task graph logs.")
    public List<TaskGraphLog> getTaskGraphLogs() {
        return this.taskGraphLogs;
    }

    public void setTaskGraphLogs(List<TaskGraphLog> taskGraphLogs) {
        this.taskGraphLogs = taskGraphLogs;
    }

    public TaskGraphLogsData paginationMetadata(PaginationMetadata paginationMetadata) {
        this.paginationMetadata = paginationMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaginationMetadata getPaginationMetadata() {
        return this.paginationMetadata;
    }

    public void setPaginationMetadata(PaginationMetadata paginationMetadata) {
        this.paginationMetadata = paginationMetadata;
    }

    public TaskGraphLogsData putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskGraphLogsData taskGraphLogsData = (TaskGraphLogsData)o;
        return Objects.equals(this.taskGraphLogs, taskGraphLogsData.taskGraphLogs) && Objects.equals(this.paginationMetadata, taskGraphLogsData.paginationMetadata) && Objects.equals(this.additionalProperties, taskGraphLogsData.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.taskGraphLogs, this.paginationMetadata, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskGraphLogsData {\n");
        sb.append("    taskGraphLogs: ").append(this.toIndentedString(this.taskGraphLogs)).append("\n");
        sb.append("    paginationMetadata: ").append(this.toIndentedString(this.paginationMetadata)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TaskGraphLogsData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonArray jsonArraytaskGraphLogs = jsonObj.getAsJsonArray(SERIALIZED_NAME_TASK_GRAPH_LOGS);
        if (jsonArraytaskGraphLogs != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_LOGS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `task_graph_logs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TASK_GRAPH_LOGS).toString()));
            }
            for (int i = 0; i < jsonArraytaskGraphLogs.size(); ++i) {
                TaskGraphLog.validateJsonObject(jsonArraytaskGraphLogs.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PAGINATION_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_PAGINATION_METADATA).isJsonNull()) {
            PaginationMetadata.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PAGINATION_METADATA));
        }
    }

    public static TaskGraphLogsData fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, TaskGraphLogsData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TASK_GRAPH_LOGS);
        openapiFields.add(SERIALIZED_NAME_PAGINATION_METADATA);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TaskGraphLogsData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<TaskGraphLogsData> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(TaskGraphLogsData.class));
            return new TypeAdapter<TaskGraphLogsData>(){

                @Override
                public void write(JsonWriter out, TaskGraphLogsData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public TaskGraphLogsData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TaskGraphLogsData.validateJsonObject(jsonObj);
                    TaskGraphLogsData instance = (TaskGraphLogsData)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

