/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.RetryStrategy;
import io.tiledb.cloud.rest_api.model.TGInputNodeData;
import io.tiledb.cloud.rest_api.model.TGSQLNodeData;
import io.tiledb.cloud.rest_api.model.TGUDFNodeData;
import io.tiledb.cloud.rest_api.model.UDFArrayDetails;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Information about a single node within a registered task graph. A single node represents one piece of data or a computational step; either as an input value, a data source, or a computation that acts upon earlier nodes. The structure parallels the existing `TaskGraphNodeMetadata`. ")
public class TaskGraphNode {
    public static final String SERIALIZED_NAME_CLIENT_NODE_ID = "client_node_id";
    @SerializedName(value="client_node_id")
    private String clientNodeId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DEPENDS_ON = "depends_on";
    @SerializedName(value="depends_on")
    private List<String> dependsOn = null;
    public static final String SERIALIZED_NAME_ARRAY_NODE = "array_node";
    @SerializedName(value="array_node")
    private UDFArrayDetails arrayNode;
    public static final String SERIALIZED_NAME_INPUT_NODE = "input_node";
    @SerializedName(value="input_node")
    private TGInputNodeData inputNode;
    public static final String SERIALIZED_NAME_SQL_NODE = "sql_node";
    @SerializedName(value="sql_node")
    private TGSQLNodeData sqlNode;
    public static final String SERIALIZED_NAME_UDF_NODE = "udf_node";
    @SerializedName(value="udf_node")
    private TGUDFNodeData udfNode;
    public static final String SERIALIZED_NAME_RETRY_STRATEGY = "retry_strategy";
    @SerializedName(value="retry_strategy")
    private RetryStrategy retryStrategy;
    public static final String SERIALIZED_NAME_EXPAND_NODE_OUTPUT = "expand_node_output";
    @SerializedName(value="expand_node_output")
    private String expandNodeOutput;
    public static final String SERIALIZED_NAME_DEADLINE = "deadline";
    @SerializedName(value="deadline")
    private Long deadline;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TaskGraphNode clientNodeId(String clientNodeId) {
        this.clientNodeId = clientNodeId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The client-generated UUID of the given graph node.")
    public String getClientNodeId() {
        return this.clientNodeId;
    }

    public void setClientNodeId(String clientNodeId) {
        this.clientNodeId = clientNodeId;
    }

    public TaskGraphNode name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A client-specified name for the node. If provided, this must be unique. ")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TaskGraphNode dependsOn(List<String> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    public TaskGraphNode addDependsOnItem(String dependsOnItem) {
        if (this.dependsOn == null) {
            this.dependsOn = new ArrayList<String>();
        }
        this.dependsOn.add(dependsOnItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The client_node_uuid of each node that this node depends upon. Used to define the structure of the graph. ")
    public List<String> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(List<String> dependsOn) {
        this.dependsOn = dependsOn;
    }

    public TaskGraphNode arrayNode(UDFArrayDetails arrayNode) {
        this.arrayNode = arrayNode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UDFArrayDetails getArrayNode() {
        return this.arrayNode;
    }

    public void setArrayNode(UDFArrayDetails arrayNode) {
        this.arrayNode = arrayNode;
    }

    public TaskGraphNode inputNode(TGInputNodeData inputNode) {
        this.inputNode = inputNode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TGInputNodeData getInputNode() {
        return this.inputNode;
    }

    public void setInputNode(TGInputNodeData inputNode) {
        this.inputNode = inputNode;
    }

    public TaskGraphNode sqlNode(TGSQLNodeData sqlNode) {
        this.sqlNode = sqlNode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TGSQLNodeData getSqlNode() {
        return this.sqlNode;
    }

    public void setSqlNode(TGSQLNodeData sqlNode) {
        this.sqlNode = sqlNode;
    }

    public TaskGraphNode udfNode(TGUDFNodeData udfNode) {
        this.udfNode = udfNode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TGUDFNodeData getUdfNode() {
        return this.udfNode;
    }

    public void setUdfNode(TGUDFNodeData udfNode) {
        this.udfNode = udfNode;
    }

    public TaskGraphNode retryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public void setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public TaskGraphNode expandNodeOutput(String expandNodeOutput) {
        this.expandNodeOutput = expandNodeOutput;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used to create dynamic tasks based on the output of another node. The other node's output must be a JSON list of values. The expansion process creates one task per item in the output list. The item is also passed as an argument to each task. The value is the client_node_uuid of the node that we want to expand. ")
    public String getExpandNodeOutput() {
        return this.expandNodeOutput;
    }

    public void setExpandNodeOutput(String expandNodeOutput) {
        this.expandNodeOutput = expandNodeOutput;
    }

    public TaskGraphNode deadline(Long deadline) {
        this.deadline = deadline;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Duration in seconds relative to the node start time which the node is allowed to run before it gets terminated. ")
    public Long getDeadline() {
        return this.deadline;
    }

    public void setDeadline(Long deadline) {
        this.deadline = deadline;
    }

    public TaskGraphNode putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskGraphNode taskGraphNode = (TaskGraphNode)o;
        return Objects.equals(this.clientNodeId, taskGraphNode.clientNodeId) && Objects.equals(this.name, taskGraphNode.name) && Objects.equals(this.dependsOn, taskGraphNode.dependsOn) && Objects.equals(this.arrayNode, taskGraphNode.arrayNode) && Objects.equals(this.inputNode, taskGraphNode.inputNode) && Objects.equals(this.sqlNode, taskGraphNode.sqlNode) && Objects.equals(this.udfNode, taskGraphNode.udfNode) && Objects.equals(this.retryStrategy, taskGraphNode.retryStrategy) && Objects.equals(this.expandNodeOutput, taskGraphNode.expandNodeOutput) && Objects.equals(this.deadline, taskGraphNode.deadline) && Objects.equals(this.additionalProperties, taskGraphNode.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.clientNodeId, this.name, this.dependsOn, this.arrayNode, this.inputNode, this.sqlNode, this.udfNode, this.retryStrategy, this.expandNodeOutput, this.deadline, this.additionalProperties);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskGraphNode {\n");
        sb.append("    clientNodeId: ").append(this.toIndentedString(this.clientNodeId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dependsOn: ").append(this.toIndentedString(this.dependsOn)).append("\n");
        sb.append("    arrayNode: ").append(this.toIndentedString(this.arrayNode)).append("\n");
        sb.append("    inputNode: ").append(this.toIndentedString(this.inputNode)).append("\n");
        sb.append("    sqlNode: ").append(this.toIndentedString(this.sqlNode)).append("\n");
        sb.append("    udfNode: ").append(this.toIndentedString(this.udfNode)).append("\n");
        sb.append("    retryStrategy: ").append(this.toIndentedString(this.retryStrategy)).append("\n");
        sb.append("    expandNodeOutput: ").append(this.toIndentedString(this.expandNodeOutput)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TaskGraphNode is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_ID) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `client_node_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEPENDS_ON) != null && !jsonObj.get(SERIALIZED_NAME_DEPENDS_ON).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEPENDS_ON).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `depends_on` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEPENDS_ON).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARRAY_NODE) != null && !jsonObj.get(SERIALIZED_NAME_ARRAY_NODE).isJsonNull()) {
            UDFArrayDetails.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ARRAY_NODE));
        }
        if (jsonObj.get(SERIALIZED_NAME_INPUT_NODE) != null && !jsonObj.get(SERIALIZED_NAME_INPUT_NODE).isJsonNull()) {
            TGInputNodeData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INPUT_NODE));
        }
        if (jsonObj.get(SERIALIZED_NAME_SQL_NODE) != null && !jsonObj.get(SERIALIZED_NAME_SQL_NODE).isJsonNull()) {
            TGSQLNodeData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SQL_NODE));
        }
        if (jsonObj.get(SERIALIZED_NAME_UDF_NODE) != null && !jsonObj.get(SERIALIZED_NAME_UDF_NODE).isJsonNull()) {
            TGUDFNodeData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_UDF_NODE));
        }
        if (jsonObj.get(SERIALIZED_NAME_RETRY_STRATEGY) != null && !jsonObj.get(SERIALIZED_NAME_RETRY_STRATEGY).isJsonNull()) {
            RetryStrategy.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RETRY_STRATEGY));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPAND_NODE_OUTPUT) != null && !jsonObj.get(SERIALIZED_NAME_EXPAND_NODE_OUTPUT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXPAND_NODE_OUTPUT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `expand_node_output` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPAND_NODE_OUTPUT).toString()));
        }
    }

    public static TaskGraphNode fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, TaskGraphNode.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CLIENT_NODE_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_DEPENDS_ON);
        openapiFields.add(SERIALIZED_NAME_ARRAY_NODE);
        openapiFields.add(SERIALIZED_NAME_INPUT_NODE);
        openapiFields.add(SERIALIZED_NAME_SQL_NODE);
        openapiFields.add(SERIALIZED_NAME_UDF_NODE);
        openapiFields.add(SERIALIZED_NAME_RETRY_STRATEGY);
        openapiFields.add(SERIALIZED_NAME_EXPAND_NODE_OUTPUT);
        openapiFields.add(SERIALIZED_NAME_DEADLINE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TaskGraphNode.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<TaskGraphNode> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(TaskGraphNode.class));
            return new TypeAdapter<TaskGraphNode>(){

                @Override
                public void write(JsonWriter out, TaskGraphNode value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public TaskGraphNode read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TaskGraphNode.validateJsonObject(jsonObj);
                    TaskGraphNode instance = (TaskGraphNode)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

