/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.ArrayTask;
import io.tiledb.cloud.rest_api.model.ArrayTaskStatus;
import io.tiledb.cloud.rest_api.model.TaskGraphLogRunLocation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Metadata about an individual node in a task graph.")
public class TaskGraphNodeMetadata {
    public static final String SERIALIZED_NAME_CLIENT_NODE_UUID = "client_node_uuid";
    @SerializedName(value="client_node_uuid")
    private String clientNodeUuid;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DEPENDS_ON = "depends_on";
    @SerializedName(value="depends_on")
    private List<String> dependsOn = null;
    public static final String SERIALIZED_NAME_RUN_LOCATION = "run_location";
    @SerializedName(value="run_location")
    private TaskGraphLogRunLocation runLocation;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private ArrayTaskStatus status;
    public static final String SERIALIZED_NAME_STATUS_MESSAGE = "status_message";
    @SerializedName(value="status_message")
    private String statusMessage;
    public static final String SERIALIZED_NAME_EXECUTIONS = "executions";
    @SerializedName(value="executions")
    private List<ArrayTask> executions = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TaskGraphNodeMetadata() {
    }

    public TaskGraphNodeMetadata(List<ArrayTask> executions) {
        this();
        this.executions = executions;
    }

    public TaskGraphNodeMetadata clientNodeUuid(String clientNodeUuid) {
        this.clientNodeUuid = clientNodeUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The client-generated UUID of the given graph node.")
    public String getClientNodeUuid() {
        return this.clientNodeUuid;
    }

    public void setClientNodeUuid(String clientNodeUuid) {
        this.clientNodeUuid = clientNodeUuid;
    }

    public TaskGraphNodeMetadata name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The client-generated name of the node. This is not guaranteed to be unique. ")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TaskGraphNodeMetadata dependsOn(List<String> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    public TaskGraphNodeMetadata addDependsOnItem(String dependsOnItem) {
        if (this.dependsOn == null) {
            this.dependsOn = new ArrayList<String>();
        }
        this.dependsOn.add(dependsOnItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The client_node_uuid of each node that this node depends upon. Used to define the structure of the graph. ")
    public List<String> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(List<String> dependsOn) {
        this.dependsOn = dependsOn;
    }

    public TaskGraphNodeMetadata runLocation(TaskGraphLogRunLocation runLocation) {
        this.runLocation = runLocation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TaskGraphLogRunLocation getRunLocation() {
        return this.runLocation;
    }

    public void setRunLocation(TaskGraphLogRunLocation runLocation) {
        this.runLocation = runLocation;
    }

    public TaskGraphNodeMetadata status(ArrayTaskStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ArrayTaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(ArrayTaskStatus status) {
        this.status = status;
    }

    public TaskGraphNodeMetadata statusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason the array task status is in the state")
    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    @Nullable
    @ApiModelProperty(value="ArrayTasks representing each execution attempt for this node. For nodes that have never been submitted, this will be empty. For nodes that have been retried, this may have multiple entries. The last one in the list represents the most recent execution. This is read-only and generated by the server based on the tasks it has actually executed. ")
    public List<ArrayTask> getExecutions() {
        return this.executions;
    }

    public TaskGraphNodeMetadata putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskGraphNodeMetadata taskGraphNodeMetadata = (TaskGraphNodeMetadata)o;
        return Objects.equals(this.clientNodeUuid, taskGraphNodeMetadata.clientNodeUuid) && Objects.equals(this.name, taskGraphNodeMetadata.name) && Objects.equals(this.dependsOn, taskGraphNodeMetadata.dependsOn) && Objects.equals((Object)this.runLocation, (Object)taskGraphNodeMetadata.runLocation) && Objects.equals((Object)this.status, (Object)taskGraphNodeMetadata.status) && Objects.equals(this.statusMessage, taskGraphNodeMetadata.statusMessage) && Objects.equals(this.executions, taskGraphNodeMetadata.executions) && Objects.equals(this.additionalProperties, taskGraphNodeMetadata.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientNodeUuid, this.name, this.dependsOn, this.runLocation, this.status, this.statusMessage, this.executions, this.additionalProperties});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskGraphNodeMetadata {\n");
        sb.append("    clientNodeUuid: ").append(this.toIndentedString(this.clientNodeUuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dependsOn: ").append(this.toIndentedString(this.dependsOn)).append("\n");
        sb.append("    runLocation: ").append(this.toIndentedString((Object)this.runLocation)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusMessage: ").append(this.toIndentedString(this.statusMessage)).append("\n");
        sb.append("    executions: ").append(this.toIndentedString(this.executions)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TaskGraphNodeMetadata is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `client_node_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_NODE_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEPENDS_ON) != null && !jsonObj.get(SERIALIZED_NAME_DEPENDS_ON).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEPENDS_ON).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `depends_on` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEPENDS_ON).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS_MESSAGE) != null && !jsonObj.get(SERIALIZED_NAME_STATUS_MESSAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATUS_MESSAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status_message` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS_MESSAGE).toString()));
        }
        JsonArray jsonArrayexecutions = jsonObj.getAsJsonArray(SERIALIZED_NAME_EXECUTIONS);
        if (jsonArrayexecutions != null) {
            if (!jsonObj.get(SERIALIZED_NAME_EXECUTIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `executions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXECUTIONS).toString()));
            }
            for (int i = 0; i < jsonArrayexecutions.size(); ++i) {
                ArrayTask.validateJsonObject(jsonArrayexecutions.get(i).getAsJsonObject());
            }
        }
    }

    public static TaskGraphNodeMetadata fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, TaskGraphNodeMetadata.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CLIENT_NODE_UUID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_DEPENDS_ON);
        openapiFields.add(SERIALIZED_NAME_RUN_LOCATION);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_STATUS_MESSAGE);
        openapiFields.add(SERIALIZED_NAME_EXECUTIONS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TaskGraphNodeMetadata.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<TaskGraphNodeMetadata> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(TaskGraphNodeMetadata.class));
            return new TypeAdapter<TaskGraphNodeMetadata>(){

                @Override
                public void write(JsonWriter out, TaskGraphNodeMetadata value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public TaskGraphNodeMetadata read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TaskGraphNodeMetadata.validateJsonObject(jsonObj);
                    TaskGraphNodeMetadata instance = (TaskGraphNodeMetadata)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

