/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.QueryRanges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Contains array details for multi-array query including uri, ranges buffers")
public class UDFArrayDetails {
    public static final String SERIALIZED_NAME_PARAMETER_ID = "parameter_id";
    @SerializedName(value="parameter_id")
    private String parameterId;
    public static final String SERIALIZED_NAME_URI = "uri";
    @SerializedName(value="uri")
    private String uri;
    public static final String SERIALIZED_NAME_RANGES = "ranges";
    @SerializedName(value="ranges")
    private QueryRanges ranges;
    public static final String SERIALIZED_NAME_BUFFERS = "buffers";
    @SerializedName(value="buffers")
    private List<String> buffers = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UDFArrayDetails parameterId(String parameterId) {
        this.parameterId = parameterId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional client-generated identifier to distinguish between multiple range/buffer requests from the same array in the same call. This may be set for MultiArrayUDFs that use the `argument_json` style of passing arrays. ")
    public String getParameterId() {
        return this.parameterId;
    }

    public void setParameterId(String parameterId) {
        this.parameterId = parameterId;
    }

    public UDFArrayDetails uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="array to set ranges and buffers on, must be in tiledb:// format")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public UDFArrayDetails ranges(QueryRanges ranges) {
        this.ranges = ranges;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public QueryRanges getRanges() {
        return this.ranges;
    }

    public void setRanges(QueryRanges ranges) {
        this.ranges = ranges;
    }

    public UDFArrayDetails buffers(List<String> buffers) {
        this.buffers = buffers;
        return this;
    }

    public UDFArrayDetails addBuffersItem(String buffersItem) {
        if (this.buffers == null) {
            this.buffers = new ArrayList<String>();
        }
        this.buffers.add(buffersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of buffers to fetch (attributes + dimensions)")
    public List<String> getBuffers() {
        return this.buffers;
    }

    public void setBuffers(List<String> buffers) {
        this.buffers = buffers;
    }

    public UDFArrayDetails putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UDFArrayDetails udFArrayDetails = (UDFArrayDetails)o;
        return Objects.equals(this.parameterId, udFArrayDetails.parameterId) && Objects.equals(this.uri, udFArrayDetails.uri) && Objects.equals(this.ranges, udFArrayDetails.ranges) && Objects.equals(this.buffers, udFArrayDetails.buffers) && Objects.equals(this.additionalProperties, udFArrayDetails.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.parameterId, this.uri, this.ranges, this.buffers, this.additionalProperties);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UDFArrayDetails {\n");
        sb.append("    parameterId: ").append(this.toIndentedString(this.parameterId)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    ranges: ").append(this.toIndentedString(this.ranges)).append("\n");
        sb.append("    buffers: ").append(this.toIndentedString(this.buffers)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UDFArrayDetails is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PARAMETER_ID) != null && !jsonObj.get(SERIALIZED_NAME_PARAMETER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PARAMETER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `parameter_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PARAMETER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URI) != null && !jsonObj.get(SERIALIZED_NAME_URI).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URI).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RANGES) != null && !jsonObj.get(SERIALIZED_NAME_RANGES).isJsonNull()) {
            QueryRanges.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RANGES));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUFFERS) != null && !jsonObj.get(SERIALIZED_NAME_BUFFERS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BUFFERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `buffers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUFFERS).toString()));
        }
    }

    public static UDFArrayDetails fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, UDFArrayDetails.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PARAMETER_ID);
        openapiFields.add(SERIALIZED_NAME_URI);
        openapiFields.add(SERIALIZED_NAME_RANGES);
        openapiFields.add(SERIALIZED_NAME_BUFFERS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!UDFArrayDetails.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<UDFArrayDetails> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(UDFArrayDetails.class));
            return new TypeAdapter<UDFArrayDetails>(){

                @Override
                public void write(JsonWriter out, UDFArrayDetails value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public UDFArrayDetails read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UDFArrayDetails.validateJsonObject(jsonObj);
                    UDFArrayDetails instance = (UDFArrayDetails)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

