/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines an image that belongs to a set of images having a version")
public class UDFImageVersion {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_UDF_IMAGE_UUID = "udf_image_uuid";
    @SerializedName(value="udf_image_uuid")
    private String udfImageUuid;
    public static final String SERIALIZED_NAME_DOCKER_IMAGE = "docker_image";
    @SerializedName(value="docker_image")
    private String dockerImage;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private BigDecimal version;
    public static final String SERIALIZED_NAME_DEFAULT = "default";
    @SerializedName(value="default")
    private Boolean _default;
    public static final String SERIALIZED_NAME_LATEST = "latest";
    @SerializedName(value="latest")
    private Boolean latest;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UDFImageVersion id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Unique ID of a versioned image")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UDFImageVersion name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="name of UDFImageVersion")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UDFImageVersion udfImageUuid(String udfImageUuid) {
        this.udfImageUuid = udfImageUuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Unique ID of the UDF image set")
    public String getUdfImageUuid() {
        return this.udfImageUuid;
    }

    public void setUdfImageUuid(String udfImageUuid) {
        this.udfImageUuid = udfImageUuid;
    }

    public UDFImageVersion dockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Uri of docker image related to current entry")
    public String getDockerImage() {
        return this.dockerImage;
    }

    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    public UDFImageVersion version(BigDecimal version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2.0", value="Image-specific version")
    public BigDecimal getVersion() {
        return this.version;
    }

    public void setVersion(BigDecimal version) {
        this.version = version;
    }

    public UDFImageVersion _default(Boolean _default) {
        this._default = _default;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="If current image is default version")
    public Boolean getDefault() {
        return this._default;
    }

    public void setDefault(Boolean _default) {
        this._default = _default;
    }

    public UDFImageVersion latest(Boolean latest) {
        this.latest = latest;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="If current image is latest version")
    public Boolean getLatest() {
        return this.latest;
    }

    public void setLatest(Boolean latest) {
        this.latest = latest;
    }

    public UDFImageVersion putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UDFImageVersion udFImageVersion = (UDFImageVersion)o;
        return Objects.equals(this.id, udFImageVersion.id) && Objects.equals(this.name, udFImageVersion.name) && Objects.equals(this.udfImageUuid, udFImageVersion.udfImageUuid) && Objects.equals(this.dockerImage, udFImageVersion.dockerImage) && Objects.equals(this.version, udFImageVersion.version) && Objects.equals(this._default, udFImageVersion._default) && Objects.equals(this.latest, udFImageVersion.latest) && Objects.equals(this.additionalProperties, udFImageVersion.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.udfImageUuid, this.dockerImage, this.version, this._default, this.latest, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UDFImageVersion {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    udfImageUuid: ").append(this.toIndentedString(this.udfImageUuid)).append("\n");
        sb.append("    dockerImage: ").append(this.toIndentedString(this.dockerImage)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    latest: ").append(this.toIndentedString(this.latest)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UDFImageVersion is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UDF_IMAGE_UUID) != null && !jsonObj.get(SERIALIZED_NAME_UDF_IMAGE_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UDF_IMAGE_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `udf_image_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UDF_IMAGE_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOCKER_IMAGE) != null && !jsonObj.get(SERIALIZED_NAME_DOCKER_IMAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DOCKER_IMAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `docker_image` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCKER_IMAGE).toString()));
        }
    }

    public static UDFImageVersion fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, UDFImageVersion.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_UDF_IMAGE_UUID);
        openapiFields.add(SERIALIZED_NAME_DOCKER_IMAGE);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_DEFAULT);
        openapiFields.add(SERIALIZED_NAME_LATEST);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!UDFImageVersion.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<UDFImageVersion> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(UDFImageVersion.class));
            return new TypeAdapter<UDFImageVersion>(){

                @Override
                public void write(JsonWriter out, UDFImageVersion value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public UDFImageVersion read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UDFImageVersion.validateJsonObject(jsonObj);
                    UDFImageVersion instance = (UDFImageVersion)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

