/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.UDFLanguage;
import io.tiledb.cloud.rest_api.model.UDFType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="User-defined function that can persist in db, used and shared multiple times")
public class UDFInfo {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    private UDFLanguage language;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private UDFType type;
    public static final String SERIALIZED_NAME_README = "readme";
    @SerializedName(value="readme")
    private String readme;
    public static final String SERIALIZED_NAME_LICENSE_ID = "license_id";
    @SerializedName(value="license_id")
    private String licenseId;
    public static final String SERIALIZED_NAME_LICENSE_TEXT = "license_text";
    @SerializedName(value="license_text")
    private String licenseText;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UDFInfo id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="Unique ID of UDF")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UDFInfo name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="name of UDF")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UDFInfo language(UDFLanguage language) {
        this.language = language;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UDFLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(UDFLanguage language) {
        this.language = language;
    }

    public UDFInfo type(UDFType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UDFType getType() {
        return this.type;
    }

    public void setType(UDFType type) {
        this.type = type;
    }

    public UDFInfo readme(String readme) {
        this.readme = readme;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Markdown readme of UDFs")
    public String getReadme() {
        return this.readme;
    }

    public void setReadme(String readme) {
        this.readme = readme;
    }

    public UDFInfo licenseId(String licenseId) {
        this.licenseId = licenseId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="License identifier from SPDX License List or Custom")
    public String getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public UDFInfo licenseText(String licenseText) {
        this.licenseText = licenseText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="License text")
    public String getLicenseText() {
        return this.licenseText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public UDFInfo tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public UDFInfo addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="optional tags for UDF")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public UDFInfo putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UDFInfo udFInfo = (UDFInfo)o;
        return Objects.equals(this.id, udFInfo.id) && Objects.equals(this.name, udFInfo.name) && Objects.equals((Object)this.language, (Object)udFInfo.language) && Objects.equals((Object)this.type, (Object)udFInfo.type) && Objects.equals(this.readme, udFInfo.readme) && Objects.equals(this.licenseId, udFInfo.licenseId) && Objects.equals(this.licenseText, udFInfo.licenseText) && Objects.equals(this.tags, udFInfo.tags) && Objects.equals(this.additionalProperties, udFInfo.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.language, this.type, this.readme, this.licenseId, this.licenseText, this.tags, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UDFInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    readme: ").append(this.toIndentedString(this.readme)).append("\n");
        sb.append("    licenseId: ").append(this.toIndentedString(this.licenseId)).append("\n");
        sb.append("    licenseText: ").append(this.toIndentedString(this.licenseText)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UDFInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_README) != null && !jsonObj.get(SERIALIZED_NAME_README).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_README).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `readme` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_README).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LICENSE_ID) != null && !jsonObj.get(SERIALIZED_NAME_LICENSE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LICENSE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `license_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LICENSE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT) != null && !jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `license_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
    }

    public static UDFInfo fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, UDFInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_LANGUAGE);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_README);
        openapiFields.add(SERIALIZED_NAME_LICENSE_ID);
        openapiFields.add(SERIALIZED_NAME_LICENSE_TEXT);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!UDFInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<UDFInfo> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(UDFInfo.class));
            return new TypeAdapter<UDFInfo>(){

                @Override
                public void write(JsonWriter out, UDFInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public UDFInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UDFInfo.validateJsonObject(jsonObj);
                    UDFInfo instance = (UDFInfo)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

