/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.UDFLanguage;
import io.tiledb.cloud.rest_api.model.UDFType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="User-defined function that can persist in db, used and shared multiple times")
public class UDFInfoUpdate {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    private UDFLanguage language;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private String version;
    public static final String SERIALIZED_NAME_IMAGE_NAME = "image_name";
    @SerializedName(value="image_name")
    private String imageName;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private UDFType type;
    public static final String SERIALIZED_NAME_EXEC = "exec";
    @SerializedName(value="exec")
    private String exec;
    public static final String SERIALIZED_NAME_EXEC_RAW = "exec_raw";
    @SerializedName(value="exec_raw")
    private String execRaw;
    public static final String SERIALIZED_NAME_README = "readme";
    @SerializedName(value="readme")
    private String readme;
    public static final String SERIALIZED_NAME_LICENSE_ID = "license_id";
    @SerializedName(value="license_id")
    private String licenseId;
    public static final String SERIALIZED_NAME_LICENSE_TEXT = "license_text";
    @SerializedName(value="license_text")
    private String licenseText;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UDFInfoUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="name of UDF")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UDFInfoUpdate language(UDFLanguage language) {
        this.language = language;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UDFLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(UDFLanguage language) {
        this.language = language;
    }

    public UDFInfoUpdate version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type-specific version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public UDFInfoUpdate imageName(String imageName) {
        this.imageName = imageName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Docker image name to use for UDF")
    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public UDFInfoUpdate type(UDFType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UDFType getType() {
        return this.type;
    }

    public void setType(UDFType type) {
        this.type = type;
    }

    public UDFInfoUpdate exec(String exec) {
        this.exec = exec;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type-specific executable text")
    public String getExec() {
        return this.exec;
    }

    public void setExec(String exec) {
        this.exec = exec;
    }

    public UDFInfoUpdate execRaw(String execRaw) {
        this.execRaw = execRaw;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="optional raw text to store of serialized function, used for showing in UI")
    public String getExecRaw() {
        return this.execRaw;
    }

    public void setExecRaw(String execRaw) {
        this.execRaw = execRaw;
    }

    public UDFInfoUpdate readme(String readme) {
        this.readme = readme;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Markdown readme of UDFs")
    public String getReadme() {
        return this.readme;
    }

    public void setReadme(String readme) {
        this.readme = readme;
    }

    public UDFInfoUpdate licenseId(String licenseId) {
        this.licenseId = licenseId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="License identifier from SPDX License List or Custom")
    public String getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public UDFInfoUpdate licenseText(String licenseText) {
        this.licenseText = licenseText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="License text")
    public String getLicenseText() {
        return this.licenseText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public UDFInfoUpdate tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public UDFInfoUpdate addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="optional tags for UDF")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public UDFInfoUpdate putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UDFInfoUpdate udFInfoUpdate = (UDFInfoUpdate)o;
        return Objects.equals(this.name, udFInfoUpdate.name) && Objects.equals((Object)this.language, (Object)udFInfoUpdate.language) && Objects.equals(this.version, udFInfoUpdate.version) && Objects.equals(this.imageName, udFInfoUpdate.imageName) && Objects.equals((Object)this.type, (Object)udFInfoUpdate.type) && Objects.equals(this.exec, udFInfoUpdate.exec) && Objects.equals(this.execRaw, udFInfoUpdate.execRaw) && Objects.equals(this.readme, udFInfoUpdate.readme) && Objects.equals(this.licenseId, udFInfoUpdate.licenseId) && Objects.equals(this.licenseText, udFInfoUpdate.licenseText) && Objects.equals(this.tags, udFInfoUpdate.tags) && Objects.equals(this.additionalProperties, udFInfoUpdate.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.language, this.version, this.imageName, this.type, this.exec, this.execRaw, this.readme, this.licenseId, this.licenseText, this.tags, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UDFInfoUpdate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    imageName: ").append(this.toIndentedString(this.imageName)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    exec: ").append(this.toIndentedString(this.exec)).append("\n");
        sb.append("    execRaw: ").append(this.toIndentedString(this.execRaw)).append("\n");
        sb.append("    readme: ").append(this.toIndentedString(this.readme)).append("\n");
        sb.append("    licenseId: ").append(this.toIndentedString(this.licenseId)).append("\n");
        sb.append("    licenseText: ").append(this.toIndentedString(this.licenseText)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UDFInfoUpdate is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXEC) != null && !jsonObj.get(SERIALIZED_NAME_EXEC).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXEC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `exec` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXEC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXEC_RAW) != null && !jsonObj.get(SERIALIZED_NAME_EXEC_RAW).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXEC_RAW).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `exec_raw` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXEC_RAW).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_README) != null && !jsonObj.get(SERIALIZED_NAME_README).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_README).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `readme` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_README).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LICENSE_ID) != null && !jsonObj.get(SERIALIZED_NAME_LICENSE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LICENSE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `license_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LICENSE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT) != null && !jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `license_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LICENSE_TEXT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
    }

    public static UDFInfoUpdate fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, UDFInfoUpdate.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_LANGUAGE);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_IMAGE_NAME);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_EXEC);
        openapiFields.add(SERIALIZED_NAME_EXEC_RAW);
        openapiFields.add(SERIALIZED_NAME_README);
        openapiFields.add(SERIALIZED_NAME_LICENSE_ID);
        openapiFields.add(SERIALIZED_NAME_LICENSE_TEXT);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!UDFInfoUpdate.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<UDFInfoUpdate> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(UDFInfoUpdate.class));
            return new TypeAdapter<UDFInfoUpdate>(){

                @Override
                public void write(JsonWriter out, UDFInfoUpdate value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public UDFInfoUpdate read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UDFInfoUpdate.validateJsonObject(jsonObj);
                    UDFInfoUpdate instance = (UDFInfoUpdate)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

