/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.JSON;
import io.tiledb.cloud.rest_api.model.AssetLocations;
import io.tiledb.cloud.rest_api.model.NamespaceActions;
import io.tiledb.cloud.rest_api.model.OrganizationUser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="User")
public class User {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static final String SERIALIZED_NAME_PASSWORD = "password";
    @SerializedName(value="password")
    private String password;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_IS_VALID_EMAIL = "is_valid_email";
    @SerializedName(value="is_valid_email")
    private Boolean isValidEmail;
    public static final String SERIALIZED_NAME_STRIPE_CONNECT = "stripe_connect";
    @SerializedName(value="stripe_connect")
    private Boolean stripeConnect;
    public static final String SERIALIZED_NAME_COMPANY = "company";
    @SerializedName(value="company")
    private String company;
    public static final String SERIALIZED_NAME_LOGO = "logo";
    @SerializedName(value="logo")
    private String logo;
    public static final String SERIALIZED_NAME_TIMEZONE = "timezone";
    @SerializedName(value="timezone")
    private String timezone;
    public static final String SERIALIZED_NAME_ORGANIZATIONS = "organizations";
    @SerializedName(value="organizations")
    private List<OrganizationUser> organizations = null;
    public static final String SERIALIZED_NAME_ALLOWED_ACTIONS = "allowed_actions";
    @SerializedName(value="allowed_actions")
    private List<NamespaceActions> allowedActions = null;
    public static final String SERIALIZED_NAME_ENABLED_FEATURES = "enabled_features";
    @SerializedName(value="enabled_features")
    private List<String> enabledFeatures = null;
    public static final String SERIALIZED_NAME_UNPAID_SUBSCRIPTION = "unpaid_subscription";
    @SerializedName(value="unpaid_subscription")
    private Boolean unpaidSubscription;
    public static final String SERIALIZED_NAME_DEFAULT_S3_PATH = "default_s3_path";
    @SerializedName(value="default_s3_path")
    private String defaultS3Path;
    public static final String SERIALIZED_NAME_DEFAULT_S3_PATH_CREDENTIALS_NAME = "default_s3_path_credentials_name";
    @SerializedName(value="default_s3_path_credentials_name")
    private Object defaultS3PathCredentialsName;
    public static final String SERIALIZED_NAME_ASSET_LOCATIONS = "asset_locations";
    @SerializedName(value="asset_locations")
    private AssetLocations assetLocations;
    public static final String SERIALIZED_NAME_DEFAULT_NAMESPACE_CHARGED = "default_namespace_charged";
    @SerializedName(value="default_namespace_charged")
    private String defaultNamespaceCharged;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public User() {
    }

    public User(Boolean isValidEmail, Boolean stripeConnect, List<OrganizationUser> organizations, List<String> enabledFeatures, Boolean unpaidSubscription) {
        this();
        this.isValidEmail = isValidEmail;
        this.stripeConnect = stripeConnect;
        this.organizations = organizations;
        this.enabledFeatures = enabledFeatures;
        this.unpaidSubscription = unpaidSubscription;
    }

    public User id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="unique ID of user")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public User username(String username) {
        this.username = username;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="username", required=true, value="username must be unique")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public User password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="password", value="password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public User name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Jane Doe", value="the user's full, real name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public User email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="jane.doe@example.com", value="the user's email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Nullable
    @ApiModelProperty(example="false", value="user's email is validated to be correct")
    public Boolean getIsValidEmail() {
        return this.isValidEmail;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Denotes that the user is able to apply pricing to arrays by means of Stripe Connect")
    public Boolean getStripeConnect() {
        return this.stripeConnect;
    }

    public User company(String company) {
        this.company = company;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="TileDB", value="the user's company")
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public User logo(String logo) {
        this.logo = logo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the user's logo")
    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public User timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Europe/Athens", value="")
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Nullable
    @ApiModelProperty(value="Array of organizations a user is part of and their roles")
    public List<OrganizationUser> getOrganizations() {
        return this.organizations;
    }

    public User allowedActions(List<NamespaceActions> allowedActions) {
        this.allowedActions = allowedActions;
        return this;
    }

    public User addAllowedActionsItem(NamespaceActions allowedActionsItem) {
        if (this.allowedActions == null) {
            this.allowedActions = new ArrayList<NamespaceActions>();
        }
        this.allowedActions.add(allowedActionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="list of actions user is allowed to do on this organization")
    public List<NamespaceActions> getAllowedActions() {
        return this.allowedActions;
    }

    public void setAllowedActions(List<NamespaceActions> allowedActions) {
        this.allowedActions = allowedActions;
    }

    @Nullable
    @ApiModelProperty(value="List of extra/optional/beta features to enable for namespace")
    public List<String> getEnabledFeatures() {
        return this.enabledFeatures;
    }

    @Nullable
    @ApiModelProperty(value="A notice that the user has an unpaid subscription")
    public Boolean getUnpaidSubscription() {
        return this.unpaidSubscription;
    }

    public User defaultS3Path(String defaultS3Path) {
        this.defaultS3Path = defaultS3Path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default location to store newly-created notebooks and other assets like UDFs. The name `default_s3_path` is a legacy holdover; it may refer to any supported storage location. ")
    public String getDefaultS3Path() {
        return this.defaultS3Path;
    }

    public void setDefaultS3Path(String defaultS3Path) {
        this.defaultS3Path = defaultS3Path;
    }

    public User defaultS3PathCredentialsName(Object defaultS3PathCredentialsName) {
        this.defaultS3PathCredentialsName = defaultS3PathCredentialsName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the credentials used to create and access files in the `default_s3_path`, if needed. ")
    public Object getDefaultS3PathCredentialsName() {
        return this.defaultS3PathCredentialsName;
    }

    public void setDefaultS3PathCredentialsName(Object defaultS3PathCredentialsName) {
        this.defaultS3PathCredentialsName = defaultS3PathCredentialsName;
    }

    public User assetLocations(AssetLocations assetLocations) {
        this.assetLocations = assetLocations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AssetLocations getAssetLocations() {
        return this.assetLocations;
    }

    public void setAssetLocations(AssetLocations assetLocations) {
        this.assetLocations = assetLocations;
    }

    public User defaultNamespaceCharged(String defaultNamespaceCharged) {
        this.defaultNamespaceCharged = defaultNamespaceCharged;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Override the default namespace charged for actions when no namespace is specified")
    public String getDefaultNamespaceCharged() {
        return this.defaultNamespaceCharged;
    }

    public void setDefaultNamespaceCharged(String defaultNamespaceCharged) {
        this.defaultNamespaceCharged = defaultNamespaceCharged;
    }

    public User putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.id, user.id) && Objects.equals(this.username, user.username) && Objects.equals(this.password, user.password) && Objects.equals(this.name, user.name) && Objects.equals(this.email, user.email) && Objects.equals(this.isValidEmail, user.isValidEmail) && Objects.equals(this.stripeConnect, user.stripeConnect) && Objects.equals(this.company, user.company) && Objects.equals(this.logo, user.logo) && Objects.equals(this.timezone, user.timezone) && Objects.equals(this.organizations, user.organizations) && Objects.equals(this.allowedActions, user.allowedActions) && Objects.equals(this.enabledFeatures, user.enabledFeatures) && Objects.equals(this.unpaidSubscription, user.unpaidSubscription) && Objects.equals(this.defaultS3Path, user.defaultS3Path) && Objects.equals(this.defaultS3PathCredentialsName, user.defaultS3PathCredentialsName) && Objects.equals(this.assetLocations, user.assetLocations) && Objects.equals(this.defaultNamespaceCharged, user.defaultNamespaceCharged) && Objects.equals(this.additionalProperties, user.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.username, this.password, this.name, this.email, this.isValidEmail, this.stripeConnect, this.company, this.logo, this.timezone, this.organizations, this.allowedActions, this.enabledFeatures, this.unpaidSubscription, this.defaultS3Path, this.defaultS3PathCredentialsName, this.assetLocations, this.defaultNamespaceCharged, this.additionalProperties);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    isValidEmail: ").append(this.toIndentedString(this.isValidEmail)).append("\n");
        sb.append("    stripeConnect: ").append(this.toIndentedString(this.stripeConnect)).append("\n");
        sb.append("    company: ").append(this.toIndentedString(this.company)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    organizations: ").append(this.toIndentedString(this.organizations)).append("\n");
        sb.append("    allowedActions: ").append(this.toIndentedString(this.allowedActions)).append("\n");
        sb.append("    enabledFeatures: ").append(this.toIndentedString(this.enabledFeatures)).append("\n");
        sb.append("    unpaidSubscription: ").append(this.toIndentedString(this.unpaidSubscription)).append("\n");
        sb.append("    defaultS3Path: ").append(this.toIndentedString(this.defaultS3Path)).append("\n");
        sb.append("    defaultS3PathCredentialsName: ").append(this.toIndentedString(this.defaultS3PathCredentialsName)).append("\n");
        sb.append("    assetLocations: ").append(this.toIndentedString(this.assetLocations)).append("\n");
        sb.append("    defaultNamespaceCharged: ").append(this.toIndentedString(this.defaultNamespaceCharged)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in User is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSWORD) != null && !jsonObj.get(SERIALIZED_NAME_PASSWORD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PASSWORD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `password` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSWORD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMPANY) != null && !jsonObj.get(SERIALIZED_NAME_COMPANY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMPANY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `company` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPANY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LOGO) != null && !jsonObj.get(SERIALIZED_NAME_LOGO).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LOGO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `logo` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LOGO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIMEZONE) != null && !jsonObj.get(SERIALIZED_NAME_TIMEZONE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TIMEZONE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `timezone` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIMEZONE).toString()));
        }
        JsonArray jsonArrayorganizations = jsonObj.getAsJsonArray(SERIALIZED_NAME_ORGANIZATIONS);
        if (jsonArrayorganizations != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ORGANIZATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `organizations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORGANIZATIONS).toString()));
            }
            for (int i = 0; i < jsonArrayorganizations.size(); ++i) {
                OrganizationUser.validateJsonObject(jsonArrayorganizations.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `allowed_actions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_ACTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENABLED_FEATURES) != null && !jsonObj.get(SERIALIZED_NAME_ENABLED_FEATURES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENABLED_FEATURES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `enabled_features` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENABLED_FEATURES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFAULT_S3_PATH) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULT_S3_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEFAULT_S3_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `default_s3_path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFAULT_S3_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSET_LOCATIONS) != null && !jsonObj.get(SERIALIZED_NAME_ASSET_LOCATIONS).isJsonNull()) {
            AssetLocations.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ASSET_LOCATIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFAULT_NAMESPACE_CHARGED) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULT_NAMESPACE_CHARGED).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEFAULT_NAMESPACE_CHARGED).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `default_namespace_charged` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFAULT_NAMESPACE_CHARGED).toString()));
        }
    }

    public static User fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, User.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiFields.add(SERIALIZED_NAME_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_IS_VALID_EMAIL);
        openapiFields.add(SERIALIZED_NAME_STRIPE_CONNECT);
        openapiFields.add(SERIALIZED_NAME_COMPANY);
        openapiFields.add(SERIALIZED_NAME_LOGO);
        openapiFields.add(SERIALIZED_NAME_TIMEZONE);
        openapiFields.add(SERIALIZED_NAME_ORGANIZATIONS);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_ACTIONS);
        openapiFields.add(SERIALIZED_NAME_ENABLED_FEATURES);
        openapiFields.add(SERIALIZED_NAME_UNPAID_SUBSCRIPTION);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_S3_PATH);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_S3_PATH_CREDENTIALS_NAME);
        openapiFields.add(SERIALIZED_NAME_ASSET_LOCATIONS);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_NAMESPACE_CHARGED);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_USERNAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!User.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<User> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(User.class));
            return new TypeAdapter<User>(){

                @Override
                public void write(JsonWriter out, User value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public User read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    User.validateJsonObject(jsonObj);
                    User instance = (User)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

