/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.GsonFireBuilder;
import io.tiledb.cloud.rest_api.v2.model.AWSCredential;
import io.tiledb.cloud.rest_api.v2.model.AWSRole;
import io.tiledb.cloud.rest_api.v2.model.AccessCredential;
import io.tiledb.cloud.rest_api.v2.model.AccessCredentialCredential;
import io.tiledb.cloud.rest_api.v2.model.AccessCredentialRole;
import io.tiledb.cloud.rest_api.v2.model.AccessCredentialToken;
import io.tiledb.cloud.rest_api.v2.model.AccessCredentialsData;
import io.tiledb.cloud.rest_api.v2.model.Array;
import io.tiledb.cloud.rest_api.v2.model.ArrayActivityLog;
import io.tiledb.cloud.rest_api.v2.model.ArrayActivityLogData;
import io.tiledb.cloud.rest_api.v2.model.ArrayDirectory;
import io.tiledb.cloud.rest_api.v2.model.ArrayFetch;
import io.tiledb.cloud.rest_api.v2.model.ArrayMetadata;
import io.tiledb.cloud.rest_api.v2.model.ArrayMetadataEntry;
import io.tiledb.cloud.rest_api.v2.model.ArraySchema;
import io.tiledb.cloud.rest_api.v2.model.ArraySchemaEntry;
import io.tiledb.cloud.rest_api.v2.model.ArraySchemaMap;
import io.tiledb.cloud.rest_api.v2.model.Attribute;
import io.tiledb.cloud.rest_api.v2.model.AttributeBufferHeader;
import io.tiledb.cloud.rest_api.v2.model.AttributeBufferSize;
import io.tiledb.cloud.rest_api.v2.model.AzureCredential;
import io.tiledb.cloud.rest_api.v2.model.AzureToken;
import io.tiledb.cloud.rest_api.v2.model.DeleteAndUpdateTileLocation;
import io.tiledb.cloud.rest_api.v2.model.Dimension;
import io.tiledb.cloud.rest_api.v2.model.DimensionTileExtent;
import io.tiledb.cloud.rest_api.v2.model.Domain;
import io.tiledb.cloud.rest_api.v2.model.DomainArray;
import io.tiledb.cloud.rest_api.v2.model.Error;
import io.tiledb.cloud.rest_api.v2.model.FileUploaded;
import io.tiledb.cloud.rest_api.v2.model.Filter;
import io.tiledb.cloud.rest_api.v2.model.FilterData;
import io.tiledb.cloud.rest_api.v2.model.FilterPipeline;
import io.tiledb.cloud.rest_api.v2.model.FloatScaleConfig;
import io.tiledb.cloud.rest_api.v2.model.FragmentMetadata;
import io.tiledb.cloud.rest_api.v2.model.GCPInteroperabilityCredential;
import io.tiledb.cloud.rest_api.v2.model.GCPServiceAccountKey;
import io.tiledb.cloud.rest_api.v2.model.GenericTileOffsets;
import io.tiledb.cloud.rest_api.v2.model.GroupContentActivity;
import io.tiledb.cloud.rest_api.v2.model.GroupContentActivityAsset;
import io.tiledb.cloud.rest_api.v2.model.GroupContentActivityResponse;
import io.tiledb.cloud.rest_api.v2.model.GroupContentsChangesRequest;
import io.tiledb.cloud.rest_api.v2.model.GroupContentsChangesRequestGroupChanges;
import io.tiledb.cloud.rest_api.v2.model.GroupContentsRetrievalRequest;
import io.tiledb.cloud.rest_api.v2.model.GroupContentsRetrievalResponse;
import io.tiledb.cloud.rest_api.v2.model.GroupCreationRequest;
import io.tiledb.cloud.rest_api.v2.model.GroupCreationRequestGroupDetails;
import io.tiledb.cloud.rest_api.v2.model.GroupCreationResponse;
import io.tiledb.cloud.rest_api.v2.model.GroupMember;
import io.tiledb.cloud.rest_api.v2.model.GroupMetadataRetrievalRequest;
import io.tiledb.cloud.rest_api.v2.model.GroupMetadataUpdateRequest;
import io.tiledb.cloud.rest_api.v2.model.GroupRegistrationRequest;
import io.tiledb.cloud.rest_api.v2.model.GroupRegistrationRequestGroupDetails;
import io.tiledb.cloud.rest_api.v2.model.Metadata;
import io.tiledb.cloud.rest_api.v2.model.MetadataEntry;
import io.tiledb.cloud.rest_api.v2.model.NonEmptyDomain;
import io.tiledb.cloud.rest_api.v2.model.NonEmptyDomainList;
import io.tiledb.cloud.rest_api.v2.model.NotebookUploaded;
import io.tiledb.cloud.rest_api.v2.model.PaginationMetadata;
import io.tiledb.cloud.rest_api.v2.model.Query;
import io.tiledb.cloud.rest_api.v2.model.QueryReader;
import io.tiledb.cloud.rest_api.v2.model.ReadState;
import io.tiledb.cloud.rest_api.v2.model.Subarray;
import io.tiledb.cloud.rest_api.v2.model.SubarrayPartitioner;
import io.tiledb.cloud.rest_api.v2.model.SubarrayPartitionerCurrent;
import io.tiledb.cloud.rest_api.v2.model.SubarrayPartitionerState;
import io.tiledb.cloud.rest_api.v2.model.SubarrayRanges;
import io.tiledb.cloud.rest_api.v2.model.TileDBConfig;
import io.tiledb.cloud.rest_api.v2.model.TileDBConfigEntriesInner;
import io.tiledb.cloud.rest_api.v2.model.TimestampedURI;
import io.tiledb.cloud.rest_api.v2.model.Writer;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import okio.ByteString;

public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson;
    private static DateTypeAdapter dateTypeAdapter;
    private static SqlDateTypeAdapter sqlDateTypeAdapter;
    private static OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter;
    private static LocalDateTypeAdapter localDateTypeAdapter;
    private static ByteArrayAdapter byteArrayAdapter;

    public JSON() {
        GsonBuilder gsonBuilder = JSON.createGson();
        gsonBuilder.registerTypeAdapter((Type)((Object)Date.class), dateTypeAdapter);
        gsonBuilder.registerTypeAdapter((Type)((Object)java.sql.Date.class), sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter((Type)((Object)OffsetDateTime.class), offsetDateTimeTypeAdapter);
        gsonBuilder.registerTypeAdapter((Type)((Object)LocalDate.class), localDateTypeAdapter);
        gsonBuilder.registerTypeAdapter((Type)((Object)byte[].class), byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory(new AWSCredential.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AWSRole.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AccessCredential.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AccessCredentialCredential.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AccessCredentialRole.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AccessCredentialToken.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AccessCredentialsData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Array.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayActivityLog.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayActivityLogData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayDirectory.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayFetch.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayMetadataEntry.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArraySchema.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArraySchemaEntry.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArraySchemaMap.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Attribute.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttributeBufferHeader.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttributeBufferSize.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AzureCredential.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AzureToken.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DeleteAndUpdateTileLocation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Dimension.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DimensionTileExtent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Domain.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DomainArray.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Error.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FileUploaded.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Filter.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FilterData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FilterPipeline.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FloatScaleConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FragmentMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GCPInteroperabilityCredential.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GCPServiceAccountKey.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GenericTileOffsets.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupContentActivity.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupContentActivityAsset.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupContentActivityResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupContentsChangesRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupContentsChangesRequestGroupChanges.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupContentsRetrievalRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupContentsRetrievalResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupCreationRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupCreationRequestGroupDetails.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupCreationResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupMember.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupMetadataRetrievalRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupMetadataUpdateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupRegistrationRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupRegistrationRequestGroupDetails.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Metadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MetadataEntry.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NonEmptyDomain.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NonEmptyDomainList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NotebookUploaded.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PaginationMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Query.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new QueryReader.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ReadState.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Subarray.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SubarrayPartitioner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SubarrayPartitionerCurrent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SubarrayPartitionerState.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SubarrayRanges.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TileDBConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TileDBConfigEntriesInner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TimestampedURI.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Writer.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder();
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class)classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    public static Gson getGson() {
        return gson;
    }

    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader(new StringReader(body));
                jsonReader.setLenient(true);
                return gson.fromJson(jsonReader, returnType);
            }
            return gson.fromJson(body, returnType);
        }
        catch (JsonParseException e) {
            if (returnType.equals(String.class)) {
                return (T)body;
            }
            throw e;
        }
    }

    public static void setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        offsetDateTimeTypeAdapter.setFormat(dateFormat);
    }

    public static void setLocalDateFormat(DateTimeFormatter dateFormat) {
        localDateTypeAdapter.setFormat(dateFormat);
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }

    static {
        isLenientOnJson = false;
        dateTypeAdapter = new DateTypeAdapter();
        sqlDateTypeAdapter = new SqlDateTypeAdapter();
        offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
        localDateTypeAdapter = new LocalDateTypeAdapter();
        byteArrayAdapter = new ByteArrayAdapter();
    }

    public static class DateTypeAdapter
    extends TypeAdapter<Date> {
        private DateFormat dateFormat;

        public DateTypeAdapter() {
        }

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : ISO8601Utils.format(date, true);
                out.value(value);
            }
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL: {
                        in.nextNull();
                        return null;
                    }
                }
                String date = in.nextString();
                try {
                    if (this.dateFormat != null) {
                        return this.dateFormat.parse(date);
                    }
                    return ISO8601Utils.parse(date, new ParsePosition(0));
                }
                catch (ParseException e) {
                    throw new JsonParseException(e);
                }
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static class SqlDateTypeAdapter
    extends TypeAdapter<java.sql.Date> {
        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {
        }

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, java.sql.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : date.toString();
                out.value(value);
            }
        }

        @Override
        public java.sql.Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            try {
                if (this.dateFormat != null) {
                    return new java.sql.Date(this.dateFormat.parse(date).getTime());
                }
                return new java.sql.Date(ISO8601Utils.parse(date, new ParsePosition(0)).getTime());
            }
            catch (ParseException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static class LocalDateTypeAdapter
    extends TypeAdapter<LocalDate> {
        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        @Override
        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            return LocalDate.parse(date, this.formatter);
        }
    }

    public static class OffsetDateTimeTypeAdapter
    extends TypeAdapter<OffsetDateTime> {
        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        @Override
        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            if (date.endsWith("+0000")) {
                date = date.substring(0, date.length() - 5) + "Z";
            }
            return OffsetDateTime.parse(date, this.formatter);
        }
    }

    public static class ByteArrayAdapter
    extends TypeAdapter<byte[]> {
        @Override
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of(value).base64());
            }
        }

        @Override
        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String bytesAsBase64 = in.nextString();
            ByteString byteString = ByteString.decodeBase64(bytesAsBase64);
            return byteString.toByteArray();
        }
    }
}

