/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.v2.ApiCallback;
import io.tiledb.cloud.rest_api.v2.ApiClient;
import io.tiledb.cloud.rest_api.v2.ApiException;
import io.tiledb.cloud.rest_api.v2.ApiResponse;
import io.tiledb.cloud.rest_api.v2.Configuration;
import io.tiledb.cloud.rest_api.v2.Pair;
import io.tiledb.cloud.rest_api.v2.model.Array;
import io.tiledb.cloud.rest_api.v2.model.ArrayActivityLogData;
import io.tiledb.cloud.rest_api.v2.model.ArrayFetch;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ArrayApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ArrayApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ArrayApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call arrayActivityLogCall(String namespace, String array, Integer start, Integer end, List<String> eventTypes, String taskId, Boolean hasTaskId, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/arrays/{namespace}/{array}/activity".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (end != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end", end));
        }
        if (eventTypes != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "event_types", eventTypes));
        }
        if (taskId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("task_id", taskId));
        }
        if (hasTaskId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("has_task_id", hasTaskId));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call arrayActivityLogValidateBeforeCall(String namespace, String array, Integer start, Integer end, List<String> eventTypes, String taskId, Boolean hasTaskId, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling arrayActivityLog(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling arrayActivityLog(Async)");
        }
        Call localVarCall = this.arrayActivityLogCall(namespace, array, start, end, eventTypes, taskId, hasTaskId, page, perPage, _callback);
        return localVarCall;
    }

    public ArrayActivityLogData arrayActivityLog(String namespace, String array, Integer start, Integer end, List<String> eventTypes, String taskId, Boolean hasTaskId, Integer page, Integer perPage) throws ApiException {
        ApiResponse<ArrayActivityLogData> localVarResp = this.arrayActivityLogWithHttpInfo(namespace, array, start, end, eventTypes, taskId, hasTaskId, page, perPage);
        return localVarResp.getData();
    }

    public ApiResponse<ArrayActivityLogData> arrayActivityLogWithHttpInfo(String namespace, String array, Integer start, Integer end, List<String> eventTypes, String taskId, Boolean hasTaskId, Integer page, Integer perPage) throws ApiException {
        Call localVarCall = this.arrayActivityLogValidateBeforeCall(namespace, array, start, end, eventTypes, taskId, hasTaskId, page, perPage, null);
        Type localVarReturnType = new TypeToken<ArrayActivityLogData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call arrayActivityLogAsync(String namespace, String array, Integer start, Integer end, List<String> eventTypes, String taskId, Boolean hasTaskId, Integer page, Integer perPage, ApiCallback<ArrayActivityLogData> _callback) throws ApiException {
        Call localVarCall = this.arrayActivityLogValidateBeforeCall(namespace, array, start, end, eventTypes, taskId, hasTaskId, page, perPage, _callback);
        Type localVarReturnType = new TypeToken<ArrayActivityLogData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getArrayCall(String namespace, String array, String contentType, ArrayFetch arrayFetch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ArrayFetch localVarPostBody = arrayFetch;
        String localVarPath = "/arrays/{namespace}/{array}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getArrayValidateBeforeCall(String namespace, String array, String contentType, ArrayFetch arrayFetch, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArray(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArray(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling getArray(Async)");
        }
        if (arrayFetch == null) {
            throw new ApiException("Missing the required parameter 'arrayFetch' when calling getArray(Async)");
        }
        Call localVarCall = this.getArrayCall(namespace, array, contentType, arrayFetch, _callback);
        return localVarCall;
    }

    public Array getArray(String namespace, String array, String contentType, ArrayFetch arrayFetch) throws ApiException {
        ApiResponse<Array> localVarResp = this.getArrayWithHttpInfo(namespace, array, contentType, arrayFetch);
        return localVarResp.getData();
    }

    public ApiResponse<Array> getArrayWithHttpInfo(String namespace, String array, String contentType, ArrayFetch arrayFetch) throws ApiException {
        Call localVarCall = this.getArrayValidateBeforeCall(namespace, array, contentType, arrayFetch, null);
        Type localVarReturnType = new TypeToken<Array>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getArrayAsync(String namespace, String array, String contentType, ArrayFetch arrayFetch, ApiCallback<Array> _callback) throws ApiException {
        Call localVarCall = this.getArrayValidateBeforeCall(namespace, array, contentType, arrayFetch, _callback);
        Type localVarReturnType = new TypeToken<Array>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

