/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.v2.ApiCallback;
import io.tiledb.cloud.rest_api.v2.ApiClient;
import io.tiledb.cloud.rest_api.v2.ApiException;
import io.tiledb.cloud.rest_api.v2.ApiResponse;
import io.tiledb.cloud.rest_api.v2.Configuration;
import io.tiledb.cloud.rest_api.v2.Pair;
import io.tiledb.cloud.rest_api.v2.model.GroupContentActivityResponse;
import io.tiledb.cloud.rest_api.v2.model.GroupContentsChangesRequest;
import io.tiledb.cloud.rest_api.v2.model.GroupContentsRetrievalRequest;
import io.tiledb.cloud.rest_api.v2.model.GroupContentsRetrievalResponse;
import io.tiledb.cloud.rest_api.v2.model.GroupCreationRequest;
import io.tiledb.cloud.rest_api.v2.model.GroupCreationResponse;
import io.tiledb.cloud.rest_api.v2.model.GroupMetadataRetrievalRequest;
import io.tiledb.cloud.rest_api.v2.model.GroupMetadataUpdateRequest;
import io.tiledb.cloud.rest_api.v2.model.GroupRegistrationRequest;
import io.tiledb.cloud.rest_api.v2.model.Metadata;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class GroupsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public GroupsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GroupsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createGroupCall(String groupNamespace, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupCreationRequest groupCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GroupCreationRequest localVarPostBody = groupCreation;
        String localVarPath = "/groups/{group_namespace}".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME != null) {
            localVarHeaderParams.put("X-TILEDB-CLOUD-ACCESS-CREDENTIALS-NAME", this.localVarApiClient.parameterToString(X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createGroupValidateBeforeCall(String groupNamespace, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupCreationRequest groupCreation, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling createGroup(Async)");
        }
        Call localVarCall = this.createGroupCall(groupNamespace, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupCreation, _callback);
        return localVarCall;
    }

    public GroupCreationResponse createGroup(String groupNamespace, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupCreationRequest groupCreation) throws ApiException {
        ApiResponse<GroupCreationResponse> localVarResp = this.createGroupWithHttpInfo(groupNamespace, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupCreation);
        return localVarResp.getData();
    }

    public ApiResponse<GroupCreationResponse> createGroupWithHttpInfo(String groupNamespace, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupCreationRequest groupCreation) throws ApiException {
        Call localVarCall = this.createGroupValidateBeforeCall(groupNamespace, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupCreation, null);
        Type localVarReturnType = new TypeToken<GroupCreationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createGroupAsync(String groupNamespace, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupCreationRequest groupCreation, ApiCallback<GroupCreationResponse> _callback) throws ApiException {
        Call localVarCall = this.createGroupValidateBeforeCall(groupNamespace, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupCreation, _callback);
        Type localVarReturnType = new TypeToken<GroupCreationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteGroupCall(String groupNamespace, String groupName, String recursive, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/{group_namespace}/{group_name}/delete".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (recursive != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recursive", recursive));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteGroupValidateBeforeCall(String groupNamespace, String groupName, String recursive, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling deleteGroup(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling deleteGroup(Async)");
        }
        Call localVarCall = this.deleteGroupCall(groupNamespace, groupName, recursive, _callback);
        return localVarCall;
    }

    public void deleteGroup(String groupNamespace, String groupName, String recursive) throws ApiException {
        this.deleteGroupWithHttpInfo(groupNamespace, groupName, recursive);
    }

    public ApiResponse<Void> deleteGroupWithHttpInfo(String groupNamespace, String groupName, String recursive) throws ApiException {
        Call localVarCall = this.deleteGroupValidateBeforeCall(groupNamespace, groupName, recursive, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteGroupAsync(String groupNamespace, String groupName, String recursive, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteGroupValidateBeforeCall(groupNamespace, groupName, recursive, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deregisterGroupCall(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String recursive, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/{group_namespace}/{group_name}".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (recursive != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recursive", recursive));
        }
        if (X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME != null) {
            localVarHeaderParams.put("X-TILEDB-CLOUD-ACCESS-CREDENTIALS-NAME", this.localVarApiClient.parameterToString(X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deregisterGroupValidateBeforeCall(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String recursive, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling deregisterGroup(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling deregisterGroup(Async)");
        }
        Call localVarCall = this.deregisterGroupCall(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, recursive, _callback);
        return localVarCall;
    }

    public void deregisterGroup(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String recursive) throws ApiException {
        this.deregisterGroupWithHttpInfo(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, recursive);
    }

    public ApiResponse<Void> deregisterGroupWithHttpInfo(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String recursive) throws ApiException {
        Call localVarCall = this.deregisterGroupValidateBeforeCall(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, recursive, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deregisterGroupAsync(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String recursive, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deregisterGroupValidateBeforeCall(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, recursive, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getGroupContentActivityCall(String groupNamespace, String groupName, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/{group_namespace}/{group_name}/content_activity".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupContentActivityValidateBeforeCall(String groupNamespace, String groupName, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling getGroupContentActivity(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling getGroupContentActivity(Async)");
        }
        Call localVarCall = this.getGroupContentActivityCall(groupNamespace, groupName, page, perPage, _callback);
        return localVarCall;
    }

    public GroupContentActivityResponse getGroupContentActivity(String groupNamespace, String groupName, Integer page, Integer perPage) throws ApiException {
        ApiResponse<GroupContentActivityResponse> localVarResp = this.getGroupContentActivityWithHttpInfo(groupNamespace, groupName, page, perPage);
        return localVarResp.getData();
    }

    public ApiResponse<GroupContentActivityResponse> getGroupContentActivityWithHttpInfo(String groupNamespace, String groupName, Integer page, Integer perPage) throws ApiException {
        Call localVarCall = this.getGroupContentActivityValidateBeforeCall(groupNamespace, groupName, page, perPage, null);
        Type localVarReturnType = new TypeToken<GroupContentActivityResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGroupContentActivityAsync(String groupNamespace, String groupName, Integer page, Integer perPage, ApiCallback<GroupContentActivityResponse> _callback) throws ApiException {
        Call localVarCall = this.getGroupContentActivityValidateBeforeCall(groupNamespace, groupName, page, perPage, _callback);
        Type localVarReturnType = new TypeToken<GroupContentActivityResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getGroupMetadataCall(String groupNamespace, String groupName, GroupMetadataRetrievalRequest metadataRetrieval, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GroupMetadataRetrievalRequest localVarPostBody = metadataRetrieval;
        String localVarPath = "/groups/{group_namespace}/{group_name}/metadata".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupMetadataValidateBeforeCall(String groupNamespace, String groupName, GroupMetadataRetrievalRequest metadataRetrieval, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling getGroupMetadata(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling getGroupMetadata(Async)");
        }
        Call localVarCall = this.getGroupMetadataCall(groupNamespace, groupName, metadataRetrieval, _callback);
        return localVarCall;
    }

    public Metadata getGroupMetadata(String groupNamespace, String groupName, GroupMetadataRetrievalRequest metadataRetrieval) throws ApiException {
        ApiResponse<Metadata> localVarResp = this.getGroupMetadataWithHttpInfo(groupNamespace, groupName, metadataRetrieval);
        return localVarResp.getData();
    }

    public ApiResponse<Metadata> getGroupMetadataWithHttpInfo(String groupNamespace, String groupName, GroupMetadataRetrievalRequest metadataRetrieval) throws ApiException {
        Call localVarCall = this.getGroupMetadataValidateBeforeCall(groupNamespace, groupName, metadataRetrieval, null);
        Type localVarReturnType = new TypeToken<Metadata>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGroupMetadataAsync(String groupNamespace, String groupName, GroupMetadataRetrievalRequest metadataRetrieval, ApiCallback<Metadata> _callback) throws ApiException {
        Call localVarCall = this.getGroupMetadataValidateBeforeCall(groupNamespace, groupName, metadataRetrieval, _callback);
        Type localVarReturnType = new TypeToken<Metadata>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call groupsGroupNamespaceGroupNameOptionsCall(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/groups/{group_namespace}/{group_name}".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME != null) {
            localVarHeaderParams.put("X-TILEDB-CLOUD-ACCESS-CREDENTIALS-NAME", this.localVarApiClient.parameterToString(X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call groupsGroupNamespaceGroupNameOptionsValidateBeforeCall(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling groupsGroupNamespaceGroupNameOptions(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling groupsGroupNamespaceGroupNameOptions(Async)");
        }
        Call localVarCall = this.groupsGroupNamespaceGroupNameOptionsCall(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, _callback);
        return localVarCall;
    }

    public void groupsGroupNamespaceGroupNameOptions(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME) throws ApiException {
        this.groupsGroupNamespaceGroupNameOptionsWithHttpInfo(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME);
    }

    public ApiResponse<Void> groupsGroupNamespaceGroupNameOptionsWithHttpInfo(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME) throws ApiException {
        Call localVarCall = this.groupsGroupNamespaceGroupNameOptionsValidateBeforeCall(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call groupsGroupNamespaceGroupNameOptionsAsync(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.groupsGroupNamespaceGroupNameOptionsValidateBeforeCall(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call registerGroupCall(String groupNamespace, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupRegistrationRequest groupRegistration, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GroupRegistrationRequest localVarPostBody = groupRegistration;
        String localVarPath = "/groups/{group_namespace}".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME != null) {
            localVarHeaderParams.put("X-TILEDB-CLOUD-ACCESS-CREDENTIALS-NAME", this.localVarApiClient.parameterToString(X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call registerGroupValidateBeforeCall(String groupNamespace, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupRegistrationRequest groupRegistration, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling registerGroup(Async)");
        }
        Call localVarCall = this.registerGroupCall(groupNamespace, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupRegistration, _callback);
        return localVarCall;
    }

    public void registerGroup(String groupNamespace, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupRegistrationRequest groupRegistration) throws ApiException {
        this.registerGroupWithHttpInfo(groupNamespace, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupRegistration);
    }

    public ApiResponse<Void> registerGroupWithHttpInfo(String groupNamespace, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupRegistrationRequest groupRegistration) throws ApiException {
        Call localVarCall = this.registerGroupValidateBeforeCall(groupNamespace, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupRegistration, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call registerGroupAsync(String groupNamespace, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupRegistrationRequest groupRegistration, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.registerGroupValidateBeforeCall(groupNamespace, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupRegistration, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call retrieveGroupCall(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupContentsRetrievalRequest groupRetrieval, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GroupContentsRetrievalRequest localVarPostBody = groupRetrieval;
        String localVarPath = "/groups/{group_namespace}/{group_name}".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME != null) {
            localVarHeaderParams.put("X-TILEDB-CLOUD-ACCESS-CREDENTIALS-NAME", this.localVarApiClient.parameterToString(X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call retrieveGroupValidateBeforeCall(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupContentsRetrievalRequest groupRetrieval, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling retrieveGroup(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling retrieveGroup(Async)");
        }
        Call localVarCall = this.retrieveGroupCall(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupRetrieval, _callback);
        return localVarCall;
    }

    public GroupContentsRetrievalResponse retrieveGroup(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupContentsRetrievalRequest groupRetrieval) throws ApiException {
        ApiResponse<GroupContentsRetrievalResponse> localVarResp = this.retrieveGroupWithHttpInfo(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupRetrieval);
        return localVarResp.getData();
    }

    public ApiResponse<GroupContentsRetrievalResponse> retrieveGroupWithHttpInfo(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupContentsRetrievalRequest groupRetrieval) throws ApiException {
        Call localVarCall = this.retrieveGroupValidateBeforeCall(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupRetrieval, null);
        Type localVarReturnType = new TypeToken<GroupContentsRetrievalResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call retrieveGroupAsync(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupContentsRetrievalRequest groupRetrieval, ApiCallback<GroupContentsRetrievalResponse> _callback) throws ApiException {
        Call localVarCall = this.retrieveGroupValidateBeforeCall(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupRetrieval, _callback);
        Type localVarReturnType = new TypeToken<GroupContentsRetrievalResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateGroupContentsCall(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupContentsChangesRequest groupUpdateContents, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GroupContentsChangesRequest localVarPostBody = groupUpdateContents;
        String localVarPath = "/groups/{group_namespace}/{group_name}".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME != null) {
            localVarHeaderParams.put("X-TILEDB-CLOUD-ACCESS-CREDENTIALS-NAME", this.localVarApiClient.parameterToString(X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateGroupContentsValidateBeforeCall(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupContentsChangesRequest groupUpdateContents, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling updateGroupContents(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling updateGroupContents(Async)");
        }
        Call localVarCall = this.updateGroupContentsCall(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupUpdateContents, _callback);
        return localVarCall;
    }

    public void updateGroupContents(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupContentsChangesRequest groupUpdateContents) throws ApiException {
        this.updateGroupContentsWithHttpInfo(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupUpdateContents);
    }

    public ApiResponse<Void> updateGroupContentsWithHttpInfo(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupContentsChangesRequest groupUpdateContents) throws ApiException {
        Call localVarCall = this.updateGroupContentsValidateBeforeCall(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupUpdateContents, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateGroupContentsAsync(String groupNamespace, String groupName, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, GroupContentsChangesRequest groupUpdateContents, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateGroupContentsValidateBeforeCall(groupNamespace, groupName, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, groupUpdateContents, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateGroupMetadataCall(String groupNamespace, String groupName, GroupMetadataUpdateRequest metadataUpdating, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GroupMetadataUpdateRequest localVarPostBody = metadataUpdating;
        String localVarPath = "/groups/{group_namespace}/{group_name}/metadata".replaceAll("\\{group_namespace\\}", this.localVarApiClient.escapeString(groupNamespace.toString())).replaceAll("\\{group_name\\}", this.localVarApiClient.escapeString(groupName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateGroupMetadataValidateBeforeCall(String groupNamespace, String groupName, GroupMetadataUpdateRequest metadataUpdating, ApiCallback _callback) throws ApiException {
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling updateGroupMetadata(Async)");
        }
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling updateGroupMetadata(Async)");
        }
        Call localVarCall = this.updateGroupMetadataCall(groupNamespace, groupName, metadataUpdating, _callback);
        return localVarCall;
    }

    public void updateGroupMetadata(String groupNamespace, String groupName, GroupMetadataUpdateRequest metadataUpdating) throws ApiException {
        this.updateGroupMetadataWithHttpInfo(groupNamespace, groupName, metadataUpdating);
    }

    public ApiResponse<Void> updateGroupMetadataWithHttpInfo(String groupNamespace, String groupName, GroupMetadataUpdateRequest metadataUpdating) throws ApiException {
        Call localVarCall = this.updateGroupMetadataValidateBeforeCall(groupNamespace, groupName, metadataUpdating, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateGroupMetadataAsync(String groupNamespace, String groupName, GroupMetadataUpdateRequest metadataUpdating, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateGroupMetadataValidateBeforeCall(groupNamespace, groupName, metadataUpdating, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

