/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.v2.ApiCallback;
import io.tiledb.cloud.rest_api.v2.ApiClient;
import io.tiledb.cloud.rest_api.v2.ApiException;
import io.tiledb.cloud.rest_api.v2.ApiResponse;
import io.tiledb.cloud.rest_api.v2.Configuration;
import io.tiledb.cloud.rest_api.v2.Pair;
import io.tiledb.cloud.rest_api.v2.model.Query;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class QueryApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public QueryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public QueryApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call submitQueryCall(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, String readAll, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Query localVarPostBody = query;
        String localVarPath = "/arrays/{namespace}/{array}/query/submit".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{array\\}", this.localVarApiClient.escapeString(array.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (openAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("open_at", openAt));
        }
        if (readAll != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("read_all", readAll));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", this.localVarApiClient.parameterToString(xPayer));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/capnp"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/capnp"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call submitQueryValidateBeforeCall(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, String readAll, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling submitQuery(Async)");
        }
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling submitQuery(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling submitQuery(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling submitQuery(Async)");
        }
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling submitQuery(Async)");
        }
        Call localVarCall = this.submitQueryCall(namespace, array, type, contentType, query, xPayer, openAt, readAll, _callback);
        return localVarCall;
    }

    public File submitQuery(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, String readAll) throws ApiException {
        ApiResponse<File> localVarResp = this.submitQueryWithHttpInfo(namespace, array, type, contentType, query, xPayer, openAt, readAll);
        return localVarResp.getData();
    }

    public ApiResponse<File> submitQueryWithHttpInfo(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, String readAll) throws ApiException {
        Call localVarCall = this.submitQueryValidateBeforeCall(namespace, array, type, contentType, query, xPayer, openAt, readAll, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call submitQueryAsync(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, String readAll, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.submitQueryValidateBeforeCall(namespace, array, type, contentType, query, xPayer, openAt, readAll, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

