/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.api;

import com.google.gson.reflect.TypeToken;
import io.tiledb.cloud.rest_api.v2.ApiCallback;
import io.tiledb.cloud.rest_api.v2.ApiClient;
import io.tiledb.cloud.rest_api.v2.ApiException;
import io.tiledb.cloud.rest_api.v2.ApiResponse;
import io.tiledb.cloud.rest_api.v2.Configuration;
import io.tiledb.cloud.rest_api.v2.Pair;
import io.tiledb.cloud.rest_api.v2.model.AccessCredential;
import io.tiledb.cloud.rest_api.v2.model.AccessCredentialsData;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class UserApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public UserApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call addCredentialCall(String namespace, AccessCredential accessCredential, String provider, String type, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AccessCredential localVarPostBody = accessCredential;
        String localVarPath = "/credentials/{namespace}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (provider != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("provider", provider));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addCredentialValidateBeforeCall(String namespace, AccessCredential accessCredential, String provider, String type, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling addCredential(Async)");
        }
        if (accessCredential == null) {
            throw new ApiException("Missing the required parameter 'accessCredential' when calling addCredential(Async)");
        }
        Call localVarCall = this.addCredentialCall(namespace, accessCredential, provider, type, page, perPage, _callback);
        return localVarCall;
    }

    public void addCredential(String namespace, AccessCredential accessCredential, String provider, String type, Integer page, Integer perPage) throws ApiException {
        this.addCredentialWithHttpInfo(namespace, accessCredential, provider, type, page, perPage);
    }

    public ApiResponse<Void> addCredentialWithHttpInfo(String namespace, AccessCredential accessCredential, String provider, String type, Integer page, Integer perPage) throws ApiException {
        Call localVarCall = this.addCredentialValidateBeforeCall(namespace, accessCredential, provider, type, page, perPage, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call addCredentialAsync(String namespace, AccessCredential accessCredential, String provider, String type, Integer page, Integer perPage, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.addCredentialValidateBeforeCall(namespace, accessCredential, provider, type, page, perPage, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteCredentialCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credentials/{namespace}/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCredentialValidateBeforeCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteCredential(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteCredential(Async)");
        }
        Call localVarCall = this.deleteCredentialCall(namespace, name, _callback);
        return localVarCall;
    }

    public void deleteCredential(String namespace, String name) throws ApiException {
        this.deleteCredentialWithHttpInfo(namespace, name);
    }

    public ApiResponse<Void> deleteCredentialWithHttpInfo(String namespace, String name) throws ApiException {
        Call localVarCall = this.deleteCredentialValidateBeforeCall(namespace, name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteCredentialAsync(String namespace, String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteCredentialValidateBeforeCall(namespace, name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getCredentialCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credentials/{namespace}/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCredentialValidateBeforeCall(String namespace, String name, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getCredential(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getCredential(Async)");
        }
        Call localVarCall = this.getCredentialCall(namespace, name, _callback);
        return localVarCall;
    }

    public AccessCredential getCredential(String namespace, String name) throws ApiException {
        ApiResponse<AccessCredential> localVarResp = this.getCredentialWithHttpInfo(namespace, name);
        return localVarResp.getData();
    }

    public ApiResponse<AccessCredential> getCredentialWithHttpInfo(String namespace, String name) throws ApiException {
        Call localVarCall = this.getCredentialValidateBeforeCall(namespace, name, null);
        Type localVarReturnType = new TypeToken<AccessCredential>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCredentialAsync(String namespace, String name, ApiCallback<AccessCredential> _callback) throws ApiException {
        Call localVarCall = this.getCredentialValidateBeforeCall(namespace, name, _callback);
        Type localVarReturnType = new TypeToken<AccessCredential>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCredentialsCall(String namespace, String provider, String type, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/credentials/{namespace}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (provider != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("provider", provider));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (perPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("per_page", perPage));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCredentialsValidateBeforeCall(String namespace, String provider, String type, Integer page, Integer perPage, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listCredentials(Async)");
        }
        Call localVarCall = this.listCredentialsCall(namespace, provider, type, page, perPage, _callback);
        return localVarCall;
    }

    public AccessCredentialsData listCredentials(String namespace, String provider, String type, Integer page, Integer perPage) throws ApiException {
        ApiResponse<AccessCredentialsData> localVarResp = this.listCredentialsWithHttpInfo(namespace, provider, type, page, perPage);
        return localVarResp.getData();
    }

    public ApiResponse<AccessCredentialsData> listCredentialsWithHttpInfo(String namespace, String provider, String type, Integer page, Integer perPage) throws ApiException {
        Call localVarCall = this.listCredentialsValidateBeforeCall(namespace, provider, type, page, perPage, null);
        Type localVarReturnType = new TypeToken<AccessCredentialsData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCredentialsAsync(String namespace, String provider, String type, Integer page, Integer perPage, ApiCallback<AccessCredentialsData> _callback) throws ApiException {
        Call localVarCall = this.listCredentialsValidateBeforeCall(namespace, provider, type, page, perPage, _callback);
        Type localVarReturnType = new TypeToken<AccessCredentialsData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCredentialCall(String namespace, String name, AccessCredential accessCredential, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AccessCredential localVarPostBody = accessCredential;
        String localVarPath = "/credentials/{namespace}/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BasicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCredentialValidateBeforeCall(String namespace, String name, AccessCredential accessCredential, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateCredential(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateCredential(Async)");
        }
        if (accessCredential == null) {
            throw new ApiException("Missing the required parameter 'accessCredential' when calling updateCredential(Async)");
        }
        Call localVarCall = this.updateCredentialCall(namespace, name, accessCredential, _callback);
        return localVarCall;
    }

    public void updateCredential(String namespace, String name, AccessCredential accessCredential) throws ApiException {
        this.updateCredentialWithHttpInfo(namespace, name, accessCredential);
    }

    public ApiResponse<Void> updateCredentialWithHttpInfo(String namespace, String name, AccessCredential accessCredential) throws ApiException {
        Call localVarCall = this.updateCredentialValidateBeforeCall(namespace, name, accessCredential, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateCredentialAsync(String namespace, String name, AccessCredential accessCredential, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateCredentialValidateBeforeCall(namespace, name, accessCredential, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

