/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.auth;

import io.tiledb.cloud.rest_api.v2.ApiException;
import io.tiledb.cloud.rest_api.v2.Pair;
import io.tiledb.cloud.rest_api.v2.auth.OAuth;
import io.tiledb.cloud.rest_api.v2.auth.OAuthFlow;
import io.tiledb.cloud.rest_api.v2.auth.OAuthOkHttpClient;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;

public class RetryingOAuth
extends OAuth
implements Interceptor {
    private OAuthClient oAuthClient;
    private OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder;

    public RetryingOAuth(OkHttpClient client, OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        this.oAuthClient = new OAuthClient(new OAuthOkHttpClient(client));
        this.tokenRequestBuilder = tokenRequestBuilder;
    }

    public RetryingOAuth(OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        this(new OkHttpClient(), tokenRequestBuilder);
    }

    public RetryingOAuth(String tokenUrl, String clientId, OAuthFlow flow, String clientSecret, Map<String, String> parameters) {
        this(OAuthClientRequest.tokenLocation(tokenUrl).setClientId(clientId).setClientSecret(clientSecret));
        this.setFlow(flow);
        if (parameters != null) {
            for (String paramName : parameters.keySet()) {
                this.tokenRequestBuilder.setParameter(paramName, parameters.get(paramName));
            }
        }
    }

    public void setFlow(OAuthFlow flow) {
        switch (flow) {
            case ACCESS_CODE: {
                this.tokenRequestBuilder.setGrantType(GrantType.AUTHORIZATION_CODE);
                break;
            }
            case IMPLICIT: {
                this.tokenRequestBuilder.setGrantType(GrantType.IMPLICIT);
                break;
            }
            case PASSWORD: {
                this.tokenRequestBuilder.setGrantType(GrantType.PASSWORD);
                break;
            }
            case APPLICATION: {
                this.tokenRequestBuilder.setGrantType(GrantType.CLIENT_CREDENTIALS);
                break;
            }
        }
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.retryingIntercept(chain, true);
    }

    private Response retryingIntercept(Interceptor.Chain chain, boolean updateTokenAndRetryOnAuthorizationFailure) throws IOException {
        Request request = chain.request();
        if (request.header("Authorization") != null) {
            return chain.proceed(request);
        }
        if (this.getAccessToken() == null) {
            this.updateAccessToken(null);
        }
        if (this.getAccessToken() != null) {
            OAuthClientRequest oAuthRequest;
            Request.Builder requestBuilder = request.newBuilder();
            String requestAccessToken = this.getAccessToken();
            try {
                oAuthRequest = new OAuthBearerClientRequest(request.url().toString()).setAccessToken(requestAccessToken).buildHeaderMessage();
            }
            catch (OAuthSystemException e) {
                throw new IOException(e);
            }
            Map<String, String> headers = oAuthRequest.getHeaders();
            for (String headerName : headers.keySet()) {
                requestBuilder.addHeader(headerName, headers.get(headerName));
            }
            requestBuilder.url(oAuthRequest.getLocationUri());
            Response response = chain.proceed(requestBuilder.build());
            if (response != null && (response.code() == 401 || response.code() == 403) && updateTokenAndRetryOnAuthorizationFailure) {
                try {
                    if (this.updateAccessToken(requestAccessToken)) {
                        response.body().close();
                        return this.retryingIntercept(chain, false);
                    }
                }
                catch (Exception e) {
                    response.body().close();
                    throw e;
                }
            }
            return response;
        }
        return chain.proceed(chain.request());
    }

    public synchronized boolean updateAccessToken(String requestAccessToken) throws IOException {
        if (this.getAccessToken() == null || this.getAccessToken().equals(requestAccessToken)) {
            try {
                OAuthJSONAccessTokenResponse accessTokenResponse = this.oAuthClient.accessToken(this.tokenRequestBuilder.buildBodyMessage());
                if (accessTokenResponse != null && accessTokenResponse.getAccessToken() != null) {
                    this.setAccessToken(accessTokenResponse.getAccessToken());
                }
            }
            catch (OAuthProblemException | OAuthSystemException e) {
                throw new IOException(e);
            }
        }
        return this.getAccessToken() == null || !this.getAccessToken().equals(requestAccessToken);
    }

    public OAuthClientRequest.TokenRequestBuilder getTokenRequestBuilder() {
        return this.tokenRequestBuilder;
    }

    public void setTokenRequestBuilder(OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        this.tokenRequestBuilder = tokenRequestBuilder;
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams, String payload, String method, URI uri) throws ApiException {
    }
}

