/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import io.tiledb.cloud.rest_api.v2.model.AccessCredentialCredential;
import io.tiledb.cloud.rest_api.v2.model.AccessCredentialRole;
import io.tiledb.cloud.rest_api.v2.model.AccessCredentialToken;
import io.tiledb.cloud.rest_api.v2.model.CloudProvider;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="A union type which may contain a credential to access any one cloud provider.")
public class AccessCredential {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PROVIDER = "provider";
    @SerializedName(value="provider")
    private CloudProvider provider;
    public static final String SERIALIZED_NAME_PROVIDER_DEFAULT = "provider_default";
    @SerializedName(value="provider_default")
    private Boolean providerDefault;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_ALLOWED_IN_TASKS = "allowed_in_tasks";
    @SerializedName(value="allowed_in_tasks")
    private Boolean allowedInTasks;
    public static final String SERIALIZED_NAME_CREDENTIAL = "credential";
    @SerializedName(value="credential")
    private AccessCredentialCredential credential;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    private AccessCredentialRole role;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private AccessCredentialToken token;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AccessCredential() {
    }

    public AccessCredential(OffsetDateTime createdAt, OffsetDateTime updatedAt) {
        this();
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public AccessCredential name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A user-specified name for the key")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AccessCredential provider(CloudProvider provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CloudProvider getProvider() {
        return this.provider;
    }

    public void setProvider(CloudProvider provider) {
        this.provider = provider;
    }

    public AccessCredential providerDefault(Boolean providerDefault) {
        this.providerDefault = providerDefault;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if this is the namespace's default credential to be used when connecting to the given cloud provider. There can be at most one default for each unique provider.")
    public Boolean getProviderDefault() {
        return this.providerDefault;
    }

    public void setProviderDefault(Boolean providerDefault) {
        this.providerDefault = providerDefault;
    }

    @Nullable
    @ApiModelProperty(value="Time when the credential was created (rfc3339)")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @ApiModelProperty(value="Time when the credential was last updated (rfc3339)")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public AccessCredential allowedInTasks(Boolean allowedInTasks) {
        this.allowedInTasks = allowedInTasks;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Is this credential allowed to be used in tasks")
    public Boolean getAllowedInTasks() {
        return this.allowedInTasks;
    }

    public void setAllowedInTasks(Boolean allowedInTasks) {
        this.allowedInTasks = allowedInTasks;
    }

    public AccessCredential credential(AccessCredentialCredential credential) {
        this.credential = credential;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AccessCredentialCredential getCredential() {
        return this.credential;
    }

    public void setCredential(AccessCredentialCredential credential) {
        this.credential = credential;
    }

    public AccessCredential role(AccessCredentialRole role) {
        this.role = role;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AccessCredentialRole getRole() {
        return this.role;
    }

    public void setRole(AccessCredentialRole role) {
        this.role = role;
    }

    public AccessCredential token(AccessCredentialToken token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AccessCredentialToken getToken() {
        return this.token;
    }

    public void setToken(AccessCredentialToken token) {
        this.token = token;
    }

    public AccessCredential putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessCredential accessCredential = (AccessCredential)o;
        return Objects.equals(this.name, accessCredential.name) && Objects.equals((Object)this.provider, (Object)accessCredential.provider) && Objects.equals(this.providerDefault, accessCredential.providerDefault) && Objects.equals(this.createdAt, accessCredential.createdAt) && Objects.equals(this.updatedAt, accessCredential.updatedAt) && Objects.equals(this.allowedInTasks, accessCredential.allowedInTasks) && Objects.equals(this.credential, accessCredential.credential) && Objects.equals(this.role, accessCredential.role) && Objects.equals(this.token, accessCredential.token) && Objects.equals(this.additionalProperties, accessCredential.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.provider, this.providerDefault, this.createdAt, this.updatedAt, this.allowedInTasks, this.credential, this.role, this.token, this.additionalProperties});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccessCredential {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    providerDefault: ").append(this.toIndentedString(this.providerDefault)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    allowedInTasks: ").append(this.toIndentedString(this.allowedInTasks)).append("\n");
        sb.append("    credential: ").append(this.toIndentedString(this.credential)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AccessCredential is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CREDENTIAL) != null) {
            AccessCredentialCredential.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CREDENTIAL));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ROLE) != null) {
            AccessCredentialRole.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ROLE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN) != null) {
            AccessCredentialToken.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TOKEN));
        }
    }

    public static AccessCredential fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, AccessCredential.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_PROVIDER);
        openapiFields.add(SERIALIZED_NAME_PROVIDER_DEFAULT);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_IN_TASKS);
        openapiFields.add(SERIALIZED_NAME_CREDENTIAL);
        openapiFields.add(SERIALIZED_NAME_ROLE);
        openapiFields.add(SERIALIZED_NAME_TOKEN);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AccessCredential.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<AccessCredential> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(AccessCredential.class));
            return new TypeAdapter<AccessCredential>(){

                @Override
                public void write(JsonWriter out, AccessCredential value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public AccessCredential read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AccessCredential.validateJsonObject(jsonObj);
                    AccessCredential instance = (AccessCredential)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

