/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import io.tiledb.cloud.rest_api.v2.model.AWSCredential;
import io.tiledb.cloud.rest_api.v2.model.AzureCredential;
import io.tiledb.cloud.rest_api.v2.model.GCPInteroperabilityCredential;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The credential information itself. Exactly one sub-field may be set. The names match those in the CloudProvider enum.")
public class AccessCredentialCredential {
    public static final String SERIALIZED_NAME_AWS = "aws";
    @SerializedName(value="aws")
    private AWSCredential aws;
    public static final String SERIALIZED_NAME_AZURE = "azure";
    @SerializedName(value="azure")
    private AzureCredential azure;
    public static final String SERIALIZED_NAME_GCP = "gcp";
    @SerializedName(value="gcp")
    private GCPInteroperabilityCredential gcp;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AccessCredentialCredential aws(AWSCredential aws) {
        this.aws = aws;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AWSCredential getAws() {
        return this.aws;
    }

    public void setAws(AWSCredential aws) {
        this.aws = aws;
    }

    public AccessCredentialCredential azure(AzureCredential azure) {
        this.azure = azure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AzureCredential getAzure() {
        return this.azure;
    }

    public void setAzure(AzureCredential azure) {
        this.azure = azure;
    }

    public AccessCredentialCredential gcp(GCPInteroperabilityCredential gcp) {
        this.gcp = gcp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public GCPInteroperabilityCredential getGcp() {
        return this.gcp;
    }

    public void setGcp(GCPInteroperabilityCredential gcp) {
        this.gcp = gcp;
    }

    public AccessCredentialCredential putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessCredentialCredential accessCredentialCredential = (AccessCredentialCredential)o;
        return Objects.equals(this.aws, accessCredentialCredential.aws) && Objects.equals(this.azure, accessCredentialCredential.azure) && Objects.equals(this.gcp, accessCredentialCredential.gcp) && Objects.equals(this.additionalProperties, accessCredentialCredential.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.aws, this.azure, this.gcp, this.additionalProperties);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccessCredentialCredential {\n");
        sb.append("    aws: ").append(this.toIndentedString(this.aws)).append("\n");
        sb.append("    azure: ").append(this.toIndentedString(this.azure)).append("\n");
        sb.append("    gcp: ").append(this.toIndentedString(this.gcp)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AccessCredentialCredential is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AWS) != null) {
            AWSCredential.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AWS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AZURE) != null) {
            AzureCredential.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AZURE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_GCP) != null) {
            GCPInteroperabilityCredential.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GCP));
        }
    }

    public static AccessCredentialCredential fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, AccessCredentialCredential.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AWS);
        openapiFields.add(SERIALIZED_NAME_AZURE);
        openapiFields.add(SERIALIZED_NAME_GCP);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AccessCredentialCredential.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<AccessCredentialCredential> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(AccessCredentialCredential.class));
            return new TypeAdapter<AccessCredentialCredential>(){

                @Override
                public void write(JsonWriter out, AccessCredentialCredential value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public AccessCredentialCredential read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AccessCredentialCredential.validateJsonObject(jsonObj);
                    AccessCredentialCredential instance = (AccessCredentialCredential)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

