/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import io.tiledb.cloud.rest_api.v2.model.ArrayDirectory;
import io.tiledb.cloud.rest_api.v2.model.ArrayMetadata;
import io.tiledb.cloud.rest_api.v2.model.ArraySchema;
import io.tiledb.cloud.rest_api.v2.model.ArraySchemaMap;
import io.tiledb.cloud.rest_api.v2.model.FragmentMetadata;
import io.tiledb.cloud.rest_api.v2.model.NonEmptyDomainList;
import io.tiledb.cloud.rest_api.v2.model.Querytype;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Represents an open array")
public class Array {
    public static final String SERIALIZED_NAME_QUERY_TYPE = "queryType";
    @SerializedName(value="queryType")
    private Querytype queryType;
    public static final String SERIALIZED_NAME_URI = "uri";
    @SerializedName(value="uri")
    private String uri;
    public static final String SERIALIZED_NAME_END_TIMESTAMP = "endTimestamp";
    @SerializedName(value="endTimestamp")
    private BigDecimal endTimestamp;
    public static final String SERIALIZED_NAME_START_TIMESTAMP = "startTimestamp";
    @SerializedName(value="startTimestamp")
    private BigDecimal startTimestamp;
    public static final String SERIALIZED_NAME_ARRAY_SCHEMA_LATEST = "arraySchemaLatest";
    @SerializedName(value="arraySchemaLatest")
    private ArraySchema arraySchemaLatest;
    public static final String SERIALIZED_NAME_ARRAY_SCHEMAS_ALL = "arraySchemasAll";
    @SerializedName(value="arraySchemasAll")
    private ArraySchemaMap arraySchemasAll;
    public static final String SERIALIZED_NAME_ARRAY_METADATA = "arrayMetadata";
    @SerializedName(value="arrayMetadata")
    private ArrayMetadata arrayMetadata;
    public static final String SERIALIZED_NAME_NON_EMPTY_DOMAIN = "nonEmptyDomain";
    @SerializedName(value="nonEmptyDomain")
    private NonEmptyDomainList nonEmptyDomain;
    public static final String SERIALIZED_NAME_ARRAY_DIRECTORY = "arrayDirectory";
    @SerializedName(value="arrayDirectory")
    private ArrayDirectory arrayDirectory;
    public static final String SERIALIZED_NAME_FRAGMENT_METADATA_ALL = "fragmentMetadataAll";
    @SerializedName(value="fragmentMetadataAll")
    private List<FragmentMetadata> fragmentMetadataAll = null;
    public static final String SERIALIZED_NAME_OPENED_AT_END_TIMESTAMP = "openedAtEndTimestamp";
    @SerializedName(value="openedAtEndTimestamp")
    private BigDecimal openedAtEndTimestamp;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Array queryType(Querytype queryType) {
        this.queryType = queryType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Querytype getQueryType() {
        return this.queryType;
    }

    public void setQueryType(Querytype queryType) {
        this.queryType = queryType;
    }

    public Array uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Array uri")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Array endTimestamp(BigDecimal endTimestamp) {
        this.endTimestamp = endTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1540471791873", value="Ending timestamp (epoch milliseconds) array is opened at")
    public BigDecimal getEndTimestamp() {
        return this.endTimestamp;
    }

    public void setEndTimestamp(BigDecimal endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public Array startTimestamp(BigDecimal startTimestamp) {
        this.startTimestamp = startTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1540471791873", value="Starting timestamp (epoch milliseconds) array is opened at")
    public BigDecimal getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(BigDecimal startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Array arraySchemaLatest(ArraySchema arraySchemaLatest) {
        this.arraySchemaLatest = arraySchemaLatest;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ArraySchema getArraySchemaLatest() {
        return this.arraySchemaLatest;
    }

    public void setArraySchemaLatest(ArraySchema arraySchemaLatest) {
        this.arraySchemaLatest = arraySchemaLatest;
    }

    public Array arraySchemasAll(ArraySchemaMap arraySchemasAll) {
        this.arraySchemasAll = arraySchemasAll;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ArraySchemaMap getArraySchemasAll() {
        return this.arraySchemasAll;
    }

    public void setArraySchemasAll(ArraySchemaMap arraySchemasAll) {
        this.arraySchemasAll = arraySchemasAll;
    }

    public Array arrayMetadata(ArrayMetadata arrayMetadata) {
        this.arrayMetadata = arrayMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ArrayMetadata getArrayMetadata() {
        return this.arrayMetadata;
    }

    public void setArrayMetadata(ArrayMetadata arrayMetadata) {
        this.arrayMetadata = arrayMetadata;
    }

    public Array nonEmptyDomain(NonEmptyDomainList nonEmptyDomain) {
        this.nonEmptyDomain = nonEmptyDomain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public NonEmptyDomainList getNonEmptyDomain() {
        return this.nonEmptyDomain;
    }

    public void setNonEmptyDomain(NonEmptyDomainList nonEmptyDomain) {
        this.nonEmptyDomain = nonEmptyDomain;
    }

    public Array arrayDirectory(ArrayDirectory arrayDirectory) {
        this.arrayDirectory = arrayDirectory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ArrayDirectory getArrayDirectory() {
        return this.arrayDirectory;
    }

    public void setArrayDirectory(ArrayDirectory arrayDirectory) {
        this.arrayDirectory = arrayDirectory;
    }

    public Array fragmentMetadataAll(List<FragmentMetadata> fragmentMetadataAll) {
        this.fragmentMetadataAll = fragmentMetadataAll;
        return this;
    }

    public Array addFragmentMetadataAllItem(FragmentMetadata fragmentMetadataAllItem) {
        if (this.fragmentMetadataAll == null) {
            this.fragmentMetadataAll = new ArrayList<FragmentMetadata>();
        }
        this.fragmentMetadataAll.add(fragmentMetadataAllItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="metadata for all fragments (for reads)")
    public List<FragmentMetadata> getFragmentMetadataAll() {
        return this.fragmentMetadataAll;
    }

    public void setFragmentMetadataAll(List<FragmentMetadata> fragmentMetadataAll) {
        this.fragmentMetadataAll = fragmentMetadataAll;
    }

    public Array openedAtEndTimestamp(BigDecimal openedAtEndTimestamp) {
        this.openedAtEndTimestamp = openedAtEndTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ending timestamp that the array was last opened at")
    public BigDecimal getOpenedAtEndTimestamp() {
        return this.openedAtEndTimestamp;
    }

    public void setOpenedAtEndTimestamp(BigDecimal openedAtEndTimestamp) {
        this.openedAtEndTimestamp = openedAtEndTimestamp;
    }

    public Array putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Array array = (Array)o;
        return Objects.equals((Object)this.queryType, (Object)array.queryType) && Objects.equals(this.uri, array.uri) && Objects.equals(this.endTimestamp, array.endTimestamp) && Objects.equals(this.startTimestamp, array.startTimestamp) && Objects.equals(this.arraySchemaLatest, array.arraySchemaLatest) && Objects.equals(this.arraySchemasAll, array.arraySchemasAll) && Objects.equals(this.arrayMetadata, array.arrayMetadata) && Objects.equals(this.nonEmptyDomain, array.nonEmptyDomain) && Objects.equals(this.arrayDirectory, array.arrayDirectory) && Objects.equals(this.fragmentMetadataAll, array.fragmentMetadataAll) && Objects.equals(this.openedAtEndTimestamp, array.openedAtEndTimestamp) && Objects.equals(this.additionalProperties, array.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.queryType, this.uri, this.endTimestamp, this.startTimestamp, this.arraySchemaLatest, this.arraySchemasAll, this.arrayMetadata, this.nonEmptyDomain, this.arrayDirectory, this.fragmentMetadataAll, this.openedAtEndTimestamp, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Array {\n");
        sb.append("    queryType: ").append(this.toIndentedString((Object)this.queryType)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    endTimestamp: ").append(this.toIndentedString(this.endTimestamp)).append("\n");
        sb.append("    startTimestamp: ").append(this.toIndentedString(this.startTimestamp)).append("\n");
        sb.append("    arraySchemaLatest: ").append(this.toIndentedString(this.arraySchemaLatest)).append("\n");
        sb.append("    arraySchemasAll: ").append(this.toIndentedString(this.arraySchemasAll)).append("\n");
        sb.append("    arrayMetadata: ").append(this.toIndentedString(this.arrayMetadata)).append("\n");
        sb.append("    nonEmptyDomain: ").append(this.toIndentedString(this.nonEmptyDomain)).append("\n");
        sb.append("    arrayDirectory: ").append(this.toIndentedString(this.arrayDirectory)).append("\n");
        sb.append("    fragmentMetadataAll: ").append(this.toIndentedString(this.fragmentMetadataAll)).append("\n");
        sb.append("    openedAtEndTimestamp: ").append(this.toIndentedString(this.openedAtEndTimestamp)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayfragmentMetadataAll;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Array is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URI) != null && !jsonObj.get(SERIALIZED_NAME_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URI).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ARRAY_SCHEMA_LATEST) != null) {
            ArraySchema.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ARRAY_SCHEMA_LATEST));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ARRAY_SCHEMAS_ALL) != null) {
            ArraySchemaMap.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ARRAY_SCHEMAS_ALL));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ARRAY_METADATA) != null) {
            ArrayMetadata.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ARRAY_METADATA));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_NON_EMPTY_DOMAIN) != null) {
            NonEmptyDomainList.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NON_EMPTY_DOMAIN));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ARRAY_DIRECTORY) != null) {
            ArrayDirectory.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ARRAY_DIRECTORY));
        }
        if ((jsonArrayfragmentMetadataAll = jsonObj.getAsJsonArray(SERIALIZED_NAME_FRAGMENT_METADATA_ALL)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FRAGMENT_METADATA_ALL).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `fragmentMetadataAll` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FRAGMENT_METADATA_ALL).toString()));
            }
            for (int i = 0; i < jsonArrayfragmentMetadataAll.size(); ++i) {
                FragmentMetadata.validateJsonObject(jsonArrayfragmentMetadataAll.get(i).getAsJsonObject());
            }
        }
    }

    public static Array fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, Array.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_QUERY_TYPE);
        openapiFields.add(SERIALIZED_NAME_URI);
        openapiFields.add(SERIALIZED_NAME_END_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_START_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_ARRAY_SCHEMA_LATEST);
        openapiFields.add(SERIALIZED_NAME_ARRAY_SCHEMAS_ALL);
        openapiFields.add(SERIALIZED_NAME_ARRAY_METADATA);
        openapiFields.add(SERIALIZED_NAME_NON_EMPTY_DOMAIN);
        openapiFields.add(SERIALIZED_NAME_ARRAY_DIRECTORY);
        openapiFields.add(SERIALIZED_NAME_FRAGMENT_METADATA_ALL);
        openapiFields.add(SERIALIZED_NAME_OPENED_AT_END_TIMESTAMP);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_QUERY_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_URI);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Array.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<Array> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(Array.class));
            return new TypeAdapter<Array>(){

                @Override
                public void write(JsonWriter out, Array value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public Array read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Array.validateJsonObject(jsonObj);
                    Array instance = (Array)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

