/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import io.tiledb.cloud.rest_api.v2.model.DeleteAndUpdateTileLocation;
import io.tiledb.cloud.rest_api.v2.model.TimestampedURI;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Array directory (for reads)")
public class ArrayDirectory {
    public static final String SERIALIZED_NAME_UNFILTERED_FRAGMENT_URIS = "unfilteredFragmentUris";
    @SerializedName(value="unfilteredFragmentUris")
    private List<String> unfilteredFragmentUris = null;
    public static final String SERIALIZED_NAME_CONSOLIDATED_COMMIT_URIS = "consolidatedCommitUris";
    @SerializedName(value="consolidatedCommitUris")
    private List<String> consolidatedCommitUris = null;
    public static final String SERIALIZED_NAME_ARRAY_SCHEMA_URIS = "arraySchemaUris";
    @SerializedName(value="arraySchemaUris")
    private List<String> arraySchemaUris = null;
    public static final String SERIALIZED_NAME_LATEST_ARRAY_SCHEMA_URI = "latestArraySchemaUri";
    @SerializedName(value="latestArraySchemaUri")
    private String latestArraySchemaUri;
    public static final String SERIALIZED_NAME_ARRAY_META_URIS_TO_VACUUM = "arrayMetaUrisToVacuum";
    @SerializedName(value="arrayMetaUrisToVacuum")
    private List<String> arrayMetaUrisToVacuum = null;
    public static final String SERIALIZED_NAME_ARRAY_META_VAC_URIS_TO_VACUUM = "arrayMetaVacUrisToVacuum";
    @SerializedName(value="arrayMetaVacUrisToVacuum")
    private List<String> arrayMetaVacUrisToVacuum = null;
    public static final String SERIALIZED_NAME_COMMIT_URIS_TO_CONSOLIDATE = "commitUrisToConsolidate";
    @SerializedName(value="commitUrisToConsolidate")
    private List<String> commitUrisToConsolidate = null;
    public static final String SERIALIZED_NAME_COMMIT_URIS_TO_VACUUM = "commitUrisToVacuum";
    @SerializedName(value="commitUrisToVacuum")
    private List<String> commitUrisToVacuum = null;
    public static final String SERIALIZED_NAME_CONSOLIDATED_COMMIT_URIS_TO_VACUUM = "consolidatedCommitUrisToVacuum";
    @SerializedName(value="consolidatedCommitUrisToVacuum")
    private List<String> consolidatedCommitUrisToVacuum = null;
    public static final String SERIALIZED_NAME_FRAGMENT_META_URIS = "fragmentMetaUris";
    @SerializedName(value="fragmentMetaUris")
    private List<String> fragmentMetaUris = null;
    public static final String SERIALIZED_NAME_TIMESTAMP_START = "timestampStart";
    @SerializedName(value="timestampStart")
    private BigDecimal timestampStart;
    public static final String SERIALIZED_NAME_TIMESTAMP_END = "timestampEnd";
    @SerializedName(value="timestampEnd")
    private BigDecimal timestampEnd;
    public static final String SERIALIZED_NAME_ARRAY_META_URIS = "arrayMetaUris";
    @SerializedName(value="arrayMetaUris")
    private List<TimestampedURI> arrayMetaUris = null;
    public static final String SERIALIZED_NAME_DELETE_AND_UPDATE_TILE_LOCATION = "deleteAndUpdateTileLocation";
    @SerializedName(value="deleteAndUpdateTileLocation")
    private List<DeleteAndUpdateTileLocation> deleteAndUpdateTileLocation = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ArrayDirectory unfilteredFragmentUris(List<String> unfilteredFragmentUris) {
        this.unfilteredFragmentUris = unfilteredFragmentUris;
        return this;
    }

    public ArrayDirectory addUnfilteredFragmentUrisItem(String unfilteredFragmentUrisItem) {
        if (this.unfilteredFragmentUris == null) {
            this.unfilteredFragmentUris = new ArrayList<String>();
        }
        this.unfilteredFragmentUris.add(unfilteredFragmentUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fragment URIs")
    public List<String> getUnfilteredFragmentUris() {
        return this.unfilteredFragmentUris;
    }

    public void setUnfilteredFragmentUris(List<String> unfilteredFragmentUris) {
        this.unfilteredFragmentUris = unfilteredFragmentUris;
    }

    public ArrayDirectory consolidatedCommitUris(List<String> consolidatedCommitUris) {
        this.consolidatedCommitUris = consolidatedCommitUris;
        return this;
    }

    public ArrayDirectory addConsolidatedCommitUrisItem(String consolidatedCommitUrisItem) {
        if (this.consolidatedCommitUris == null) {
            this.consolidatedCommitUris = new ArrayList<String>();
        }
        this.consolidatedCommitUris.add(consolidatedCommitUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="consolidated commit URI set")
    public List<String> getConsolidatedCommitUris() {
        return this.consolidatedCommitUris;
    }

    public void setConsolidatedCommitUris(List<String> consolidatedCommitUris) {
        this.consolidatedCommitUris = consolidatedCommitUris;
    }

    public ArrayDirectory arraySchemaUris(List<String> arraySchemaUris) {
        this.arraySchemaUris = arraySchemaUris;
        return this;
    }

    public ArrayDirectory addArraySchemaUrisItem(String arraySchemaUrisItem) {
        if (this.arraySchemaUris == null) {
            this.arraySchemaUris = new ArrayList<String>();
        }
        this.arraySchemaUris.add(arraySchemaUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URIs of all the array schema files")
    public List<String> getArraySchemaUris() {
        return this.arraySchemaUris;
    }

    public void setArraySchemaUris(List<String> arraySchemaUris) {
        this.arraySchemaUris = arraySchemaUris;
    }

    public ArrayDirectory latestArraySchemaUri(String latestArraySchemaUri) {
        this.latestArraySchemaUri = latestArraySchemaUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="latest array schema URI.")
    public String getLatestArraySchemaUri() {
        return this.latestArraySchemaUri;
    }

    public void setLatestArraySchemaUri(String latestArraySchemaUri) {
        this.latestArraySchemaUri = latestArraySchemaUri;
    }

    public ArrayDirectory arrayMetaUrisToVacuum(List<String> arrayMetaUrisToVacuum) {
        this.arrayMetaUrisToVacuum = arrayMetaUrisToVacuum;
        return this;
    }

    public ArrayDirectory addArrayMetaUrisToVacuumItem(String arrayMetaUrisToVacuumItem) {
        if (this.arrayMetaUrisToVacuum == null) {
            this.arrayMetaUrisToVacuum = new ArrayList<String>();
        }
        this.arrayMetaUrisToVacuum.add(arrayMetaUrisToVacuumItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the array metadata files to vacuum")
    public List<String> getArrayMetaUrisToVacuum() {
        return this.arrayMetaUrisToVacuum;
    }

    public void setArrayMetaUrisToVacuum(List<String> arrayMetaUrisToVacuum) {
        this.arrayMetaUrisToVacuum = arrayMetaUrisToVacuum;
    }

    public ArrayDirectory arrayMetaVacUrisToVacuum(List<String> arrayMetaVacUrisToVacuum) {
        this.arrayMetaVacUrisToVacuum = arrayMetaVacUrisToVacuum;
        return this;
    }

    public ArrayDirectory addArrayMetaVacUrisToVacuumItem(String arrayMetaVacUrisToVacuumItem) {
        if (this.arrayMetaVacUrisToVacuum == null) {
            this.arrayMetaVacUrisToVacuum = new ArrayList<String>();
        }
        this.arrayMetaVacUrisToVacuum.add(arrayMetaVacUrisToVacuumItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the array metadata vac files to vacuum")
    public List<String> getArrayMetaVacUrisToVacuum() {
        return this.arrayMetaVacUrisToVacuum;
    }

    public void setArrayMetaVacUrisToVacuum(List<String> arrayMetaVacUrisToVacuum) {
        this.arrayMetaVacUrisToVacuum = arrayMetaVacUrisToVacuum;
    }

    public ArrayDirectory commitUrisToConsolidate(List<String> commitUrisToConsolidate) {
        this.commitUrisToConsolidate = commitUrisToConsolidate;
        return this;
    }

    public ArrayDirectory addCommitUrisToConsolidateItem(String commitUrisToConsolidateItem) {
        if (this.commitUrisToConsolidate == null) {
            this.commitUrisToConsolidate = new ArrayList<String>();
        }
        this.commitUrisToConsolidate.add(commitUrisToConsolidateItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the commit files to consolidate")
    public List<String> getCommitUrisToConsolidate() {
        return this.commitUrisToConsolidate;
    }

    public void setCommitUrisToConsolidate(List<String> commitUrisToConsolidate) {
        this.commitUrisToConsolidate = commitUrisToConsolidate;
    }

    public ArrayDirectory commitUrisToVacuum(List<String> commitUrisToVacuum) {
        this.commitUrisToVacuum = commitUrisToVacuum;
        return this;
    }

    public ArrayDirectory addCommitUrisToVacuumItem(String commitUrisToVacuumItem) {
        if (this.commitUrisToVacuum == null) {
            this.commitUrisToVacuum = new ArrayList<String>();
        }
        this.commitUrisToVacuum.add(commitUrisToVacuumItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the commit files to vacuum")
    public List<String> getCommitUrisToVacuum() {
        return this.commitUrisToVacuum;
    }

    public void setCommitUrisToVacuum(List<String> commitUrisToVacuum) {
        this.commitUrisToVacuum = commitUrisToVacuum;
    }

    public ArrayDirectory consolidatedCommitUrisToVacuum(List<String> consolidatedCommitUrisToVacuum) {
        this.consolidatedCommitUrisToVacuum = consolidatedCommitUrisToVacuum;
        return this;
    }

    public ArrayDirectory addConsolidatedCommitUrisToVacuumItem(String consolidatedCommitUrisToVacuumItem) {
        if (this.consolidatedCommitUrisToVacuum == null) {
            this.consolidatedCommitUrisToVacuum = new ArrayList<String>();
        }
        this.consolidatedCommitUrisToVacuum.add(consolidatedCommitUrisToVacuumItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the consolidated commit files to vacuum")
    public List<String> getConsolidatedCommitUrisToVacuum() {
        return this.consolidatedCommitUrisToVacuum;
    }

    public void setConsolidatedCommitUrisToVacuum(List<String> consolidatedCommitUrisToVacuum) {
        this.consolidatedCommitUrisToVacuum = consolidatedCommitUrisToVacuum;
    }

    public ArrayDirectory fragmentMetaUris(List<String> fragmentMetaUris) {
        this.fragmentMetaUris = fragmentMetaUris;
        return this;
    }

    public ArrayDirectory addFragmentMetaUrisItem(String fragmentMetaUrisItem) {
        if (this.fragmentMetaUris == null) {
            this.fragmentMetaUris = new ArrayList<String>();
        }
        this.fragmentMetaUris.add(fragmentMetaUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the URIs of the consolidated fragment metadata files")
    public List<String> getFragmentMetaUris() {
        return this.fragmentMetaUris;
    }

    public void setFragmentMetaUris(List<String> fragmentMetaUris) {
        this.fragmentMetaUris = fragmentMetaUris;
    }

    public ArrayDirectory timestampStart(BigDecimal timestampStart) {
        this.timestampStart = timestampStart;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only the files created after timestamp_start are listed")
    public BigDecimal getTimestampStart() {
        return this.timestampStart;
    }

    public void setTimestampStart(BigDecimal timestampStart) {
        this.timestampStart = timestampStart;
    }

    public ArrayDirectory timestampEnd(BigDecimal timestampEnd) {
        this.timestampEnd = timestampEnd;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only the files created before timestamp_end are listed")
    public BigDecimal getTimestampEnd() {
        return this.timestampEnd;
    }

    public void setTimestampEnd(BigDecimal timestampEnd) {
        this.timestampEnd = timestampEnd;
    }

    public ArrayDirectory arrayMetaUris(List<TimestampedURI> arrayMetaUris) {
        this.arrayMetaUris = arrayMetaUris;
        return this;
    }

    public ArrayDirectory addArrayMetaUrisItem(TimestampedURI arrayMetaUrisItem) {
        if (this.arrayMetaUris == null) {
            this.arrayMetaUris = new ArrayList<TimestampedURI>();
        }
        this.arrayMetaUris.add(arrayMetaUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the timestamped filtered array metadata URIs, after removing the ones that need to be vacuumed and those that do not fall within")
    public List<TimestampedURI> getArrayMetaUris() {
        return this.arrayMetaUris;
    }

    public void setArrayMetaUris(List<TimestampedURI> arrayMetaUris) {
        this.arrayMetaUris = arrayMetaUris;
    }

    public ArrayDirectory deleteAndUpdateTileLocation(List<DeleteAndUpdateTileLocation> deleteAndUpdateTileLocation) {
        this.deleteAndUpdateTileLocation = deleteAndUpdateTileLocation;
        return this;
    }

    public ArrayDirectory addDeleteAndUpdateTileLocationItem(DeleteAndUpdateTileLocation deleteAndUpdateTileLocationItem) {
        if (this.deleteAndUpdateTileLocation == null) {
            this.deleteAndUpdateTileLocation = new ArrayList<DeleteAndUpdateTileLocation>();
        }
        this.deleteAndUpdateTileLocation.add(deleteAndUpdateTileLocationItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the location of delete tiles")
    public List<DeleteAndUpdateTileLocation> getDeleteAndUpdateTileLocation() {
        return this.deleteAndUpdateTileLocation;
    }

    public void setDeleteAndUpdateTileLocation(List<DeleteAndUpdateTileLocation> deleteAndUpdateTileLocation) {
        this.deleteAndUpdateTileLocation = deleteAndUpdateTileLocation;
    }

    public ArrayDirectory putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayDirectory arrayDirectory = (ArrayDirectory)o;
        return Objects.equals(this.unfilteredFragmentUris, arrayDirectory.unfilteredFragmentUris) && Objects.equals(this.consolidatedCommitUris, arrayDirectory.consolidatedCommitUris) && Objects.equals(this.arraySchemaUris, arrayDirectory.arraySchemaUris) && Objects.equals(this.latestArraySchemaUri, arrayDirectory.latestArraySchemaUri) && Objects.equals(this.arrayMetaUrisToVacuum, arrayDirectory.arrayMetaUrisToVacuum) && Objects.equals(this.arrayMetaVacUrisToVacuum, arrayDirectory.arrayMetaVacUrisToVacuum) && Objects.equals(this.commitUrisToConsolidate, arrayDirectory.commitUrisToConsolidate) && Objects.equals(this.commitUrisToVacuum, arrayDirectory.commitUrisToVacuum) && Objects.equals(this.consolidatedCommitUrisToVacuum, arrayDirectory.consolidatedCommitUrisToVacuum) && Objects.equals(this.fragmentMetaUris, arrayDirectory.fragmentMetaUris) && Objects.equals(this.timestampStart, arrayDirectory.timestampStart) && Objects.equals(this.timestampEnd, arrayDirectory.timestampEnd) && Objects.equals(this.arrayMetaUris, arrayDirectory.arrayMetaUris) && Objects.equals(this.deleteAndUpdateTileLocation, arrayDirectory.deleteAndUpdateTileLocation) && Objects.equals(this.additionalProperties, arrayDirectory.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.unfilteredFragmentUris, this.consolidatedCommitUris, this.arraySchemaUris, this.latestArraySchemaUri, this.arrayMetaUrisToVacuum, this.arrayMetaVacUrisToVacuum, this.commitUrisToConsolidate, this.commitUrisToVacuum, this.consolidatedCommitUrisToVacuum, this.fragmentMetaUris, this.timestampStart, this.timestampEnd, this.arrayMetaUris, this.deleteAndUpdateTileLocation, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArrayDirectory {\n");
        sb.append("    unfilteredFragmentUris: ").append(this.toIndentedString(this.unfilteredFragmentUris)).append("\n");
        sb.append("    consolidatedCommitUris: ").append(this.toIndentedString(this.consolidatedCommitUris)).append("\n");
        sb.append("    arraySchemaUris: ").append(this.toIndentedString(this.arraySchemaUris)).append("\n");
        sb.append("    latestArraySchemaUri: ").append(this.toIndentedString(this.latestArraySchemaUri)).append("\n");
        sb.append("    arrayMetaUrisToVacuum: ").append(this.toIndentedString(this.arrayMetaUrisToVacuum)).append("\n");
        sb.append("    arrayMetaVacUrisToVacuum: ").append(this.toIndentedString(this.arrayMetaVacUrisToVacuum)).append("\n");
        sb.append("    commitUrisToConsolidate: ").append(this.toIndentedString(this.commitUrisToConsolidate)).append("\n");
        sb.append("    commitUrisToVacuum: ").append(this.toIndentedString(this.commitUrisToVacuum)).append("\n");
        sb.append("    consolidatedCommitUrisToVacuum: ").append(this.toIndentedString(this.consolidatedCommitUrisToVacuum)).append("\n");
        sb.append("    fragmentMetaUris: ").append(this.toIndentedString(this.fragmentMetaUris)).append("\n");
        sb.append("    timestampStart: ").append(this.toIndentedString(this.timestampStart)).append("\n");
        sb.append("    timestampEnd: ").append(this.toIndentedString(this.timestampEnd)).append("\n");
        sb.append("    arrayMetaUris: ").append(this.toIndentedString(this.arrayMetaUris)).append("\n");
        sb.append("    deleteAndUpdateTileLocation: ").append(this.toIndentedString(this.deleteAndUpdateTileLocation)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraydeleteAndUpdateTileLocation;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ArrayDirectory is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNFILTERED_FRAGMENT_URIS) != null && !jsonObj.get(SERIALIZED_NAME_UNFILTERED_FRAGMENT_URIS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `unfilteredFragmentUris` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNFILTERED_FRAGMENT_URIS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONSOLIDATED_COMMIT_URIS) != null && !jsonObj.get(SERIALIZED_NAME_CONSOLIDATED_COMMIT_URIS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `consolidatedCommitUris` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONSOLIDATED_COMMIT_URIS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARRAY_SCHEMA_URIS) != null && !jsonObj.get(SERIALIZED_NAME_ARRAY_SCHEMA_URIS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `arraySchemaUris` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARRAY_SCHEMA_URIS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LATEST_ARRAY_SCHEMA_URI) != null && !jsonObj.get(SERIALIZED_NAME_LATEST_ARRAY_SCHEMA_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `latestArraySchemaUri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LATEST_ARRAY_SCHEMA_URI).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARRAY_META_URIS_TO_VACUUM) != null && !jsonObj.get(SERIALIZED_NAME_ARRAY_META_URIS_TO_VACUUM).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `arrayMetaUrisToVacuum` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARRAY_META_URIS_TO_VACUUM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ARRAY_META_VAC_URIS_TO_VACUUM) != null && !jsonObj.get(SERIALIZED_NAME_ARRAY_META_VAC_URIS_TO_VACUUM).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `arrayMetaVacUrisToVacuum` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARRAY_META_VAC_URIS_TO_VACUUM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMIT_URIS_TO_CONSOLIDATE) != null && !jsonObj.get(SERIALIZED_NAME_COMMIT_URIS_TO_CONSOLIDATE).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `commitUrisToConsolidate` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMIT_URIS_TO_CONSOLIDATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMIT_URIS_TO_VACUUM) != null && !jsonObj.get(SERIALIZED_NAME_COMMIT_URIS_TO_VACUUM).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `commitUrisToVacuum` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMIT_URIS_TO_VACUUM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONSOLIDATED_COMMIT_URIS_TO_VACUUM) != null && !jsonObj.get(SERIALIZED_NAME_CONSOLIDATED_COMMIT_URIS_TO_VACUUM).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `consolidatedCommitUrisToVacuum` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONSOLIDATED_COMMIT_URIS_TO_VACUUM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FRAGMENT_META_URIS) != null && !jsonObj.get(SERIALIZED_NAME_FRAGMENT_META_URIS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `fragmentMetaUris` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FRAGMENT_META_URIS).toString()));
        }
        JsonArray jsonArrayarrayMetaUris = jsonObj.getAsJsonArray(SERIALIZED_NAME_ARRAY_META_URIS);
        if (jsonArrayarrayMetaUris != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ARRAY_META_URIS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `arrayMetaUris` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARRAY_META_URIS).toString()));
            }
            for (int i = 0; i < jsonArrayarrayMetaUris.size(); ++i) {
                TimestampedURI.validateJsonObject(jsonArrayarrayMetaUris.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraydeleteAndUpdateTileLocation = jsonObj.getAsJsonArray(SERIALIZED_NAME_DELETE_AND_UPDATE_TILE_LOCATION)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DELETE_AND_UPDATE_TILE_LOCATION).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `deleteAndUpdateTileLocation` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DELETE_AND_UPDATE_TILE_LOCATION).toString()));
            }
            for (int i = 0; i < jsonArraydeleteAndUpdateTileLocation.size(); ++i) {
                DeleteAndUpdateTileLocation.validateJsonObject(jsonArraydeleteAndUpdateTileLocation.get(i).getAsJsonObject());
            }
        }
    }

    public static ArrayDirectory fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, ArrayDirectory.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_UNFILTERED_FRAGMENT_URIS);
        openapiFields.add(SERIALIZED_NAME_CONSOLIDATED_COMMIT_URIS);
        openapiFields.add(SERIALIZED_NAME_ARRAY_SCHEMA_URIS);
        openapiFields.add(SERIALIZED_NAME_LATEST_ARRAY_SCHEMA_URI);
        openapiFields.add(SERIALIZED_NAME_ARRAY_META_URIS_TO_VACUUM);
        openapiFields.add(SERIALIZED_NAME_ARRAY_META_VAC_URIS_TO_VACUUM);
        openapiFields.add(SERIALIZED_NAME_COMMIT_URIS_TO_CONSOLIDATE);
        openapiFields.add(SERIALIZED_NAME_COMMIT_URIS_TO_VACUUM);
        openapiFields.add(SERIALIZED_NAME_CONSOLIDATED_COMMIT_URIS_TO_VACUUM);
        openapiFields.add(SERIALIZED_NAME_FRAGMENT_META_URIS);
        openapiFields.add(SERIALIZED_NAME_TIMESTAMP_START);
        openapiFields.add(SERIALIZED_NAME_TIMESTAMP_END);
        openapiFields.add(SERIALIZED_NAME_ARRAY_META_URIS);
        openapiFields.add(SERIALIZED_NAME_DELETE_AND_UPDATE_TILE_LOCATION);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ArrayDirectory.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<ArrayDirectory> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(ArrayDirectory.class));
            return new TypeAdapter<ArrayDirectory>(){

                @Override
                public void write(JsonWriter out, ArrayDirectory value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public ArrayDirectory read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ArrayDirectory.validateJsonObject(jsonObj);
                    ArrayDirectory instance = (ArrayDirectory)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

