/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import io.tiledb.cloud.rest_api.v2.model.ArrayType;
import io.tiledb.cloud.rest_api.v2.model.Attribute;
import io.tiledb.cloud.rest_api.v2.model.Domain;
import io.tiledb.cloud.rest_api.v2.model.FilterPipeline;
import io.tiledb.cloud.rest_api.v2.model.Layout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="ArraySchema during creation or retrieval")
public class ArraySchema {
    public static final String SERIALIZED_NAME_URI = "uri";
    @SerializedName(value="uri")
    private String uri;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private List<Integer> version = new ArrayList<Integer>();
    public static final String SERIALIZED_NAME_ARRAY_TYPE = "arrayType";
    @SerializedName(value="arrayType")
    private ArrayType arrayType;
    public static final String SERIALIZED_NAME_TILE_ORDER = "tileOrder";
    @SerializedName(value="tileOrder")
    private Layout tileOrder;
    public static final String SERIALIZED_NAME_CELL_ORDER = "cellOrder";
    @SerializedName(value="cellOrder")
    private Layout cellOrder;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private Integer capacity;
    public static final String SERIALIZED_NAME_COORDS_FILTER_PIPELINE = "coordsFilterPipeline";
    @SerializedName(value="coordsFilterPipeline")
    private FilterPipeline coordsFilterPipeline;
    public static final String SERIALIZED_NAME_OFFSET_FILTER_PIPELINE = "offsetFilterPipeline";
    @SerializedName(value="offsetFilterPipeline")
    private FilterPipeline offsetFilterPipeline;
    public static final String SERIALIZED_NAME_VALIDITY_FILTER_PIPELINE = "validityFilterPipeline";
    @SerializedName(value="validityFilterPipeline")
    private FilterPipeline validityFilterPipeline;
    public static final String SERIALIZED_NAME_DOMAIN = "domain";
    @SerializedName(value="domain")
    private Domain domain;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private List<Attribute> attributes = new ArrayList<Attribute>();
    public static final String SERIALIZED_NAME_ALLOWS_DUPLICATES = "allowsDuplicates";
    @SerializedName(value="allowsDuplicates")
    private Boolean allowsDuplicates;
    public static final String SERIALIZED_NAME_TIMESTAMP_RANGE = "timestampRange";
    @SerializedName(value="timestampRange")
    private List<Integer> timestampRange = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ArraySchema uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="s3://<bucket>/test_array", value="URI of schema")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public ArraySchema name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="name of schema")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArraySchema version(List<Integer> version) {
        this.version = version;
        return this;
    }

    public ArraySchema addVersionItem(Integer versionItem) {
        this.version.add(versionItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[1, 3, 0]", required=true, value="file format version")
    public List<Integer> getVersion() {
        return this.version;
    }

    public void setVersion(List<Integer> version) {
        this.version = version;
    }

    public ArraySchema arrayType(ArrayType arrayType) {
        this.arrayType = arrayType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public ArrayType getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(ArrayType arrayType) {
        this.arrayType = arrayType;
    }

    public ArraySchema tileOrder(Layout tileOrder) {
        this.tileOrder = tileOrder;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Layout getTileOrder() {
        return this.tileOrder;
    }

    public void setTileOrder(Layout tileOrder) {
        this.tileOrder = tileOrder;
    }

    public ArraySchema cellOrder(Layout cellOrder) {
        this.cellOrder = cellOrder;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Layout getCellOrder() {
        return this.cellOrder;
    }

    public void setCellOrder(Layout cellOrder) {
        this.cellOrder = cellOrder;
    }

    public ArraySchema capacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="100000", required=true, value="Capacity of array")
    public Integer getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public ArraySchema coordsFilterPipeline(FilterPipeline coordsFilterPipeline) {
        this.coordsFilterPipeline = coordsFilterPipeline;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public FilterPipeline getCoordsFilterPipeline() {
        return this.coordsFilterPipeline;
    }

    public void setCoordsFilterPipeline(FilterPipeline coordsFilterPipeline) {
        this.coordsFilterPipeline = coordsFilterPipeline;
    }

    public ArraySchema offsetFilterPipeline(FilterPipeline offsetFilterPipeline) {
        this.offsetFilterPipeline = offsetFilterPipeline;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public FilterPipeline getOffsetFilterPipeline() {
        return this.offsetFilterPipeline;
    }

    public void setOffsetFilterPipeline(FilterPipeline offsetFilterPipeline) {
        this.offsetFilterPipeline = offsetFilterPipeline;
    }

    public ArraySchema validityFilterPipeline(FilterPipeline validityFilterPipeline) {
        this.validityFilterPipeline = validityFilterPipeline;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FilterPipeline getValidityFilterPipeline() {
        return this.validityFilterPipeline;
    }

    public void setValidityFilterPipeline(FilterPipeline validityFilterPipeline) {
        this.validityFilterPipeline = validityFilterPipeline;
    }

    public ArraySchema domain(Domain domain) {
        this.domain = domain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public ArraySchema attributes(List<Attribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ArraySchema addAttributesItem(Attribute attributesItem) {
        this.attributes.add(attributesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Attributes of array")
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public ArraySchema allowsDuplicates(Boolean allowsDuplicates) {
        this.allowsDuplicates = allowsDuplicates;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="True if the array allows coordinate duplicates. Applicable only to sparse arrays.")
    public Boolean getAllowsDuplicates() {
        return this.allowsDuplicates;
    }

    public void setAllowsDuplicates(Boolean allowsDuplicates) {
        this.allowsDuplicates = allowsDuplicates;
    }

    public ArraySchema timestampRange(List<Integer> timestampRange) {
        this.timestampRange = timestampRange;
        return this;
    }

    public ArraySchema addTimestampRangeItem(Integer timestampRangeItem) {
        if (this.timestampRange == null) {
            this.timestampRange = new ArrayList<Integer>();
        }
        this.timestampRange.add(timestampRangeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of sizes per range")
    public List<Integer> getTimestampRange() {
        return this.timestampRange;
    }

    public void setTimestampRange(List<Integer> timestampRange) {
        this.timestampRange = timestampRange;
    }

    public ArraySchema putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArraySchema arraySchema = (ArraySchema)o;
        return Objects.equals(this.uri, arraySchema.uri) && Objects.equals(this.name, arraySchema.name) && Objects.equals(this.version, arraySchema.version) && Objects.equals((Object)this.arrayType, (Object)arraySchema.arrayType) && Objects.equals((Object)this.tileOrder, (Object)arraySchema.tileOrder) && Objects.equals((Object)this.cellOrder, (Object)arraySchema.cellOrder) && Objects.equals(this.capacity, arraySchema.capacity) && Objects.equals(this.coordsFilterPipeline, arraySchema.coordsFilterPipeline) && Objects.equals(this.offsetFilterPipeline, arraySchema.offsetFilterPipeline) && Objects.equals(this.validityFilterPipeline, arraySchema.validityFilterPipeline) && Objects.equals(this.domain, arraySchema.domain) && Objects.equals(this.attributes, arraySchema.attributes) && Objects.equals(this.allowsDuplicates, arraySchema.allowsDuplicates) && Objects.equals(this.timestampRange, arraySchema.timestampRange) && Objects.equals(this.additionalProperties, arraySchema.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uri, this.name, this.version, this.arrayType, this.tileOrder, this.cellOrder, this.capacity, this.coordsFilterPipeline, this.offsetFilterPipeline, this.validityFilterPipeline, this.domain, this.attributes, this.allowsDuplicates, this.timestampRange, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ArraySchema {\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    arrayType: ").append(this.toIndentedString((Object)this.arrayType)).append("\n");
        sb.append("    tileOrder: ").append(this.toIndentedString((Object)this.tileOrder)).append("\n");
        sb.append("    cellOrder: ").append(this.toIndentedString((Object)this.cellOrder)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    coordsFilterPipeline: ").append(this.toIndentedString(this.coordsFilterPipeline)).append("\n");
        sb.append("    offsetFilterPipeline: ").append(this.toIndentedString(this.offsetFilterPipeline)).append("\n");
        sb.append("    validityFilterPipeline: ").append(this.toIndentedString(this.validityFilterPipeline)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    allowsDuplicates: ").append(this.toIndentedString(this.allowsDuplicates)).append("\n");
        sb.append("    timestampRange: ").append(this.toIndentedString(this.timestampRange)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayattributes;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ArraySchema is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URI) != null && !jsonObj.get(SERIALIZED_NAME_URI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URI).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `version` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_COORDS_FILTER_PIPELINE) != null) {
            FilterPipeline.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_COORDS_FILTER_PIPELINE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_OFFSET_FILTER_PIPELINE) != null) {
            FilterPipeline.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_OFFSET_FILTER_PIPELINE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_VALIDITY_FILTER_PIPELINE) != null) {
            FilterPipeline.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_VALIDITY_FILTER_PIPELINE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DOMAIN) != null) {
            Domain.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DOMAIN));
        }
        if ((jsonArrayattributes = jsonObj.getAsJsonArray(SERIALIZED_NAME_ATTRIBUTES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `attributes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).toString()));
            }
            for (int i = 0; i < jsonArrayattributes.size(); ++i) {
                Attribute.validateJsonObject(jsonArrayattributes.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TIMESTAMP_RANGE) != null && !jsonObj.get(SERIALIZED_NAME_TIMESTAMP_RANGE).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `timestampRange` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIMESTAMP_RANGE).toString()));
        }
    }

    public static ArraySchema fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, ArraySchema.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_URI);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_ARRAY_TYPE);
        openapiFields.add(SERIALIZED_NAME_TILE_ORDER);
        openapiFields.add(SERIALIZED_NAME_CELL_ORDER);
        openapiFields.add(SERIALIZED_NAME_CAPACITY);
        openapiFields.add(SERIALIZED_NAME_COORDS_FILTER_PIPELINE);
        openapiFields.add(SERIALIZED_NAME_OFFSET_FILTER_PIPELINE);
        openapiFields.add(SERIALIZED_NAME_VALIDITY_FILTER_PIPELINE);
        openapiFields.add(SERIALIZED_NAME_DOMAIN);
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTES);
        openapiFields.add(SERIALIZED_NAME_ALLOWS_DUPLICATES);
        openapiFields.add(SERIALIZED_NAME_TIMESTAMP_RANGE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_ARRAY_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_TILE_ORDER);
        openapiRequiredFields.add(SERIALIZED_NAME_CELL_ORDER);
        openapiRequiredFields.add(SERIALIZED_NAME_CAPACITY);
        openapiRequiredFields.add(SERIALIZED_NAME_COORDS_FILTER_PIPELINE);
        openapiRequiredFields.add(SERIALIZED_NAME_OFFSET_FILTER_PIPELINE);
        openapiRequiredFields.add(SERIALIZED_NAME_DOMAIN);
        openapiRequiredFields.add(SERIALIZED_NAME_ATTRIBUTES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ArraySchema.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<ArraySchema> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(ArraySchema.class));
            return new TypeAdapter<ArraySchema>(){

                @Override
                public void write(JsonWriter out, ArraySchema value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public ArraySchema read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ArraySchema.validateJsonObject(jsonObj);
                    ArraySchema instance = (ArraySchema)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

