/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum AssetType {
    ARRAY("array"),
    NOTEBOOK("notebook"),
    DASHBOARD("dashboard"),
    USER_DEFINED_FUNCTION("user_defined_function"),
    ML_MODEL("ml_model"),
    FILE("file"),
    REGISTERED_TASK_GRAPH("registered_task_graph"),
    GROUP("group"),
    VCF("vcf"),
    SOMA("soma"),
    POINTCLOUD("pointcloud"),
    BIOIMG("bioimg"),
    GEOMETRY("geometry"),
    RASTER("raster"),
    VECTOR_SEARCH("vector_search");

    private String value;

    private AssetType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssetType fromValue(String value) {
        for (AssetType b : AssetType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter
    extends TypeAdapter<AssetType> {
        @Override
        public void write(JsonWriter jsonWriter, AssetType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        @Override
        public AssetType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return AssetType.fromValue(value);
        }
    }
}

