/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import io.tiledb.cloud.rest_api.v2.model.Datatype;
import io.tiledb.cloud.rest_api.v2.model.FilterPipeline;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Attribute of array")
public class Attribute {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private Datatype type;
    public static final String SERIALIZED_NAME_FILTER_PIPELINE = "filterPipeline";
    @SerializedName(value="filterPipeline")
    private FilterPipeline filterPipeline;
    public static final String SERIALIZED_NAME_CELL_VAL_NUM = "cellValNum";
    @SerializedName(value="cellValNum")
    private Integer cellValNum;
    public static final String SERIALIZED_NAME_NULLABLE = "nullable";
    @SerializedName(value="nullable")
    private Boolean nullable;
    public static final String SERIALIZED_NAME_FILL_VALUE_VALIDITY = "fillValueValidity";
    @SerializedName(value="fillValueValidity")
    private Boolean fillValueValidity;
    public static final String SERIALIZED_NAME_FILL_VALUE = "fillValue";
    @SerializedName(value="fillValue")
    private List<Integer> fillValue = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Attribute name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="attribute1", required=true, value="Attribute name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Attribute type(Datatype type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Datatype getType() {
        return this.type;
    }

    public void setType(Datatype type) {
        this.type = type;
    }

    public Attribute filterPipeline(FilterPipeline filterPipeline) {
        this.filterPipeline = filterPipeline;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public FilterPipeline getFilterPipeline() {
        return this.filterPipeline;
    }

    public void setFilterPipeline(FilterPipeline filterPipeline) {
        this.filterPipeline = filterPipeline;
    }

    public Attribute cellValNum(Integer cellValNum) {
        this.cellValNum = cellValNum;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="Attribute number of values per cell")
    public Integer getCellValNum() {
        return this.cellValNum;
    }

    public void setCellValNum(Integer cellValNum) {
        this.cellValNum = cellValNum;
    }

    public Attribute nullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Is attribute nullable")
    public Boolean getNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public Attribute fillValueValidity(Boolean fillValueValidity) {
        this.fillValueValidity = fillValueValidity;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Default validity fill value for nullable attributes")
    public Boolean getFillValueValidity() {
        return this.fillValueValidity;
    }

    public void setFillValueValidity(Boolean fillValueValidity) {
        this.fillValueValidity = fillValueValidity;
    }

    public Attribute fillValue(List<Integer> fillValue) {
        this.fillValue = fillValue;
        return this;
    }

    public Attribute addFillValueItem(Integer fillValueItem) {
        if (this.fillValue == null) {
            this.fillValue = new ArrayList<Integer>();
        }
        this.fillValue.add(fillValueItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default fill value")
    public List<Integer> getFillValue() {
        return this.fillValue;
    }

    public void setFillValue(List<Integer> fillValue) {
        this.fillValue = fillValue;
    }

    public Attribute putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.name, attribute.name) && Objects.equals((Object)this.type, (Object)attribute.type) && Objects.equals(this.filterPipeline, attribute.filterPipeline) && Objects.equals(this.cellValNum, attribute.cellValNum) && Objects.equals(this.nullable, attribute.nullable) && Objects.equals(this.fillValueValidity, attribute.fillValueValidity) && Objects.equals(this.fillValue, attribute.fillValue) && Objects.equals(this.additionalProperties, attribute.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.filterPipeline, this.cellValNum, this.nullable, this.fillValueValidity, this.fillValue, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Attribute {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    filterPipeline: ").append(this.toIndentedString(this.filterPipeline)).append("\n");
        sb.append("    cellValNum: ").append(this.toIndentedString(this.cellValNum)).append("\n");
        sb.append("    nullable: ").append(this.toIndentedString(this.nullable)).append("\n");
        sb.append("    fillValueValidity: ").append(this.toIndentedString(this.fillValueValidity)).append("\n");
        sb.append("    fillValue: ").append(this.toIndentedString(this.fillValue)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Attribute is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FILTER_PIPELINE) != null) {
            FilterPipeline.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FILTER_PIPELINE));
        }
        if (jsonObj.get(SERIALIZED_NAME_FILL_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_FILL_VALUE).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `fillValue` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FILL_VALUE).toString()));
        }
    }

    public static Attribute fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, Attribute.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_FILTER_PIPELINE);
        openapiFields.add(SERIALIZED_NAME_CELL_VAL_NUM);
        openapiFields.add(SERIALIZED_NAME_NULLABLE);
        openapiFields.add(SERIALIZED_NAME_FILL_VALUE_VALIDITY);
        openapiFields.add(SERIALIZED_NAME_FILL_VALUE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_FILTER_PIPELINE);
        openapiRequiredFields.add(SERIALIZED_NAME_CELL_VAL_NUM);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Attribute.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<Attribute> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(Attribute.class));
            return new TypeAdapter<Attribute>(){

                @Override
                public void write(JsonWriter out, Attribute value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public Attribute read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Attribute.validateJsonObject(jsonObj);
                    Attribute instance = (Attribute)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

