/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="object representing buffer size of an attribute")
public class AttributeBufferSize {
    public static final String SERIALIZED_NAME_ATTRIBUTE = "attribute";
    @SerializedName(value="attribute")
    private String attribute;
    public static final String SERIALIZED_NAME_OFFSET_BYTES = "offsetBytes";
    @SerializedName(value="offsetBytes")
    private Integer offsetBytes;
    public static final String SERIALIZED_NAME_DATA_BYTES = "dataBytes";
    @SerializedName(value="dataBytes")
    private Integer dataBytes;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AttributeBufferSize attribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="name of attribute")
    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public AttributeBufferSize offsetBytes(Integer offsetBytes) {
        this.offsetBytes = offsetBytes;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="buffer size (in bytes) of offset buffer")
    public Integer getOffsetBytes() {
        return this.offsetBytes;
    }

    public void setOffsetBytes(Integer offsetBytes) {
        this.offsetBytes = offsetBytes;
    }

    public AttributeBufferSize dataBytes(Integer dataBytes) {
        this.dataBytes = dataBytes;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="buffer size (in bytes) of data buffer")
    public Integer getDataBytes() {
        return this.dataBytes;
    }

    public void setDataBytes(Integer dataBytes) {
        this.dataBytes = dataBytes;
    }

    public AttributeBufferSize putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeBufferSize attributeBufferSize = (AttributeBufferSize)o;
        return Objects.equals(this.attribute, attributeBufferSize.attribute) && Objects.equals(this.offsetBytes, attributeBufferSize.offsetBytes) && Objects.equals(this.dataBytes, attributeBufferSize.dataBytes) && Objects.equals(this.additionalProperties, attributeBufferSize.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attribute, this.offsetBytes, this.dataBytes, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttributeBufferSize {\n");
        sb.append("    attribute: ").append(this.toIndentedString(this.attribute)).append("\n");
        sb.append("    offsetBytes: ").append(this.toIndentedString(this.offsetBytes)).append("\n");
        sb.append("    dataBytes: ").append(this.toIndentedString(this.dataBytes)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AttributeBufferSize is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ATTRIBUTE) != null && !jsonObj.get(SERIALIZED_NAME_ATTRIBUTE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `attribute` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ATTRIBUTE).toString()));
        }
    }

    public static AttributeBufferSize fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, AttributeBufferSize.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTE);
        openapiFields.add(SERIALIZED_NAME_OFFSET_BYTES);
        openapiFields.add(SERIALIZED_NAME_DATA_BYTES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ATTRIBUTE);
        openapiRequiredFields.add(SERIALIZED_NAME_OFFSET_BYTES);
        openapiRequiredFields.add(SERIALIZED_NAME_DATA_BYTES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AttributeBufferSize.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<AttributeBufferSize> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(AttributeBufferSize.class));
            return new TypeAdapter<AttributeBufferSize>(){

                @Override
                public void write(JsonWriter out, AttributeBufferSize value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public AttributeBufferSize read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AttributeBufferSize.validateJsonObject(jsonObj);
                    AttributeBufferSize instance = (AttributeBufferSize)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

