/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import io.tiledb.cloud.rest_api.v2.model.Datatype;
import io.tiledb.cloud.rest_api.v2.model.DimensionTileExtent;
import io.tiledb.cloud.rest_api.v2.model.DomainArray;
import io.tiledb.cloud.rest_api.v2.model.FilterPipeline;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Dimension of array")
public class Dimension {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private Datatype type;
    public static final String SERIALIZED_NAME_DOMAIN = "domain";
    @SerializedName(value="domain")
    private DomainArray domain;
    public static final String SERIALIZED_NAME_NULL_TILE_EXTENT = "nullTileExtent";
    @SerializedName(value="nullTileExtent")
    private Boolean nullTileExtent;
    public static final String SERIALIZED_NAME_TILE_EXTENT = "tileExtent";
    @SerializedName(value="tileExtent")
    private DimensionTileExtent tileExtent;
    public static final String SERIALIZED_NAME_FILTER_PIPELINE = "filterPipeline";
    @SerializedName(value="filterPipeline")
    private FilterPipeline filterPipeline;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Dimension name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="row", value="Dimension name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Dimension type(Datatype type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Datatype getType() {
        return this.type;
    }

    public void setType(Datatype type) {
        this.type = type;
    }

    public Dimension domain(DomainArray domain) {
        this.domain = domain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public DomainArray getDomain() {
        return this.domain;
    }

    public void setDomain(DomainArray domain) {
        this.domain = domain;
    }

    public Dimension nullTileExtent(Boolean nullTileExtent) {
        this.nullTileExtent = nullTileExtent;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Is tile extent null")
    public Boolean getNullTileExtent() {
        return this.nullTileExtent;
    }

    public void setNullTileExtent(Boolean nullTileExtent) {
        this.nullTileExtent = nullTileExtent;
    }

    public Dimension tileExtent(DimensionTileExtent tileExtent) {
        this.tileExtent = tileExtent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public DimensionTileExtent getTileExtent() {
        return this.tileExtent;
    }

    public void setTileExtent(DimensionTileExtent tileExtent) {
        this.tileExtent = tileExtent;
    }

    public Dimension filterPipeline(FilterPipeline filterPipeline) {
        this.filterPipeline = filterPipeline;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FilterPipeline getFilterPipeline() {
        return this.filterPipeline;
    }

    public void setFilterPipeline(FilterPipeline filterPipeline) {
        this.filterPipeline = filterPipeline;
    }

    public Dimension putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dimension dimension = (Dimension)o;
        return Objects.equals(this.name, dimension.name) && Objects.equals((Object)this.type, (Object)dimension.type) && Objects.equals(this.domain, dimension.domain) && Objects.equals(this.nullTileExtent, dimension.nullTileExtent) && Objects.equals(this.tileExtent, dimension.tileExtent) && Objects.equals(this.filterPipeline, dimension.filterPipeline) && Objects.equals(this.additionalProperties, dimension.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.domain, this.nullTileExtent, this.tileExtent, this.filterPipeline, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Dimension {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    nullTileExtent: ").append(this.toIndentedString(this.nullTileExtent)).append("\n");
        sb.append("    tileExtent: ").append(this.toIndentedString(this.tileExtent)).append("\n");
        sb.append("    filterPipeline: ").append(this.toIndentedString(this.filterPipeline)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Dimension is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DOMAIN) != null) {
            DomainArray.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DOMAIN));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TILE_EXTENT) != null) {
            DimensionTileExtent.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TILE_EXTENT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FILTER_PIPELINE) != null) {
            FilterPipeline.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FILTER_PIPELINE));
        }
    }

    public static Dimension fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, Dimension.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_DOMAIN);
        openapiFields.add(SERIALIZED_NAME_NULL_TILE_EXTENT);
        openapiFields.add(SERIALIZED_NAME_TILE_EXTENT);
        openapiFields.add(SERIALIZED_NAME_FILTER_PIPELINE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_DOMAIN);
        openapiRequiredFields.add(SERIALIZED_NAME_NULL_TILE_EXTENT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Dimension.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<Dimension> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(Dimension.class));
            return new TypeAdapter<Dimension>(){

                @Override
                public void write(JsonWriter out, Dimension value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public Dimension read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Dimension.validateJsonObject(jsonObj);
                    Dimension instance = (Dimension)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

