/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.tiledb.cloud.rest_api.v2.JSON;
import io.tiledb.cloud.rest_api.v2.model.Datatype;
import io.tiledb.cloud.rest_api.v2.model.Dimension;
import io.tiledb.cloud.rest_api.v2.model.Layout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Domain of array")
public class Domain {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private Datatype type;
    public static final String SERIALIZED_NAME_TILE_ORDER = "tileOrder";
    @SerializedName(value="tileOrder")
    private Layout tileOrder;
    public static final String SERIALIZED_NAME_CELL_ORDER = "cellOrder";
    @SerializedName(value="cellOrder")
    private Layout cellOrder;
    public static final String SERIALIZED_NAME_DIMENSIONS = "dimensions";
    @SerializedName(value="dimensions")
    private List<Dimension> dimensions = new ArrayList<Dimension>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Domain type(Datatype type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Datatype getType() {
        return this.type;
    }

    public void setType(Datatype type) {
        this.type = type;
    }

    public Domain tileOrder(Layout tileOrder) {
        this.tileOrder = tileOrder;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Layout getTileOrder() {
        return this.tileOrder;
    }

    public void setTileOrder(Layout tileOrder) {
        this.tileOrder = tileOrder;
    }

    public Domain cellOrder(Layout cellOrder) {
        this.cellOrder = cellOrder;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Layout getCellOrder() {
        return this.cellOrder;
    }

    public void setCellOrder(Layout cellOrder) {
        this.cellOrder = cellOrder;
    }

    public Domain dimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public Domain addDimensionsItem(Dimension dimensionsItem) {
        this.dimensions.add(dimensionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Array of dimensions")
    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
    }

    public Domain putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Domain domain = (Domain)o;
        return Objects.equals((Object)this.type, (Object)domain.type) && Objects.equals((Object)this.tileOrder, (Object)domain.tileOrder) && Objects.equals((Object)this.cellOrder, (Object)domain.cellOrder) && Objects.equals(this.dimensions, domain.dimensions) && Objects.equals(this.additionalProperties, domain.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.tileOrder, this.cellOrder, this.dimensions, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Domain {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    tileOrder: ").append(this.toIndentedString((Object)this.tileOrder)).append("\n");
        sb.append("    cellOrder: ").append(this.toIndentedString((Object)this.cellOrder)).append("\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Domain is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        JsonArray jsonArraydimensions = jsonObj.getAsJsonArray(SERIALIZED_NAME_DIMENSIONS);
        if (jsonArraydimensions != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DIMENSIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `dimensions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DIMENSIONS).toString()));
            }
            for (int i = 0; i < jsonArraydimensions.size(); ++i) {
                Dimension.validateJsonObject(jsonArraydimensions.get(i).getAsJsonObject());
            }
        }
    }

    public static Domain fromJson(String jsonString) throws IOException {
        return JSON.getGson().fromJson(jsonString, Domain.class);
    }

    public String toJson() {
        return JSON.getGson().toJson(this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_TILE_ORDER);
        openapiFields.add(SERIALIZED_NAME_CELL_ORDER);
        openapiFields.add(SERIALIZED_NAME_DIMENSIONS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_TILE_ORDER);
        openapiRequiredFields.add(SERIALIZED_NAME_CELL_ORDER);
        openapiRequiredFields.add(SERIALIZED_NAME_DIMENSIONS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Domain.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter<Domain> thisAdapter = gson.getDelegateAdapter(this, TypeToken.get(Domain.class));
            return new TypeAdapter<Domain>(){

                @Override
                public void write(JsonWriter out, Domain value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, obj);
                }

                @Override
                public Domain read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Domain.validateJsonObject(jsonObj);
                    Domain instance = (Domain)thisAdapter.fromJsonTree(jsonObj);
                    for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (entry.getValue().isJsonPrimitive()) {
                            if (entry.getValue().getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                                continue;
                            }
                            if (entry.getValue().getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                        }
                        instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

