/*
 * Decompiled with CFR 0.152.
 */
package io.tiledb.cloud.rest_api.v2.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum FilterType {
    NONE("FILTER_NONE"),
    GZIP("FILTER_GZIP"),
    ZSTD("FILTER_ZSTD"),
    LZ4("FILTER_LZ4"),
    RLE("FILTER_RLE"),
    BZIP2("FILTER_BZIP2"),
    DOUBLE_DELTA("FILTER_DOUBLE_DELTA"),
    BIT_WIDTH_REDUCTION("FILTER_BIT_WIDTH_REDUCTION"),
    BITSHUFFLE("FILTER_BITSHUFFLE"),
    BYTESHUFFLE("FILTER_BYTESHUFFLE"),
    POSITIVE_DELTA("FILTER_POSITIVE_DELTA"),
    SCALE_FLOAT("FILTER_SCALE_FLOAT"),
    WEBP("FILTER_WEBP"),
    CHECKSUM_MD5("FILTER_CHECKSUM_MD5"),
    CHECKSUM_SHA256("FILTER_CHECKSUM_SHA256"),
    DICTIONARY("FILTER_DICTIONARY");

    private String value;

    private FilterType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterType fromValue(String value) {
        for (FilterType b : FilterType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter
    extends TypeAdapter<FilterType> {
        @Override
        public void write(JsonWriter jsonWriter, FilterType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        @Override
        public FilterType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return FilterType.fromValue(value);
        }
    }
}

